/*
 * Decompiled with CFR 0.152.
 */
package com.softcream.signcades;

import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.FileDocument;
import eu.europa.esig.dss.SignatureLevel;
import eu.europa.esig.dss.SignaturePackaging;
import eu.europa.esig.dss.SignatureValue;
import eu.europa.esig.dss.ToBeSigned;
import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.signature.CAdESService;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import eu.europa.esig.dss.token.MSCAPISignatureToken;
import eu.europa.esig.dss.validation.CommonCertificateVerifier;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class App {
    public static void main(String[] stringArray) throws DSSException, IOException {
        Options options = new Options();
        Option option = new Option("c", "certificate-id", true, "certificate id for signing");
        option.setRequired(false);
        options.addOption(option);
        Option option2 = new Option("i", "input", true, "list of files to sign");
        option2.setRequired(false);
        option2.setArgs(-2);
        options.addOption(option2);
        DefaultParser defaultParser = new DefaultParser();
        HelpFormatter helpFormatter = new HelpFormatter();
        CommandLine commandLine = null;
        try {
            commandLine = defaultParser.parse(options, stringArray);
        }
        catch (ParseException parseException) {
            System.out.println(parseException.getMessage());
            helpFormatter.printHelp("signCades", options);
            System.exit(1);
        }
        String string = commandLine.getOptionValue("certificate-id");
        BigInteger bigInteger = new BigInteger("0");
        bigInteger = string.matches(".*[a-zA-Z].*") ? new BigInteger(string, 16) : new BigInteger(string, 10);
        Object[] objectArray = commandLine.getOptionValues("input");
        String string2 = Arrays.toString(objectArray);
        System.out.println(bigInteger);
        System.out.println(string2);
        App.makeCadesSignature(bigInteger, (String[])objectArray);
    }

    public static void makeCadesSignature(BigInteger bigInteger, String[] stringArray) throws DSSException, IOException {
        try (MSCAPISignatureToken mSCAPISignatureToken = new MSCAPISignatureToken();){
            List<DSSPrivateKeyEntry> list = mSCAPISignatureToken.getKeys();
            DSSPrivateKeyEntry object2 = list.get(0);
            for (DSSPrivateKeyEntry object3 : list) {
                System.out.println("Comparing " + object3.getCertificate().getCertificate().getSerialNumber() + " With " + bigInteger);
                System.out.println("Equal?  " + object3.getCertificate().getCertificate().getSerialNumber().compareTo(bigInteger));
                if (object3.getCertificate().getCertificate().getSerialNumber().compareTo(bigInteger) != 0) continue;
                System.out.println("Found matching Cert!");
                object2 = object3;
            }
            CAdESSignatureParameters cAdESSignatureParameters = new CAdESSignatureParameters();
            cAdESSignatureParameters.setSignatureLevel(SignatureLevel.CAdES_BASELINE_B);
            cAdESSignatureParameters.setSignaturePackaging(SignaturePackaging.ENVELOPING);
            cAdESSignatureParameters.setDigestAlgorithm(DigestAlgorithm.SHA256);
            cAdESSignatureParameters.setSigningCertificate(object2.getCertificate());
            cAdESSignatureParameters.setCertificateChain(object2.getCertificateChain());
            CommonCertificateVerifier commonCertificateVerifier = new CommonCertificateVerifier();
            CAdESService cAdESService = new CAdESService(commonCertificateVerifier);
            for (String string : stringArray) {
                if (!new File(string).isFile()) continue;
                FileDocument fileDocument = new FileDocument(string);
                ToBeSigned toBeSigned = cAdESService.getDataToSign(fileDocument, cAdESSignatureParameters);
                DigestAlgorithm digestAlgorithm = cAdESSignatureParameters.getDigestAlgorithm();
                SignatureValue signatureValue = mSCAPISignatureToken.sign(toBeSigned, digestAlgorithm, object2);
                DSSDocument dSSDocument = cAdESService.signDocument(fileDocument, cAdESSignatureParameters, signatureValue);
                dSSDocument.save(string + ".sig");
                System.out.println(object2.getCertificate().getCertificate().getSubjectDN() + " podpisal " + string + ".sig");
            }
        }
    }
}

