/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss;

import eu.europa.esig.dss.DSSException;
import java.util.HashMap;
import java.util.Map;

public enum DigestAlgorithm {
    SHA1("SHA1", "SHA-1", "1.3.14.3.2.26", "http://www.w3.org/2000/09/xmldsig#sha1", 20),
    SHA224("SHA224", "SHA-224", "2.16.840.1.101.3.4.2.4", "http://www.w3.org/2001/04/xmldsig-more#sha224", 28),
    SHA256("SHA256", "SHA-256", "2.16.840.1.101.3.4.2.1", "http://www.w3.org/2001/04/xmlenc#sha256", 32),
    SHA384("SHA384", "SHA-384", "2.16.840.1.101.3.4.2.2", "http://www.w3.org/2001/04/xmldsig-more#sha384", 48),
    SHA512("SHA512", "SHA-512", "2.16.840.1.101.3.4.2.3", "http://www.w3.org/2001/04/xmlenc#sha512", 64),
    SHA3_224("SHA3-224", "SHA3-224", "2.16.840.1.101.3.4.2.7", "http://www.w3.org/2007/05/xmldsig-more#sha3-224", 28),
    SHA3_256("SHA3-256", "SHA3-256", "2.16.840.1.101.3.4.2.8", "http://www.w3.org/2007/05/xmldsig-more#sha3-256", 32),
    SHA3_384("SHA3-384", "SHA3-384", "2.16.840.1.101.3.4.2.9", "http://www.w3.org/2007/05/xmldsig-more#sha3-384", 48),
    SHA3_512("SHA3-512", "SHA3-512", "2.16.840.1.101.3.4.2.10", "http://www.w3.org/2007/05/xmldsig-more#sha3-512", 64),
    RIPEMD160("RIPEMD160", "RIPEMD160", "1.3.36.3.2.1", "http://www.w3.org/2001/04/xmlenc#ripemd160"),
    MD2("MD2", "MD2", "1.2.840.113549.2.2", "http://www.w3.org/2001/04/xmldsig-more#md2"),
    MD5("MD5", "MD5", "1.2.840.113549.2.5", "http://www.w3.org/2001/04/xmldsig-more#md5");

    private final String name;
    private final String javaName;
    private final String oid;
    private final String xmlId;
    private final int saltLength;

    public static DigestAlgorithm forName(String name) {
        DigestAlgorithm algorithm = (DigestAlgorithm)((Object)Registry.ALGORITHMS.get(name));
        if (algorithm == null) {
            throw new DSSException("Unsupported algorithm: " + name + "/" + name);
        }
        return algorithm;
    }

    public static DigestAlgorithm forName(String name, DigestAlgorithm defaultValue) {
        DigestAlgorithm algorithm = (DigestAlgorithm)((Object)Registry.ALGORITHMS.get(name));
        if (algorithm == null) {
            return defaultValue;
        }
        return algorithm;
    }

    public static DigestAlgorithm forOID(String oid) {
        DigestAlgorithm algorithm = (DigestAlgorithm)((Object)Registry.OID_ALGORITHMS.get(oid));
        if (algorithm == null) {
            throw new DSSException("Unsupported algorithm: " + oid);
        }
        return algorithm;
    }

    public static DigestAlgorithm forXML(String xmlName) {
        DigestAlgorithm algorithm = (DigestAlgorithm)((Object)Registry.XML_ALGORITHMS.get(xmlName));
        if (algorithm == null) {
            throw new DSSException("Unsupported algorithm: " + xmlName);
        }
        return algorithm;
    }

    public static DigestAlgorithm forXML(String xmlName, DigestAlgorithm defaultValue) {
        DigestAlgorithm algorithm = (DigestAlgorithm)((Object)Registry.XML_ALGORITHMS.get(xmlName));
        if (algorithm == null) {
            return defaultValue;
        }
        return algorithm;
    }

    private DigestAlgorithm(String name, String javaName, String oid, String xmlId) {
        this(name, javaName, oid, xmlId, 0);
    }

    private DigestAlgorithm(String name, String javaName, String oid, String xmlId, int saltLength) {
        this.name = name;
        this.javaName = javaName;
        this.oid = oid;
        this.xmlId = xmlId;
        this.saltLength = saltLength;
    }

    public String getName() {
        return this.name;
    }

    public String getJavaName() {
        return this.javaName;
    }

    public String getOid() {
        return this.oid;
    }

    public String getXmlId() {
        return this.xmlId;
    }

    public int getSaltLength() {
        return this.saltLength;
    }

    private static class Registry {
        private static final Map<String, DigestAlgorithm> OID_ALGORITHMS = Registry.registerOIDAlgorithms();
        private static final Map<String, DigestAlgorithm> XML_ALGORITHMS = Registry.registerXMLAlgorithms();
        private static final Map<String, DigestAlgorithm> ALGORITHMS = Registry.registerAlgorithms();

        private Registry() {
        }

        private static Map<String, DigestAlgorithm> registerOIDAlgorithms() {
            HashMap<String, DigestAlgorithm> map = new HashMap<String, DigestAlgorithm>();
            for (DigestAlgorithm digestAlgorithm : DigestAlgorithm.values()) {
                map.put(digestAlgorithm.oid, digestAlgorithm);
            }
            return map;
        }

        private static Map<String, DigestAlgorithm> registerXMLAlgorithms() {
            HashMap<String, DigestAlgorithm> map = new HashMap<String, DigestAlgorithm>();
            for (DigestAlgorithm digestAlgorithm : DigestAlgorithm.values()) {
                map.put(digestAlgorithm.xmlId, digestAlgorithm);
            }
            return map;
        }

        private static Map<String, DigestAlgorithm> registerAlgorithms() {
            HashMap<String, DigestAlgorithm> map = new HashMap<String, DigestAlgorithm>();
            for (DigestAlgorithm digestAlgorithm : DigestAlgorithm.values()) {
                map.put(digestAlgorithm.name, digestAlgorithm);
            }
            return map;
        }
    }
}

