/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.Digest;
import eu.europa.esig.dss.DigestAlgorithm;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public abstract class Identifier
implements Serializable {
    private static final long serialVersionUID = 1440382536669604521L;
    private static final DigestAlgorithm DIGEST_ALGO = DigestAlgorithm.SHA256;
    private final Digest id;

    Identifier(byte[] data) {
        this.id = new Digest(DIGEST_ALGO, this.getMessageDigest().digest(data));
    }

    public String asXmlId() {
        return this.id.getHexValue();
    }

    private MessageDigest getMessageDigest() {
        try {
            return MessageDigest.getInstance(DIGEST_ALGO.getJavaName());
        }
        catch (NoSuchAlgorithmException e) {
            throw new DSSException("Unable to initialize MessageDigest", e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Identifier other = (Identifier)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

