/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades;

import eu.europa.esig.dss.DSSASN1Utils;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.x509.CertificateToken;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DLSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.ess.ESSCertID;
import org.bouncycastle.asn1.ess.ESSCertIDv2;
import org.bouncycastle.asn1.ess.SigningCertificate;
import org.bouncycastle.asn1.ess.SigningCertificateV2;
import org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import org.bouncycastle.asn1.ocsp.OCSPResponse;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CMSUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CMSUtils.class);

    private CMSUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getEncoded(CMSSignedData data) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            DEROutputStream deros = new DEROutputStream(baos);
            deros.writeObject(data.toASN1Structure());
            deros.close();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new DSSException(e);
        }
    }

    public static CMSSignedData generateCMSSignedData(CMSSignedDataGenerator generator, CMSTypedData content, boolean encapsulate) {
        try {
            return generator.generate(content, encapsulate);
        }
        catch (CMSException e) {
            throw new DSSException(e);
        }
    }

    public static CMSSignedData generateDetachedCMSSignedData(CMSSignedDataGenerator generator, CMSProcessableByteArray content) throws DSSException {
        return CMSUtils.generateCMSSignedData(generator, content, false);
    }

    public static DERTaggedObject getDERSignedAttributes(SignerInformation signerInformation) {
        try {
            byte[] encodedSignedAttributes = signerInformation.getEncodedSignedAttributes();
            if (encodedSignedAttributes == null) {
                return null;
            }
            ASN1Set asn1Set = (ASN1Set)DSSASN1Utils.toASN1Primitive(encodedSignedAttributes);
            return new DERTaggedObject(false, 0, asn1Set);
        }
        catch (IOException e) {
            throw new DSSException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getSignedContent(CMSTypedData cmsTypedData) {
        if (cmsTypedData == null) {
            throw new DSSException("CMSTypedData is null (should be a detached signature)");
        }
        try (ByteArrayOutputStream originalDocumentData = new ByteArrayOutputStream();){
            cmsTypedData.write(originalDocumentData);
            byte[] byArray = originalDocumentData.toByteArray();
            return byArray;
        }
        catch (IOException | CMSException e) {
            throw new DSSException(e);
        }
    }

    public static AttributeTable getUnsignedAttributes(SignerInformation signerInformation) {
        AttributeTable unsignedAttributes = signerInformation.getUnsignedAttributes();
        return DSSASN1Utils.emptyIfNull(unsignedAttributes);
    }

    public static AttributeTable getSignedAttributes(SignerInformation signerInformation) {
        AttributeTable signedAttributes = signerInformation.getSignedAttributes();
        return DSSASN1Utils.emptyIfNull(signedAttributes);
    }

    public static AttributeTable getAttributesFromByteArray(byte[] encodedAttributes) {
        DLSet dlSet;
        try (ASN1InputStream asn1InputStream = new ASN1InputStream(new ByteArrayInputStream(encodedAttributes));){
            dlSet = (DLSet)asn1InputStream.readObject();
        }
        catch (IOException e) {
            throw new DSSException("Error while reading ASN.1 encoded attributes", e);
        }
        return new AttributeTable(dlSet);
    }

    public static BasicOCSPResp getBasicOcspResp(DERSequence derSequence) {
        BasicOCSPResp basicOCSPResp = null;
        try {
            BasicOCSPResponse basicOcspResponse = BasicOCSPResponse.getInstance(derSequence);
            basicOCSPResp = new BasicOCSPResp(basicOcspResponse);
        }
        catch (Exception e) {
            LOG.error("Impossible to create BasicOCSPResp from DERSequence!", e);
        }
        return basicOCSPResp;
    }

    public static OCSPResp getOcspResp(DERSequence derSequence) {
        OCSPResp ocspResp = null;
        try {
            OCSPResponse ocspResponse = OCSPResponse.getInstance(derSequence);
            ocspResp = new OCSPResp(ocspResponse);
        }
        catch (Exception e) {
            LOG.error("Impossible to create OCSPResp from DERSequence!", e);
        }
        return ocspResp;
    }

    public static BasicOCSPResp getBasicOcspResp(OCSPResp ocspResp) {
        BasicOCSPResp basicOCSPResp = null;
        try {
            Object responseObject = ocspResp.getResponseObject();
            if (responseObject instanceof BasicOCSPResp) {
                basicOCSPResp = (BasicOCSPResp)responseObject;
            } else {
                LOG.warn("Unknown OCSP response type: {}", (Object)responseObject.getClass());
            }
        }
        catch (OCSPException e) {
            LOG.error("Impossible to process OCSPResp!", e);
        }
        return basicOCSPResp;
    }

    public static void addSigningCertificateAttribute(ASN1EncodableVector signedAttributes, DigestAlgorithm digestAlgorithm, CertificateToken signingToken) {
        IssuerSerial issuerSerial = DSSASN1Utils.getIssuerSerial(signingToken);
        byte[] certHash = signingToken.getDigest(digestAlgorithm);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding Certificate Hash {} with algorithm {}", (Object)Utils.toHex(certHash), (Object)digestAlgorithm.getName());
        }
        Attribute attribute = null;
        if (digestAlgorithm == DigestAlgorithm.SHA1) {
            ESSCertID essCertID = new ESSCertID(certHash, issuerSerial);
            SigningCertificate signingCertificate = new SigningCertificate(essCertID);
            attribute = new Attribute(PKCSObjectIdentifiers.id_aa_signingCertificate, new DERSet(signingCertificate));
        } else {
            ESSCertIDv2 essCertIdv2 = null;
            essCertIdv2 = DigestAlgorithm.SHA256 == digestAlgorithm ? new ESSCertIDv2(null, certHash, issuerSerial) : new ESSCertIDv2(DSSASN1Utils.getAlgorithmIdentifier(digestAlgorithm), certHash, issuerSerial);
            SigningCertificateV2 signingCertificateV2 = new SigningCertificateV2(essCertIdv2);
            attribute = new Attribute(PKCSObjectIdentifiers.id_aa_signingCertificateV2, new DERSet(signingCertificateV2));
        }
        signedAttributes.add(attribute);
    }
}

