/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.signature;

import eu.europa.esig.dss.CommonDocument;
import eu.europa.esig.dss.DSSASN1Utils;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.MimeType;
import eu.europa.esig.dss.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.cms.CMSSignedData;

public class CMSSignedDocument
extends CommonDocument {
    protected CMSSignedData signedData;

    public CMSSignedDocument(CMSSignedData data) {
        this.signedData = data;
        if (data == null) {
            throw new NullPointerException("The CMSSignedData cannot be null");
        }
        this.mimeType = MimeType.PKCS7;
    }

    @Override
    public InputStream openStream() {
        return new ByteArrayInputStream(this.getBytes());
    }

    public CMSSignedData getCMSSignedData() {
        return this.signedData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getBytes() {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            DEROutputStream derOutputStream = new DEROutputStream(output);
            byte[] encoded = this.signedData.getEncoded();
            Object asn1Primitive = DSSASN1Utils.toASN1Primitive(encoded);
            derOutputStream.writeObject((ASN1Encodable)asn1Primitive);
            derOutputStream.close();
            byte[] byArray = output.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new DSSException(e);
        }
    }

    public String getBase64Encoded() {
        return Utils.toBase64(this.getBytes());
    }

    @Override
    public String getAbsolutePath() {
        return super.getName();
    }
}

