/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.validation;

import eu.europa.esig.dss.DSSASN1Utils;
import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.cades.validation.CAdESSignatureScopeFinder;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.SignedDocumentValidator;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;

public class CMSDocumentValidator
extends SignedDocumentValidator {
    protected CMSSignedData cmsSignedData;

    public CMSDocumentValidator() {
        super(new CAdESSignatureScopeFinder());
    }

    public CMSDocumentValidator(CMSSignedData cmsSignedData) {
        this();
        this.cmsSignedData = cmsSignedData;
    }

    public CMSDocumentValidator(DSSDocument document) throws DSSException {
        this();
        this.document = document;
        try (InputStream inputStream = document.openStream();){
            this.cmsSignedData = new CMSSignedData(inputStream);
        }
        catch (IOException | CMSException e) {
            throw new DSSException("Not a valid CAdES file", e);
        }
    }

    @Override
    public boolean isSupported(DSSDocument dssDocument) {
        byte firstByte = DSSUtils.readFirstByte(dssDocument);
        return DSSASN1Utils.isASN1SequenceTag(firstByte);
    }

    @Override
    public List<AdvancedSignature> getSignatures() {
        ArrayList<AdvancedSignature> signatures = new ArrayList<AdvancedSignature>();
        if (this.cmsSignedData != null) {
            Iterator<SignerInformation> iterator = this.cmsSignedData.getSignerInfos().getSigners().iterator();
            while (iterator.hasNext()) {
                SignerInformation signerInformationObject;
                SignerInformation signerInformation = signerInformationObject = iterator.next();
                CAdESSignature cadesSignature = new CAdESSignature(this.cmsSignedData, signerInformation, this.validationCertPool);
                if (this.document != null) {
                    cadesSignature.setSignatureFilename(this.document.getName());
                }
                cadesSignature.setDetachedContents(this.detachedContents);
                cadesSignature.setProvidedSigningCertificateToken(this.providedSigningCertificateToken);
                signatures.add(cadesSignature);
            }
        }
        return signatures;
    }

    @Override
    public List<DSSDocument> getOriginalDocuments(String signatureId) throws DSSException {
        if (Utils.isStringBlank(signatureId)) {
            throw new NullPointerException("signatureId");
        }
        ArrayList<DSSDocument> results = new ArrayList<DSSDocument>();
        Iterator<SignerInformation> iterator = this.cmsSignedData.getSignerInfos().getSigners().iterator();
        while (iterator.hasNext()) {
            SignerInformation signerInformationObject;
            SignerInformation signerInformation = signerInformationObject = iterator.next();
            CAdESSignature cadesSignature = new CAdESSignature(this.cmsSignedData, signerInformation, this.validationCertPool);
            cadesSignature.setSignatureFilename(this.document.getName());
            cadesSignature.setDetachedContents(this.detachedContents);
            cadesSignature.setProvidedSigningCertificateToken(this.providedSigningCertificateToken);
            if (!Utils.areStringsEqual(cadesSignature.getId(), signatureId)) continue;
            results.add(cadesSignature.getOriginalDocument());
        }
        return results;
    }
}

