/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.token;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.token.AbstractSignatureTokenConnection;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import eu.europa.esig.dss.token.KSPrivateKeyEntry;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public abstract class AbstractKeyStoreTokenConnection
extends AbstractSignatureTokenConnection {
    abstract KeyStore getKeyStore() throws DSSException;

    abstract KeyStore.PasswordProtection getKeyProtectionParameter();

    @Override
    public List<DSSPrivateKeyEntry> getKeys() throws DSSException {
        ArrayList<DSSPrivateKeyEntry> list = new ArrayList<DSSPrivateKeyEntry>();
        try {
            KeyStore keyStore = this.getKeyStore();
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (keyStore.isKeyEntry(alias)) {
                    KeyStore.PrivateKeyEntry entry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(alias, this.getKeyProtectionParameter());
                    list.add(new KSPrivateKeyEntry(alias, entry));
                    continue;
                }
                LOG.debug("No related/supported key found for alias '{}'", (Object)alias);
            }
        }
        catch (GeneralSecurityException e) {
            throw new DSSException("Unable to retrieve keys from keystore", e);
        }
        return list;
    }

    public DSSPrivateKeyEntry getKey(String alias) {
        return this.getKey(alias, this.getKeyProtectionParameter());
    }

    public DSSPrivateKeyEntry getKey(String alias, KeyStore.PasswordProtection passwordProtection) {
        try {
            KeyStore keyStore = this.getKeyStore();
            if (keyStore.isKeyEntry(alias)) {
                KeyStore.PrivateKeyEntry entry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(alias, passwordProtection);
                return new KSPrivateKeyEntry(alias, entry);
            }
            LOG.debug("No related/supported key found for alias '{}'", (Object)alias);
        }
        catch (GeneralSecurityException e) {
            throw new DSSException("Unable to retrieve key from keystore", e);
        }
        return null;
    }
}

