/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.token;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.EncryptionAlgorithm;
import eu.europa.esig.dss.MaskGenerationFunction;
import eu.europa.esig.dss.SignatureAlgorithm;
import eu.europa.esig.dss.SignatureValue;
import eu.europa.esig.dss.ToBeSigned;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import eu.europa.esig.dss.token.KSPrivateKeyEntry;
import eu.europa.esig.dss.token.SignatureTokenConnection;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSignatureTokenConnection
implements SignatureTokenConnection {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractSignatureTokenConnection.class);

    @Override
    public SignatureValue sign(ToBeSigned toBeSigned, DigestAlgorithm digestAlgorithm, DSSPrivateKeyEntry keyEntry) throws DSSException {
        return this.sign(toBeSigned, digestAlgorithm, null, keyEntry);
    }

    @Override
    public SignatureValue sign(ToBeSigned toBeSigned, DigestAlgorithm digestAlgorithm, MaskGenerationFunction mgf, DSSPrivateKeyEntry keyEntry) throws DSSException {
        if (!(keyEntry instanceof KSPrivateKeyEntry)) {
            throw new IllegalArgumentException("Only KSPrivateKeyEntry are supported");
        }
        EncryptionAlgorithm encryptionAlgorithm = keyEntry.getEncryptionAlgorithm();
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.getAlgorithm(encryptionAlgorithm, digestAlgorithm, mgf);
        String javaSignatureAlgorithm = signatureAlgorithm.getJCEId();
        LOG.info("Signature algorithm : {}", (Object)javaSignatureAlgorithm);
        try {
            Signature signature = this.getSignatureInstance(javaSignatureAlgorithm);
            signature.initSign(((KSPrivateKeyEntry)keyEntry).getPrivateKey());
            if (mgf != null) {
                signature.setParameter(this.createPSSParam(digestAlgorithm));
            }
            signature.update(toBeSigned.getBytes());
            byte[] signatureValue = signature.sign();
            SignatureValue value = new SignatureValue();
            value.setAlgorithm(signatureAlgorithm);
            value.setValue(signatureValue);
            return value;
        }
        catch (Exception e) {
            throw new DSSException(e);
        }
    }

    protected Signature getSignatureInstance(String javaSignatureAlgorithm) throws NoSuchAlgorithmException {
        return Signature.getInstance(javaSignatureAlgorithm);
    }

    protected AlgorithmParameterSpec createPSSParam(DigestAlgorithm digestAlgo) {
        String digestJavaName = digestAlgo.getJavaName();
        return new PSSParameterSpec(digestJavaName, "MGF1", new MGF1ParameterSpec(digestJavaName), digestAlgo.getSaltLength(), 1);
    }
}

