/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.token;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.token.AbstractKeyStoreTokenConnection;
import eu.europa.esig.dss.token.PasswordInputCallback;
import eu.europa.esig.dss.token.PrefilledPasswordCallback;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AuthProvider;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.util.UUID;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import sun.security.pkcs11.wrapper.PKCS11Exception;

public class Pkcs11SignatureToken
extends AbstractKeyStoreTokenConnection {
    private static final String SUN_PKCS11_KEYSTORE_TYPE = "PKCS11";
    private static final String SUN_PKCS11_PROVIDERNAME = "SunPKCS11";
    private static final String SUN_PKCS11_CLASSNAME = "sun.security.pkcs11.SunPKCS11";
    private static final String NEW_LINE = "\n";
    private static final String DOUBLE_QUOTE = "\"";
    private Provider provider;
    private final String pkcs11Path;
    private final PasswordInputCallback callback;
    private final int slotId;
    private final String extraPkcs11Config;

    public Pkcs11SignatureToken(String pkcs11Path) {
        this(pkcs11Path, (PasswordInputCallback)null);
    }

    public Pkcs11SignatureToken(String pkcs11Path, String extraPkcs11Config) {
        this(pkcs11Path, (PasswordInputCallback)null, extraPkcs11Config);
    }

    public Pkcs11SignatureToken(String pkcs11Path, KeyStore.PasswordProtection password) {
        this(pkcs11Path, password, 0);
    }

    public Pkcs11SignatureToken(String pkcs11Path, KeyStore.PasswordProtection password, String extraPkcs11Config) {
        this(pkcs11Path, password, 0, extraPkcs11Config);
    }

    public Pkcs11SignatureToken(String pkcs11Path, PasswordInputCallback callback) {
        this(pkcs11Path, callback, 0);
    }

    public Pkcs11SignatureToken(String pkcs11Path, PasswordInputCallback callback, String extraPkcs11Config) {
        this(pkcs11Path, callback, 0, extraPkcs11Config);
    }

    public Pkcs11SignatureToken(String pkcs11Path, KeyStore.PasswordProtection password, int slotId) {
        this(pkcs11Path, (PasswordInputCallback)new PrefilledPasswordCallback(password), slotId);
    }

    public Pkcs11SignatureToken(String pkcs11Path, KeyStore.PasswordProtection password, int slotId, String extraPkcs11Config) {
        this(pkcs11Path, new PrefilledPasswordCallback(password), slotId, extraPkcs11Config);
    }

    public Pkcs11SignatureToken(String pkcs11Path, PasswordInputCallback callback, int slotId) {
        this(pkcs11Path, callback, slotId, null);
    }

    public Pkcs11SignatureToken(String pkcs11Path, PasswordInputCallback callback, int slotId, String extraPkcs11Config) {
        this.pkcs11Path = pkcs11Path;
        this.callback = callback;
        this.slotId = slotId;
        this.extraPkcs11Config = extraPkcs11Config;
    }

    protected Provider getProvider() {
        if (this.provider == null) {
            String configString = this.buildConfig();
            LOG.debug("PKCS11 Config : \n{}", (Object)configString);
            this.provider = this.isJavaGreaterOrEquals9() ? this.getProviderJavaGreaterOrEquals9(configString) : this.getProviderJavaLowerThan9(configString);
            if (this.provider == null) {
                throw new DSSException("Unable to create PKCS11 provider");
            }
            Security.addProvider(this.provider);
        }
        return this.provider;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Provider getProviderJavaLowerThan9(String configString) {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(configString.getBytes());){
            Class<?> sunPkcs11ProviderClass = Class.forName(SUN_PKCS11_CLASSNAME);
            Constructor<?> constructor = sunPkcs11ProviderClass.getConstructor(InputStream.class);
            Provider provider = (Provider)constructor.newInstance(bais);
            return provider;
        }
        catch (Exception e) {
            throw new DSSException("Unable to instantiate PKCS11 (JDK < 9) ", e);
        }
    }

    private boolean isJavaGreaterOrEquals9() {
        try {
            Provider provider = Security.getProvider(SUN_PKCS11_PROVIDERNAME);
            if (provider != null) {
                Method configureMethod = provider.getClass().getMethod("configure", String.class);
                return configureMethod != null;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return false;
    }

    private Provider getProviderJavaGreaterOrEquals9(String configString) {
        try {
            Provider provider = Security.getProvider(SUN_PKCS11_PROVIDERNAME);
            Method configureMethod = provider.getClass().getMethod("configure", String.class);
            return (Provider)configureMethod.invoke((Object)provider, "--" + configString);
        }
        catch (Exception e) {
            throw new DSSException("Unable to instantiate PKCS11 (JDK >= 9)", e);
        }
    }

    protected String buildConfig() {
        String aPKCS11LibraryFileName = this.getPkcs11Path();
        aPKCS11LibraryFileName = this.escapePath(aPKCS11LibraryFileName);
        StringBuilder pkcs11Config = new StringBuilder();
        pkcs11Config.append("name = SmartCard").append(UUID.randomUUID());
        pkcs11Config.append(NEW_LINE).append("library = ").append(DOUBLE_QUOTE).append(aPKCS11LibraryFileName).append(DOUBLE_QUOTE);
        pkcs11Config.append(NEW_LINE).append("slot = ").append(this.slotId);
        if (this.extraPkcs11Config != null && !this.extraPkcs11Config.isEmpty()) {
            pkcs11Config.append(NEW_LINE).append(this.extraPkcs11Config);
        }
        return pkcs11Config.toString();
    }

    protected String escapePath(String pathToEscape) {
        if (pathToEscape != null) {
            return pathToEscape.replace("\\", "\\\\");
        }
        return "";
    }

    @Override
    KeyStore getKeyStore() throws DSSException {
        try {
            KeyStore keyStore = KeyStore.getInstance(SUN_PKCS11_KEYSTORE_TYPE, this.getProvider());
            keyStore.load(new KeyStore.LoadStoreParameter(){

                @Override
                public KeyStore.ProtectionParameter getProtectionParameter() {
                    return new KeyStore.CallbackHandlerProtection(new CallbackHandler(){

                        @Override
                        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                            for (Callback c : callbacks) {
                                if (!(c instanceof PasswordCallback)) continue;
                                ((PasswordCallback)c).setPassword(Pkcs11SignatureToken.this.callback.getPassword());
                                return;
                            }
                            throw new DSSException("No password callback");
                        }
                    });
                }
            });
            return keyStore;
        }
        catch (Exception e) {
            if (e instanceof PKCS11Exception && "CKR_PIN_INCORRECT".equals(e.getMessage())) {
                throw new DSSException("Bad password for PKCS11", e);
            }
            throw new DSSException("Can't initialize Sun PKCS#11 security provider. Reason: " + e.getMessage(), e);
        }
    }

    protected String getPkcs11Path() {
        return this.pkcs11Path;
    }

    @Override
    KeyStore.PasswordProtection getKeyProtectionParameter() {
        return null;
    }

    @Override
    protected Signature getSignatureInstance(String javaSignatureAlgorithm) throws NoSuchAlgorithmException {
        return Signature.getInstance(javaSignatureAlgorithm, this.getProvider());
    }

    @Override
    public void close() {
        if (this.provider != null) {
            try {
                try {
                    if (this.provider instanceof AuthProvider) {
                        ((AuthProvider)this.provider).logout();
                        this.provider.clear();
                    }
                }
                catch (LoginException e) {
                    LOG.error("Unable to logout : " + e.getMessage(), e);
                }
                Security.removeProvider(this.provider.getName());
            }
            catch (SecurityException e) {
                LOG.error("Unable to remove provider '" + this.provider.getName() + "'", e);
            }
            finally {
                this.provider = null;
            }
        }
    }
}

