/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.tsl.Condition;
import eu.europa.esig.dss.tsl.MatchingCriteriaIndicator;
import eu.europa.esig.dss.x509.CertificateToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CompositeCondition
extends Condition {
    private static final long serialVersionUID = -3756905347291887068L;
    private MatchingCriteriaIndicator matchingCriteriaIndicator;
    private List<Condition> children = new ArrayList<Condition>();

    public CompositeCondition() {
        this.matchingCriteriaIndicator = MatchingCriteriaIndicator.all;
    }

    public CompositeCondition(MatchingCriteriaIndicator matchingCriteriaIndicator) {
        this.matchingCriteriaIndicator = matchingCriteriaIndicator;
    }

    public final List<Condition> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public void addChild(Condition condition) {
        this.children.add(condition);
    }

    public MatchingCriteriaIndicator getMatchingCriteriaIndicator() {
        return this.matchingCriteriaIndicator;
    }

    @Override
    public boolean check(CertificateToken certificateToken) {
        switch (this.matchingCriteriaIndicator) {
            case all: {
                for (Condition condition : this.children) {
                    if (condition.check(certificateToken)) continue;
                    return false;
                }
                return true;
            }
            case atLeastOne: {
                for (Condition condition : this.children) {
                    if (!condition.check(certificateToken)) continue;
                    return true;
                }
                return false;
            }
            case none: {
                for (Condition condition : this.children) {
                    if (!condition.check(certificateToken)) continue;
                    return false;
                }
                return true;
            }
        }
        throw new DSSException("Unsupported MatchingCriteriaIndicator : " + (Object)((Object)this.matchingCriteriaIndicator));
    }

    @Override
    public String toString(String indent) {
        if (indent == null) {
            indent = "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(indent).append("CriteriaListCondition: ").append(this.matchingCriteriaIndicator.name()).append('\n');
        if (this.children != null) {
            indent = indent + "\t";
            for (Condition condition : this.children) {
                builder.append(condition.toString(indent));
            }
        }
        return builder.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

