/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl;

import eu.europa.esig.dss.CertificatePolicy;
import eu.europa.esig.dss.DSSASN1Utils;
import eu.europa.esig.dss.tsl.Condition;
import eu.europa.esig.dss.x509.CertificateToken;
import java.util.List;

public class PolicyIdCondition
extends Condition {
    private static final long serialVersionUID = 7590885101177874819L;
    private final String policyOid;

    public PolicyIdCondition(String policyId) {
        if (policyId == null) {
            throw new NullPointerException("policyId");
        }
        this.policyOid = policyId;
    }

    public final String getPolicyOid() {
        return this.policyOid;
    }

    @Override
    public boolean check(CertificateToken certificateToken) {
        if (certificateToken == null) {
            throw new NullPointerException();
        }
        List<CertificatePolicy> contextPolicyIdentifiers = DSSASN1Utils.getCertificatePolicies(certificateToken);
        for (CertificatePolicy certificatePolicy : contextPolicyIdentifiers) {
            if (!this.policyOid.equals(certificatePolicy.getOid())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString(String indent) {
        if (indent == null) {
            indent = "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(indent).append("PolicyIdCondition: ").append(this.policyOid).append('\n');
        return builder.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

