/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl;

import eu.europa.esig.dss.tsl.ServiceInfo;
import eu.europa.esig.dss.tsl.ServiceInfoStatus;
import eu.europa.esig.dss.tsl.TLInfo;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.x509.CertificateSourceType;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.CommonTrustedCertificateSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustedListsCertificateSource
extends CommonTrustedCertificateSource {
    private static final Logger LOG = LoggerFactory.getLogger(TrustedListsCertificateSource.class);
    private Map<String, TLInfo> tlInfos = new HashMap<String, TLInfo>();
    private Map<String, List<ServiceInfo>> trustServicesByEntity = new HashMap<String, List<ServiceInfo>>();

    @Override
    public CertificateSourceType getCertificateSourceType() {
        return CertificateSourceType.TRUSTED_LIST;
    }

    public void reinit() {
        this.tlInfos = new HashMap<String, TLInfo>();
        this.trustServicesByEntity = new HashMap<String, List<ServiceInfo>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCertificate(CertificateToken certificate, List<ServiceInfo> serviceInfos) {
        certificate = super.addCertificate(certificate);
        String entityKey = certificate.getEntityKey();
        Map<String, List<ServiceInfo>> map = this.trustServicesByEntity;
        synchronized (map) {
            if (this.trustServicesByEntity.containsKey(entityKey)) {
                List<ServiceInfo> storedServiceInfos = this.trustServicesByEntity.get(entityKey);
                if (!Arrays.equals(serviceInfos.toArray(new ServiceInfo[serviceInfos.size()]), storedServiceInfos.toArray(new ServiceInfo[storedServiceInfos.size()]))) {
                    storedServiceInfos.addAll(serviceInfos);
                }
            } else {
                this.trustServicesByEntity.put(entityKey, serviceInfos);
            }
        }
    }

    @Override
    public CertificateToken addCertificate(CertificateToken certificate) {
        throw new UnsupportedOperationException("Cannot directly add certificate to a TrustedListsCertificateSource");
    }

    public void updateTlInfo(String countryCode, TLInfo info) {
        this.tlInfos.put(countryCode, info);
    }

    public TLInfo getTlInfo(String countryCode) {
        return this.tlInfos.get(countryCode);
    }

    public TLInfo getLotlInfo() {
        for (TLInfo tlInfo : this.tlInfos.values()) {
            if (!tlInfo.isLotl()) continue;
            return tlInfo;
        }
        return null;
    }

    public Map<String, TLInfo> getSummary() {
        return this.tlInfos;
    }

    @Override
    public Set<ServiceInfo> getTrustServices(CertificateToken token) {
        List<ServiceInfo> trustServicesForToken = this.trustServicesByEntity.get(token.getEntityKey());
        if (trustServicesForToken != null) {
            return new HashSet<ServiceInfo>(trustServicesForToken);
        }
        return Collections.emptySet();
    }

    @Override
    public List<String> getAlternativeOCSPUrls(CertificateToken trustAnchor) {
        return this.getServiceSupplyPoints(trustAnchor, "ocsp");
    }

    @Override
    public List<String> getAlternativeCRLUrls(CertificateToken trustAnchor) {
        return this.getServiceSupplyPoints(trustAnchor, "crl", "certificateRevocationList");
    }

    private List<String> getServiceSupplyPoints(CertificateToken trustAnchor, String ... keywords) {
        ArrayList<String> urls = new ArrayList<String>();
        Set<ServiceInfo> trustServices = this.getTrustServices(trustAnchor);
        for (ServiceInfo serviceInfo : trustServices) {
            for (ServiceInfoStatus serviceInfoStatus : serviceInfo.getStatus()) {
                List<String> serviceSupplyPoints = serviceInfoStatus.getServiceSupplyPoints();
                if (!Utils.isCollectionNotEmpty(serviceSupplyPoints)) continue;
                for (String serviceSupplyPoint : serviceSupplyPoints) {
                    for (String keyword : keywords) {
                        if (!serviceSupplyPoint.contains(keyword)) continue;
                        LOG.debug("ServiceSupplyPoints (TL) found for keyword '{}'", (Object)keyword);
                        urls.add(serviceSupplyPoint);
                    }
                }
            }
        }
        return urls;
    }

    public int getNumberOfTrustedPublicKeys() {
        return this.trustServicesByEntity.size();
    }
}

