/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.DSSASN1Utils;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.x509.CertificatePool;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.SignatureCertificateSource;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.ess.OtherCertID;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAdESCertificateSource
extends SignatureCertificateSource {
    private static final Logger LOG = LoggerFactory.getLogger(CAdESCertificateSource.class);
    private List<CertificateToken> keyInfoCerts;
    private List<CertificateToken> encapsulatedCerts;

    public CAdESCertificateSource(CMSSignedData cmsSignedData, CertificatePool certPool) {
        super(certPool);
        Objects.requireNonNull(cmsSignedData, "CMS SignedData is null, it must be provided!");
        this.keyInfoCerts = this.extractIdSignedDataCertificates(cmsSignedData);
        this.encapsulatedCerts = this.extractEncapsulatedCertificates(cmsSignedData);
    }

    @Override
    public List<CertificateToken> getEncapsulatedCertificates() {
        return this.encapsulatedCerts;
    }

    private List<CertificateToken> extractEncapsulatedCertificates(CMSSignedData cmsSignedData) {
        ArrayList<CertificateToken> currentCerts = new ArrayList<CertificateToken>();
        SignerInformation signerInformation = DSSASN1Utils.getFirstSignerInformation(cmsSignedData);
        if (signerInformation != null && signerInformation.getUnsignedAttributes() != null) {
            AttributeTable unsignedAttributes = signerInformation.getUnsignedAttributes();
            this.extractCertificateFromUnsignedAttribute(currentCerts, unsignedAttributes.get(PKCSObjectIdentifiers.id_aa_ets_certValues));
            this.extractCertificateRefsFromUnsignedAttribute(currentCerts, unsignedAttributes.get(PKCSObjectIdentifiers.id_aa_ets_certificateRefs));
        }
        return currentCerts;
    }

    private void extractCertificateFromUnsignedAttribute(List<CertificateToken> encapsulatedCerts, Attribute attribute) {
        if (attribute != null) {
            ASN1Sequence seq = (ASN1Sequence)attribute.getAttrValues().getObjectAt(0);
            for (int ii = 0; ii < seq.size(); ++ii) {
                try {
                    Certificate cs = Certificate.getInstance(seq.getObjectAt(ii));
                    CertificateToken certToken = this.addCertificate(DSSUtils.loadCertificate(cs.getEncoded()));
                    if (encapsulatedCerts.contains(certToken)) continue;
                    encapsulatedCerts.add(certToken);
                    continue;
                }
                catch (Exception e) {
                    LOG.warn("Unable to parse encapsulated certificate : {}", (Object)e.getMessage());
                }
            }
        }
    }

    private void extractCertificateRefsFromUnsignedAttribute(List<CertificateToken> encapsulatedCertRefs, Attribute attribute) {
        if (attribute != null) {
            ASN1Sequence seq = (ASN1Sequence)attribute.getAttrValues().getObjectAt(0);
            for (int ii = 0; ii < seq.size(); ++ii) {
                try {
                    OtherCertID otherCertId = OtherCertID.getInstance(seq.getObjectAt(ii));
                    byte[] expectedCertHash = otherCertId.getCertHash();
                    DigestAlgorithm digestAlgo = DigestAlgorithm.forOID(otherCertId.getAlgorithmHash().getAlgorithm().getId());
                    BigInteger expectedSerialNumber = null;
                    if (otherCertId.getIssuerSerial() != null) {
                        expectedSerialNumber = otherCertId.getIssuerSerial().getSerial().getValue();
                    }
                    boolean found = false;
                    List<CertificateToken> certificates = this.getCertificates();
                    for (CertificateToken certificateToken : certificates) {
                        byte[] certHash = certificateToken.getDigest(digestAlgo);
                        if (!Arrays.equals(expectedCertHash, certHash) || expectedSerialNumber != null && !expectedSerialNumber.equals(certificateToken.getSerialNumber())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    LOG.warn("Certificate Ref (SN:{} / {}:{}) is not known", new Object[]{expectedSerialNumber, digestAlgo, Utils.toBase64(expectedCertHash)});
                    continue;
                }
                catch (Exception e) {
                    LOG.warn("Unable to parse encapsulated OtherCertID : {}", (Object)e.getMessage());
                }
            }
        }
    }

    @Override
    public List<CertificateToken> getKeyInfoCertificates() {
        return this.keyInfoCerts;
    }

    private List<CertificateToken> extractIdSignedDataCertificates(CMSSignedData cmsSignedData) {
        ArrayList<CertificateToken> essCertIDCerts = new ArrayList<CertificateToken>();
        try {
            Collection<X509CertificateHolder> x509CertificateHolders = cmsSignedData.getCertificates().getMatches(null);
            for (X509CertificateHolder x509CertificateHolder : x509CertificateHolders) {
                CertificateToken x509Certificate = DSSASN1Utils.getCertificate(x509CertificateHolder);
                CertificateToken certificateToken = this.addCertificate(x509Certificate);
                if (essCertIDCerts.contains(certificateToken)) continue;
                essCertIDCerts.add(certificateToken);
            }
        }
        catch (Exception e) {
            LOG.warn("Cannot extract certificates from CMS Signed Data : {}", (Object)e.getMessage());
        }
        return essCertIDCerts;
    }
}

