/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.validation.CertificateStatusVerifier;
import eu.europa.esig.dss.x509.CertificatePool;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.RevocationSource;
import eu.europa.esig.dss.x509.RevocationToken;
import eu.europa.esig.dss.x509.crl.CRLToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRLCertificateVerifier
implements CertificateStatusVerifier {
    private static final Logger LOG = LoggerFactory.getLogger(CRLCertificateVerifier.class);
    private final RevocationSource<CRLToken> crlSource;
    private final CertificatePool validationCertPool;

    public CRLCertificateVerifier(RevocationSource<CRLToken> crlSource, CertificatePool validationCertPool) {
        this.crlSource = crlSource;
        this.validationCertPool = validationCertPool;
    }

    @Override
    public RevocationToken check(CertificateToken certificateToken) {
        try {
            if (this.crlSource == null) {
                LOG.debug("CRLSource is null");
                return null;
            }
            CertificateToken issuerToken = this.validationCertPool.getIssuer(certificateToken);
            if (issuerToken == null) {
                LOG.debug("Issuer is null");
                return null;
            }
            CRLToken crlToken = this.crlSource.getRevocationToken(certificateToken, issuerToken);
            if (crlToken == null) {
                LOG.debug("{} : No CRL found for: {}", (Object)this.crlSource.getClass().getSimpleName(), (Object)certificateToken.getDSSIdAsString());
                return null;
            }
            crlToken.setRelatedCertificateID(certificateToken.getDSSIdAsString());
            if (!crlToken.isValid()) {
                LOG.warn("{} : The CRL is not valid !", (Object)this.crlSource.getClass().getSimpleName());
                return null;
            }
            return crlToken;
        }
        catch (Exception e) {
            LOG.error("Exception when accessing CRL for " + certificateToken.getDSSIdAsString(), e);
            return null;
        }
    }
}

