/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.jaxb.diagnostic.DiagnosticData;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.DiagnosticDataBuilder;
import eu.europa.esig.dss.validation.SignatureValidationContext;
import eu.europa.esig.dss.validation.ValidationResourceManager;
import eu.europa.esig.dss.validation.executor.CertificateProcessExecutor;
import eu.europa.esig.dss.validation.policy.EtsiValidationPolicy;
import eu.europa.esig.dss.validation.policy.ValidationPolicy;
import eu.europa.esig.dss.validation.reports.CertificateReports;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.jaxb.policy.ConstraintsParameters;
import java.util.Date;
import java.util.Objects;

public class CertificateValidator {
    private Date validationTime = new Date();
    private final CertificateToken token;
    private CertificateVerifier certificateVerifier;

    private CertificateValidator(CertificateToken token) {
        Objects.requireNonNull(token, "The certificate is missing");
        this.token = token;
    }

    public static CertificateValidator fromCertificate(CertificateToken token) {
        return new CertificateValidator(token);
    }

    public void setCertificateVerifier(CertificateVerifier certificateVerifier) {
        this.certificateVerifier = certificateVerifier;
    }

    public void setValidationTime(Date validationTime) {
        this.validationTime = validationTime;
    }

    public CertificateReports validate() {
        ConstraintsParameters validationPolicyJaxb = ValidationResourceManager.loadPolicyData(null);
        EtsiValidationPolicy validationPolicy = new EtsiValidationPolicy(validationPolicyJaxb);
        return this.validate(validationPolicy);
    }

    public CertificateReports validate(ValidationPolicy validationPolicy) {
        SignatureValidationContext svc = new SignatureValidationContext();
        svc.initialize(this.certificateVerifier);
        svc.addCertificateTokenForVerification(this.token);
        svc.setCurrentTime(this.validationTime);
        svc.validate();
        DiagnosticData diagnosticData = new DiagnosticDataBuilder().usedCertificates(svc.getProcessedCertificates()).usedRevocations(svc.getProcessedRevocations()).includeRawCertificateTokens(this.certificateVerifier.isIncludeCertificateTokenValues()).includeRawRevocationData(this.certificateVerifier.isIncludeCertificateRevocationValues()).certificateSourceTypes(svc.getCertificateSourceTypes()).trustedCertificateSource(this.certificateVerifier.getTrustedCertSource()).validationDate(svc.getCurrentTime()).build();
        CertificateProcessExecutor executor = this.provideProcessExecutorInstance();
        executor.setValidationPolicy(validationPolicy);
        executor.setDiagnosticData(diagnosticData);
        executor.setCertificateId(this.token.getDSSIdAsString());
        executor.setCurrentTime(svc.getCurrentTime());
        return executor.execute();
    }

    public CertificateProcessExecutor provideProcessExecutorInstance() {
        return new CertificateProcessExecutor();
    }
}

