/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.validation.CRLCertificateVerifier;
import eu.europa.esig.dss.validation.CertificateStatusVerifier;
import eu.europa.esig.dss.validation.OCSPCertificateVerifier;
import eu.europa.esig.dss.x509.CertificatePool;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.RevocationSource;
import eu.europa.esig.dss.x509.RevocationToken;
import eu.europa.esig.dss.x509.crl.CRLToken;
import eu.europa.esig.dss.x509.ocsp.OCSPToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCSPAndCRLCertificateVerifier
implements CertificateStatusVerifier {
    private static final Logger LOG = LoggerFactory.getLogger(OCSPAndCRLCertificateVerifier.class);
    private final RevocationSource<OCSPToken> ocspSource;
    private final RevocationSource<CRLToken> crlSource;
    private final CertificatePool validationCertPool;

    public OCSPAndCRLCertificateVerifier(RevocationSource<CRLToken> crlSource, RevocationSource<OCSPToken> ocspSource, CertificatePool validationCertPool) {
        this.crlSource = crlSource;
        this.ocspSource = ocspSource;
        this.validationCertPool = validationCertPool;
    }

    @Override
    public RevocationToken check(CertificateToken certificateToken) {
        RevocationToken result;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Check revocation for certificate : {}", (Object)certificateToken.getDSSIdAsString());
        }
        if ((result = this.checkOCSP(certificateToken)) != null) {
            return result;
        }
        result = this.checkCRL(certificateToken);
        if (result != null) {
            return result;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("There is no response for {} neither from OCSP nor from CRL!", (Object)certificateToken.getDSSIdAsString());
        }
        return null;
    }

    public RevocationToken checkOCSP(CertificateToken certificateToken) {
        if (this.ocspSource != null) {
            RevocationToken revocation;
            OCSPCertificateVerifier ocspVerifier = new OCSPCertificateVerifier(this.ocspSource, this.validationCertPool);
            if (LOG.isDebugEnabled()) {
                LOG.debug("OCSP request for: {} using: {}", (Object)certificateToken.getDSSIdAsString(), (Object)this.ocspSource.getClass().getSimpleName());
            }
            if ((revocation = ocspVerifier.check(certificateToken)) != null && revocation.getStatus() != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("OCSP response for {} retrieved: {}", (Object)certificateToken.getDSSIdAsString(), (Object)revocation.getAbbreviation());
                }
                return revocation;
            }
        }
        return null;
    }

    public RevocationToken checkCRL(CertificateToken certificateToken) {
        if (this.crlSource != null) {
            RevocationToken revocationToken;
            CRLCertificateVerifier crlVerifier = new CRLCertificateVerifier(this.crlSource, this.validationCertPool);
            if (LOG.isDebugEnabled()) {
                LOG.debug("CRL request for: {} using: {}", (Object)certificateToken.getDSSIdAsString(), (Object)this.crlSource.getClass().getSimpleName());
            }
            if ((revocationToken = crlVerifier.check(certificateToken)) != null && revocationToken.getStatus() != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("CRL for {} retrieved: {}", (Object)certificateToken.getDSSIdAsString(), (Object)revocationToken.getAbbreviation());
                }
                return revocationToken;
            }
        }
        return null;
    }
}

