/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSRevocationUtils;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.utils.Utils;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.Arrays;
import org.bouncycastle.asn1.esf.OtherHash;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCSPRef {
    private static final Logger LOG = LoggerFactory.getLogger(OCSPRef.class);
    private DigestAlgorithm digestAlgorithm = null;
    private byte[] digestValue = DSSUtils.EMPTY_BYTE_ARRAY;
    private final boolean matchOnlyBasicOCSPResponse;

    public OCSPRef(OtherHash otherHash, boolean matchOnlyBasicOCSPResponse) {
        if (otherHash != null) {
            this.digestAlgorithm = DigestAlgorithm.forOID(otherHash.getHashAlgorithm().getAlgorithm().getId());
            this.digestValue = otherHash.getHashValue();
        }
        this.matchOnlyBasicOCSPResponse = matchOnlyBasicOCSPResponse;
    }

    public OCSPRef(DigestAlgorithm algorithm, byte[] digestValue, boolean matchOnlyBasicOCSPResponse) {
        this.digestAlgorithm = algorithm;
        this.digestValue = digestValue;
        this.matchOnlyBasicOCSPResponse = matchOnlyBasicOCSPResponse;
    }

    public boolean match(BasicOCSPResp ocspResp) {
        if (this.digestAlgorithm == null) {
            return false;
        }
        try {
            MessageDigest digest = DSSUtils.getMessageDigest(this.digestAlgorithm);
            if (this.matchOnlyBasicOCSPResponse) {
                digest.update(ocspResp.getEncoded());
            } else {
                digest.update(DSSRevocationUtils.fromBasicToResp(ocspResp).getEncoded());
            }
            byte[] computedValue = digest.digest();
            if (LOG.isInfoEnabled()) {
                LOG.info("Compare " + Utils.toHex(this.digestValue) + " to computed value " + Utils.toHex(computedValue) + " of BasicOCSPResp produced at " + ocspResp.getProducedAt());
            }
            return Arrays.equals(this.digestValue, computedValue);
        }
        catch (IOException e) {
            throw new DSSException(e);
        }
    }

    public DigestAlgorithm getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public byte[] getDigestValue() {
        return this.digestValue;
    }
}

