/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.InMemoryDocument;
import eu.europa.esig.dss.client.http.DataLoader;
import eu.europa.esig.dss.utils.Utils;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignaturePolicyProvider {
    private static final Logger LOG = LoggerFactory.getLogger(SignaturePolicyProvider.class);
    private DataLoader dataLoader;
    private Map<String, DSSDocument> signaturePoliciesById = new HashMap<String, DSSDocument>();
    private Map<String, DSSDocument> signaturePoliciesByUrl = new HashMap<String, DSSDocument>();

    public DataLoader getDataLoader() {
        return this.dataLoader;
    }

    public void setDataLoader(DataLoader dataLoader) {
        this.dataLoader = dataLoader;
    }

    public Map<String, DSSDocument> getSignaturePoliciesById() {
        return this.signaturePoliciesById;
    }

    public void setSignaturePoliciesById(Map<String, DSSDocument> signaturePoliciesById) {
        this.signaturePoliciesById = signaturePoliciesById;
    }

    public DSSDocument getSignaturePolicyById(String policyId) {
        return this.signaturePoliciesById.get(policyId);
    }

    public Map<String, DSSDocument> getSignaturePoliciesByUrl() {
        return this.signaturePoliciesByUrl;
    }

    public void setSignaturePoliciesByUrl(Map<String, DSSDocument> signaturePoliciesByUrl) {
        this.signaturePoliciesByUrl = signaturePoliciesByUrl;
    }

    public DSSDocument getSignaturePolicyByUrl(String url) {
        DSSDocument dssDocument = this.signaturePoliciesByUrl.get(url);
        if (dssDocument == null && Utils.isStringNotBlank(url) && this.dataLoader != null) {
            try {
                byte[] bytes = this.dataLoader.get(url);
                if (Utils.isArrayEmpty(bytes)) {
                    LOG.warn("Empty content for url '{}'", (Object)url);
                    return null;
                }
                dssDocument = new InMemoryDocument(bytes);
                this.signaturePoliciesByUrl.put(url, dssDocument);
            }
            catch (Exception e) {
                LOG.warn("Unable to download the signature policy with url '{}'", (Object)url, (Object)e);
            }
        }
        return dssDocument;
    }

    public DSSDocument getSignaturePolicy(String policyId, String url) {
        DSSDocument dssDocument = this.getSignaturePolicyById(policyId);
        if (dssDocument == null && (dssDocument = this.getSignaturePolicyByUrl(url)) != null) {
            this.signaturePoliciesById.put(policyId, dssDocument);
        }
        return dssDocument;
    }
}

