/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.TimestampedObjectType;
import java.io.Serializable;

public class TimestampReference
implements Serializable {
    private String signatureId;
    private DigestAlgorithm digestAlgorithm;
    private String digestValue;
    private TimestampedObjectType category;

    public TimestampReference(String signatureId) {
        if (signatureId == null) {
            throw new NullPointerException();
        }
        this.signatureId = signatureId;
        this.digestAlgorithm = DigestAlgorithm.SHA1;
        this.digestValue = Utils.toBase64(DSSUtils.digest(DigestAlgorithm.SHA1, signatureId.getBytes()));
        this.category = TimestampedObjectType.SIGNATURE;
    }

    public TimestampReference(String signatureId, TimestampedObjectType category) {
        this(signatureId);
        this.category = category;
    }

    public TimestampReference(DigestAlgorithm digestAlgorithm, String digestValue) {
        if (digestAlgorithm == null) {
            throw new NullPointerException("digestAlgorithm");
        }
        this.digestAlgorithm = digestAlgorithm;
        if (digestValue == null) {
            throw new NullPointerException("digestValue");
        }
        this.digestValue = digestValue;
        this.category = TimestampedObjectType.CERTIFICATE;
    }

    public TimestampReference(DigestAlgorithm digestAlgorithm, String digestValue, TimestampedObjectType category) {
        this(digestAlgorithm, digestValue);
        this.category = category;
    }

    public DigestAlgorithm getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public String getDigestValue() {
        return this.digestValue;
    }

    public TimestampedObjectType getCategory() {
        return this.category;
    }

    public String getSignatureId() {
        return this.signatureId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimestampReference that = (TimestampReference)o;
        return this.digestValue.equals(that.digestValue);
    }

    public int hashCode() {
        return this.digestValue.hashCode();
    }
}

