/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.DSSASN1Utils;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.EncryptionAlgorithm;
import eu.europa.esig.dss.SignatureAlgorithm;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.TimestampCertificateSource;
import eu.europa.esig.dss.validation.TimestampInclude;
import eu.europa.esig.dss.validation.TimestampReference;
import eu.europa.esig.dss.x509.ArchiveTimestampType;
import eu.europa.esig.dss.x509.CertificatePool;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.TimestampType;
import eu.europa.esig.dss.x509.Token;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.tsp.TimeStampTokenInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimestampToken
extends Token {
    private static final Logger LOG = LoggerFactory.getLogger(TimestampToken.class);
    private final TimeStampToken timeStamp;
    private final TimestampType timeStampType;
    private final TimestampCertificateSource certificateSource;
    private boolean processed = false;
    private boolean messageImprintData;
    private Boolean messageImprintIntact = null;
    private List<TimestampReference> timestampedReferences;
    private List<TimestampInclude> timestampIncludes;
    private ArchiveTimestampType archiveTimestampType;
    private String canonicalizationMethod;
    private X500Principal tsaX500Principal;
    private int hashCode;

    public TimestampToken(byte[] binaries, TimestampType type, CertificatePool certPool) throws TSPException, IOException, CMSException {
        this(new CMSSignedData(binaries), type, certPool);
    }

    public TimestampToken(CMSSignedData cms, TimestampType type, CertificatePool certPool) throws TSPException, IOException {
        this(new TimeStampToken(cms), type, certPool);
    }

    public TimestampToken(TimeStampToken timeStamp, TimestampType type) {
        this(timeStamp, type, new CertificatePool());
    }

    public TimestampToken(TimeStampToken timeStamp, TimestampType type, CertificatePool certPool) {
        this.timeStamp = timeStamp;
        this.timeStampType = type;
        this.certificateSource = new TimestampCertificateSource(timeStamp, certPool);
    }

    @Override
    public X500Principal getIssuerX500Principal() {
        return this.tsaX500Principal;
    }

    @Override
    public String getAbbreviation() {
        return this.timeStampType.name() + ": " + this.getDSSIdAsString() + ": " + DSSUtils.formatInternal(this.timeStamp.getTimeStampInfo().getGenTime());
    }

    @Override
    protected boolean checkIsSignedBy(CertificateToken candidate) {
        X509CertificateHolder x509CertificateHolder = DSSASN1Utils.getX509CertificateHolder(candidate);
        if (this.timeStamp.getSID().match(x509CertificateHolder)) {
            try {
                JcaSimpleSignerInfoVerifierBuilder verifierBuilder = new JcaSimpleSignerInfoVerifierBuilder();
                SignerInformationVerifier verifier = verifierBuilder.build(candidate.getCertificate());
                this.timeStamp.validate(verifier);
                this.signatureValid = true;
                this.tsaX500Principal = candidate.getSubjectX500Principal();
                String algorithm = candidate.getPublicKey().getAlgorithm();
                EncryptionAlgorithm encryptionAlgorithm = EncryptionAlgorithm.forName(algorithm);
                AlgorithmIdentifier hashAlgorithm = this.timeStamp.getTimeStampInfo().getHashAlgorithm();
                DigestAlgorithm digestAlgorithm = DigestAlgorithm.forOID(hashAlgorithm.getAlgorithm().getId());
                this.signatureAlgorithm = SignatureAlgorithm.getAlgorithm(encryptionAlgorithm, digestAlgorithm);
            }
            catch (Exception e) {
                this.signatureValid = false;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Unable to validate timestamp token : ", e);
                } else {
                    LOG.warn("Unable to validate timestamp token : {}", (Object)e.getMessage());
                }
                this.signatureInvalidityReason = e.getClass().getSimpleName() + " : " + e.getMessage();
            }
            return this.signatureValid;
        }
        return false;
    }

    public boolean matchData(byte[] data) {
        return this.matchData(data, false);
    }

    public boolean matchData(byte[] data, boolean suppressMatchWarnings) {
        this.processed = true;
        this.messageImprintData = data != null;
        this.messageImprintIntact = false;
        if (this.messageImprintData) {
            try {
                TimeStampTokenInfo timeStampInfo = this.timeStamp.getTimeStampInfo();
                ASN1ObjectIdentifier hashAlgorithm = timeStampInfo.getHashAlgorithm().getAlgorithm();
                DigestAlgorithm digestAlgorithm = DigestAlgorithm.forOID(hashAlgorithm.getId());
                byte[] computedDigest = DSSUtils.digest(digestAlgorithm, data);
                byte[] timestampDigest = timeStampInfo.getMessageImprintDigest();
                this.messageImprintIntact = Arrays.equals(computedDigest, timestampDigest);
                if (!this.messageImprintIntact.booleanValue() && !suppressMatchWarnings) {
                    LOG.warn("Computed digest ({}) on the extracted data from the document : {}", (Object)digestAlgorithm, (Object)Utils.toHex(computedDigest));
                    LOG.warn("Digest present in TimestampToken: {}", (Object)Utils.toHex(timestampDigest));
                    LOG.warn("Digest in TimestampToken matches digest of extracted data from document: {}", (Object)this.messageImprintIntact);
                }
            }
            catch (DSSException e) {
                LOG.warn("Unable to validate the timestamp", e);
            }
        } else {
            LOG.warn("Timestamped data not found !");
        }
        return this.messageImprintIntact;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public TimestampType getTimeStampType() {
        return this.timeStampType;
    }

    public Date getGenerationTime() {
        return this.timeStamp.getTimeStampInfo().getGenTime();
    }

    @Override
    public Date getCreationDate() {
        return this.getGenerationTime();
    }

    public DigestAlgorithm getSignedDataDigestAlgo() {
        ASN1ObjectIdentifier oid = this.timeStamp.getTimeStampInfo().getHashAlgorithm().getAlgorithm();
        return DigestAlgorithm.forOID(oid.getId());
    }

    public String getEncodedSignedDataDigestValue() {
        byte[] messageImprintDigest = this.timeStamp.getTimeStampInfo().getMessageImprintDigest();
        return Utils.toBase64(messageImprintDigest);
    }

    public Boolean isMessageImprintDataFound() {
        return this.messageImprintData;
    }

    public Boolean isMessageImprintDataIntact() {
        if (this.messageImprintIntact == null) {
            throw new DSSException("Invoke matchData(byte[] data) method before!");
        }
        return this.messageImprintIntact;
    }

    public List<TimestampReference> getTimestampedReferences() {
        return this.timestampedReferences;
    }

    public void setTimestampedReferences(List<TimestampReference> timestampedReferences) {
        this.timestampedReferences = timestampedReferences;
    }

    public ArchiveTimestampType getArchiveTimestampType() {
        return this.archiveTimestampType;
    }

    public void setArchiveTimestampType(ArchiveTimestampType archiveTimestampType) {
        this.archiveTimestampType = archiveTimestampType;
    }

    public String getCanonicalizationMethod() {
        return this.canonicalizationMethod;
    }

    public void setCanonicalizationMethod(String canonicalizationMethod) {
        this.canonicalizationMethod = canonicalizationMethod;
    }

    @Override
    public byte[] getEncoded() {
        return DSSASN1Utils.getEncoded(this.timeStamp);
    }

    public List<TimestampInclude> getTimestampIncludes() {
        return this.timestampIncludes;
    }

    public void setTimestampIncludes(List<TimestampInclude> timestampIncludes) {
        this.timestampIncludes = timestampIncludes;
    }

    public List<CertificateToken> getCertificates() {
        return this.certificateSource.getCertificates();
    }

    public AttributeTable getUnsignedAttributes() {
        return this.timeStamp.getUnsignedAttributes();
    }

    public void setHashCode(int hashCode) {
        this.hashCode = hashCode;
    }

    public int getHashCode() {
        return this.hashCode;
    }

    @Override
    public String toString(String indentStr) {
        try {
            StringBuilder out = new StringBuilder();
            out.append(indentStr).append("TimestampToken[signedBy=").append(this.getIssuerX500Principal());
            out.append(", generated: ").append(DSSUtils.formatInternal(this.timeStamp.getTimeStampInfo().getGenTime()));
            out.append(" / ").append((Object)this.timeStampType).append('\n');
            if (this.signatureValid) {
                indentStr = indentStr + "\t";
                out.append(indentStr).append("Timestamp's signature validity: VALID").append('\n');
                indentStr = indentStr.substring(1);
            } else if (!this.signatureInvalidityReason.isEmpty()) {
                indentStr = indentStr + "\t";
                out.append(indentStr).append("Timestamp's signature validity: INVALID").append(" - ").append(this.signatureInvalidityReason).append('\n');
                indentStr = indentStr.substring(1);
            }
            indentStr = indentStr + "\t";
            if (this.messageImprintIntact != null) {
                if (this.messageImprintIntact.booleanValue()) {
                    out.append(indentStr).append("Timestamp MATCHES the signed data.").append('\n');
                } else {
                    out.append(indentStr).append("Timestamp DOES NOT MATCH the signed data.").append('\n');
                }
            }
            out.append(']');
            return out.toString();
        }
        catch (Exception e) {
            return this.getClass().getName();
        }
    }

    public SignerId getSignerId() {
        return this.timeStamp.getSID();
    }
}

