/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.jaxb.policy.ConstraintsParameters;
import eu.europa.esig.jaxb.policy.ObjectFactory;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationResourceManager {
    private static final Logger LOG = LoggerFactory.getLogger(ValidationResourceManager.class);
    public static final String defaultPolicyConstraintsLocation = "/policy/constraint.xml";
    public static final String defaultPolicyXsdLocation = "/xsd/policy.xsd";
    private static JAXBContext jaxbContext;

    public static ConstraintsParameters loadPolicyData(InputStream policyDataStream) {
        if (policyDataStream != null) {
            return ValidationResourceManager.load(policyDataStream);
        }
        if (defaultPolicyConstraintsLocation != null && !defaultPolicyConstraintsLocation.isEmpty()) {
            return ValidationResourceManager.load(defaultPolicyConstraintsLocation);
        }
        return null;
    }

    public static InputStream getResourceInputStream(String dataFileName) {
        try {
            InputStream inputStream = ValidationResourceManager.class.getResourceAsStream(dataFileName);
            return inputStream;
        }
        catch (Exception e) {
            throw new DSSException(e);
        }
    }

    public static ConstraintsParameters load(String path) {
        if (Utils.isStringEmpty(path)) {
            return null;
        }
        InputStream fileInputStream = ValidationResourceManager.getResourceInputStream(path);
        if (fileInputStream == null) {
            LOG.warn("Unknown resource (path: '{}')", (Object)path);
        }
        return ValidationResourceManager.load(fileInputStream);
    }

    public static ConstraintsParameters load(InputStream inputStream) throws DSSException {
        try {
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = sf.newSchema(new StreamSource(ValidationResourceManager.class.getResourceAsStream(defaultPolicyXsdLocation)));
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            unmarshaller.setSchema(schema);
            return (ConstraintsParameters)unmarshaller.unmarshal(inputStream);
        }
        catch (Exception e) {
            throw new DSSException("Unable to load policy : " + e.getMessage(), e);
        }
    }

    static {
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        }
        catch (JAXBException e) {
            throw new DSSException(e);
        }
    }
}

