/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process;

import eu.europa.esig.dss.QCStatementOids;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.reports.wrapper.CertificateWrapper;
import java.util.List;

public final class QCStatementPolicyIdentifiers {
    private QCStatementPolicyIdentifiers() {
    }

    public static boolean isSupportedByQSCD(CertificateWrapper certificate) {
        return QCStatementPolicyIdentifiers.hasQCStatementOID(certificate, QCStatementOids.QC_SSCD);
    }

    public static boolean isQCCompliant(CertificateWrapper certificate) {
        return QCStatementPolicyIdentifiers.hasQCStatementOID(certificate, QCStatementOids.QC_COMPLIANCE);
    }

    private static boolean hasQCStatementOID(CertificateWrapper certificate, QCStatementOids ... qcStatements) {
        List<String> qcStatementIds = certificate.getQCStatementIds();
        if (Utils.isCollectionNotEmpty(qcStatementIds)) {
            for (QCStatementOids qcStatement : qcStatements) {
                if (!qcStatementIds.contains(qcStatement.getOid())) continue;
                return true;
            }
        }
        return false;
    }
}

