/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.cv.checks;

import eu.europa.esig.dss.jaxb.detailedreport.XmlCV;
import eu.europa.esig.dss.jaxb.diagnostic.XmlContainerInfo;
import eu.europa.esig.dss.jaxb.diagnostic.XmlManifestFile;
import eu.europa.esig.dss.jaxb.diagnostic.XmlSignatureScope;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.SignatureScopeType;
import eu.europa.esig.dss.validation.policy.rules.Indication;
import eu.europa.esig.dss.validation.policy.rules.SubIndication;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.MessageTag;
import eu.europa.esig.dss.validation.reports.wrapper.SignatureWrapper;
import eu.europa.esig.jaxb.policy.LevelConstraint;
import java.util.ArrayList;
import java.util.List;

public class AllFilesSignedCheck
extends ChainItem<XmlCV> {
    private final SignatureWrapper signature;
    private final XmlContainerInfo containerInfo;

    public AllFilesSignedCheck(XmlCV result, SignatureWrapper signature, XmlContainerInfo containerInfo, LevelConstraint constraint) {
        super(result, constraint);
        this.signature = signature;
        this.containerInfo = containerInfo;
    }

    @Override
    protected boolean process() {
        if ("ASiC-S".equals(this.containerInfo.getContainerType())) {
            return 1 == Utils.collectionSize(this.containerInfo.getContentFiles());
        }
        if ("ASiC-E".equals(this.containerInfo.getContainerType())) {
            List<String> contentFiles;
            String signatureFilename = this.signature.getSignatureFilename();
            List<String> coveredFiles = this.getCoveredFilesBySignatureFilename(signatureFilename);
            if (!this.sameContent(coveredFiles, contentFiles = this.containerInfo.getContentFiles())) {
                return false;
            }
            if (this.signature.getFormat().startsWith("XAdES")) {
                List<String> coveredFilesFromScope = this.getCoveredFilesFromScope();
                return this.sameContent(coveredFilesFromScope, contentFiles);
            }
            return true;
        }
        return false;
    }

    private boolean sameContent(List<String> coveredFiles, List<String> contentFiles) {
        if (Utils.collectionSize(coveredFiles) == Utils.collectionSize(contentFiles)) {
            boolean findAll = true;
            for (String content : contentFiles) {
                findAll &= coveredFiles.contains(content);
            }
            if (findAll) {
                for (String covered : coveredFiles) {
                    findAll &= contentFiles.contains(covered);
                }
            }
            return findAll;
        }
        return false;
    }

    private List<String> getCoveredFilesBySignatureFilename(String signatureFilename) {
        List<XmlManifestFile> manifestFiles = this.containerInfo.getManifestFiles();
        for (XmlManifestFile xmlManifestFile : manifestFiles) {
            if (!Utils.areStringsEqual(signatureFilename, xmlManifestFile.getSignatureFilename())) continue;
            return xmlManifestFile.getEntries();
        }
        return new ArrayList<String>();
    }

    private List<String> getCoveredFilesFromScope() {
        ArrayList<String> result = new ArrayList<String>();
        List<XmlSignatureScope> signatureScopes = this.signature.getSignatureScopes();
        for (XmlSignatureScope xmlSignatureScope : signatureScopes) {
            if (SignatureScopeType.FULL != xmlSignatureScope.getScope()) continue;
            result.add(xmlSignatureScope.getName());
        }
        return result;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_CV_IAFS;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_CV_IAFS_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.SIG_CRYPTO_FAILURE;
    }
}

