/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.certificate;

import eu.europa.esig.dss.validation.CertificateQualification;
import eu.europa.esig.dss.validation.process.qualification.certificate.QSCDStatus;
import eu.europa.esig.dss.validation.process.qualification.certificate.QualifiedStatus;
import eu.europa.esig.dss.validation.process.qualification.certificate.Type;

public final class CertQualificationMatrix {
    private static final int NOT_QC = 0;
    private static final int QC = 1;
    private static final int ESIG = 0;
    private static final int ESEAL = 1;
    private static final int WSA = 2;
    private static final int UNKNOWN = 3;
    private static final int NOT_QSCD = 0;
    private static final int QSCD = 1;
    private static final CertificateQualification[][][] QUALIFS = new CertificateQualification[2][4][2];

    private CertQualificationMatrix() {
    }

    public static CertificateQualification getCertQualification(QualifiedStatus qc, Type type, QSCDStatus qscd) {
        return QUALIFS[CertQualificationMatrix.getInt(QualifiedStatus.isQC(qc))][CertQualificationMatrix.getInt(type)][CertQualificationMatrix.getInt(QSCDStatus.isQSCD(qscd))];
    }

    private static int getInt(Type type) {
        switch (type) {
            case ESIGN: {
                return 0;
            }
            case ESEAL: {
                return 1;
            }
            case WSA: {
                return 2;
            }
        }
        return 3;
    }

    private static int getInt(boolean bool) {
        return bool ? 1 : 0;
    }

    static {
        CertQualificationMatrix.QUALIFS[1][0][1] = CertificateQualification.QCERT_FOR_ESIG_QSCD;
        CertQualificationMatrix.QUALIFS[1][1][1] = CertificateQualification.QCERT_FOR_ESEAL_QSCD;
        CertQualificationMatrix.QUALIFS[1][2][1] = CertificateQualification.QCERT_FOR_WSA;
        CertQualificationMatrix.QUALIFS[1][3][1] = CertificateQualification.NA;
        CertQualificationMatrix.QUALIFS[1][0][0] = CertificateQualification.QCERT_FOR_ESIG;
        CertQualificationMatrix.QUALIFS[1][1][0] = CertificateQualification.QCERT_FOR_ESEAL;
        CertQualificationMatrix.QUALIFS[1][2][0] = CertificateQualification.QCERT_FOR_WSA;
        CertQualificationMatrix.QUALIFS[1][3][0] = CertificateQualification.NA;
        CertQualificationMatrix.QUALIFS[0][0][0] = CertificateQualification.CERT_FOR_ESIG;
        CertQualificationMatrix.QUALIFS[0][1][0] = CertificateQualification.CERT_FOR_ESEAL;
        CertQualificationMatrix.QUALIFS[0][2][0] = CertificateQualification.CERT_FOR_WSA;
        CertQualificationMatrix.QUALIFS[0][3][0] = CertificateQualification.NA;
        CertQualificationMatrix.QUALIFS[0][0][1] = CertificateQualification.NA;
        CertQualificationMatrix.QUALIFS[0][1][1] = CertificateQualification.NA;
        CertQualificationMatrix.QUALIFS[0][2][1] = CertificateQualification.NA;
        CertQualificationMatrix.QUALIFS[0][3][1] = CertificateQualification.NA;
    }
}

