/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.certificate;

import eu.europa.esig.dss.jaxb.detailedreport.XmlCertificate;
import eu.europa.esig.dss.jaxb.detailedreport.XmlConclusion;
import eu.europa.esig.dss.jaxb.detailedreport.XmlConstraintsConclusion;
import eu.europa.esig.dss.jaxb.detailedreport.XmlTLAnalysis;
import eu.europa.esig.dss.jaxb.detailedreport.XmlValidationCertificateQualification;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.ValidationTime;
import eu.europa.esig.dss.validation.policy.rules.Indication;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.qualification.certificate.AcceptableBuildingBlockConclusionCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.CertQualificationAtTimeBlock;
import eu.europa.esig.dss.validation.process.qualification.signature.checks.AcceptableTrustedListCheck;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.TrustedServiceFilter;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.TrustedServicesFilterFactory;
import eu.europa.esig.dss.validation.reports.wrapper.CertificateWrapper;
import eu.europa.esig.dss.validation.reports.wrapper.TrustedServiceWrapper;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CertificateQualificationBlock
extends Chain<XmlCertificate> {
    private final XmlConclusion buildingBlocksConclusion;
    private final Date validationTime;
    private final CertificateWrapper signingCertificate;
    private final CertificateWrapper rootCertificate;
    private final List<XmlTLAnalysis> tlAnalysis;
    private final String lotlCountryCode;

    public CertificateQualificationBlock(XmlConclusion buildingBlocksConclusion, Date validationTime, CertificateWrapper signingCertificate, CertificateWrapper rootCertificate, List<XmlTLAnalysis> tlAnalysis, String lotlCountryCode) {
        super(new XmlCertificate());
        this.buildingBlocksConclusion = buildingBlocksConclusion;
        this.validationTime = validationTime;
        this.signingCertificate = signingCertificate;
        this.rootCertificate = rootCertificate;
        this.tlAnalysis = tlAnalysis;
        this.lotlCountryCode = lotlCountryCode;
    }

    @Override
    protected void initChain() {
        ChainItem<XmlCertificate> item = this.firstItem = this.isAcceptableBuildingBlockConclusion(this.buildingBlocksConclusion);
        if (this.signingCertificate != null && this.signingCertificate.hasTrustedServices()) {
            XmlTLAnalysis lotlAnalysis = this.getTlAnalysis(this.lotlCountryCode);
            if (lotlAnalysis != null) {
                item = item.setNextItem(this.isAcceptableTL(lotlAnalysis));
            }
            HashSet<String> acceptableCountries = new HashSet<String>();
            List<TrustedServiceWrapper> originalTSPs = this.signingCertificate.getTrustedServices();
            Set<String> countryCodes = this.getCountryCodes(originalTSPs);
            for (String countryCode : countryCodes) {
                XmlTLAnalysis currentTL = this.getTlAnalysis(countryCode);
                if (currentTL == null) continue;
                AcceptableTrustedListCheck<XmlCertificate> acceptableTL = this.isAcceptableTL(currentTL);
                item = item.setNextItem(acceptableTL);
                if (!acceptableTL.process()) continue;
                acceptableCountries.add(countryCode);
            }
            TrustedServiceFilter filter = TrustedServicesFilterFactory.createFilterByCountries(acceptableCountries);
            List<TrustedServiceWrapper> acceptableServices = filter.filter(originalTSPs);
            filter = TrustedServicesFilterFactory.createFilterByCaQc();
            List<TrustedServiceWrapper> caqcServices = filter.filter(acceptableServices);
            CertQualificationAtTimeBlock certQualAtIssuanceBlock = new CertQualificationAtTimeBlock(ValidationTime.CERTIFICATE_ISSUANCE_TIME, this.signingCertificate, this.rootCertificate, caqcServices);
            ((XmlCertificate)this.result).getValidationCertificateQualification().add((XmlValidationCertificateQualification)certQualAtIssuanceBlock.execute());
            CertQualificationAtTimeBlock certQualAtSigningTimeBlock = new CertQualificationAtTimeBlock(ValidationTime.VALIDATION_TIME, this.validationTime, this.signingCertificate, this.rootCertificate, caqcServices);
            ((XmlCertificate)this.result).getValidationCertificateQualification().add((XmlValidationCertificateQualification)certQualAtSigningTimeBlock.execute());
        }
    }

    private XmlTLAnalysis getTlAnalysis(String countryCode) {
        for (XmlTLAnalysis xmlTLAnalysis : this.tlAnalysis) {
            if (!Utils.areStringsEqual(countryCode, xmlTLAnalysis.getCountryCode())) continue;
            return xmlTLAnalysis;
        }
        return null;
    }

    private Set<String> getCountryCodes(List<TrustedServiceWrapper> caqcServices) {
        HashSet<String> countryCodes = new HashSet<String>();
        for (TrustedServiceWrapper trustedServiceWrapper : caqcServices) {
            countryCodes.add(trustedServiceWrapper.getCountryCode());
        }
        return countryCodes;
    }

    @Override
    protected void addAdditionalInfo() {
        this.collectErrorsWarnsInfos();
        this.setIndication();
    }

    private void setIndication() {
        XmlConclusion conclusion = ((XmlCertificate)this.result).getConclusion();
        if (conclusion != null) {
            if (Utils.isCollectionNotEmpty(conclusion.getErrors())) {
                conclusion.setIndication(Indication.FAILED);
            } else if (Utils.isCollectionNotEmpty(conclusion.getWarnings())) {
                conclusion.setIndication(Indication.INDETERMINATE);
            } else {
                conclusion.setIndication(Indication.PASSED);
            }
        }
    }

    private AcceptableTrustedListCheck<XmlCertificate> isAcceptableTL(XmlTLAnalysis xmlTLAnalysis) {
        return new AcceptableTrustedListCheck<XmlConstraintsConclusion>(this.result, xmlTLAnalysis, this.getFailLevelConstraint());
    }

    private ChainItem<XmlCertificate> isAcceptableBuildingBlockConclusion(XmlConclusion buildingBlocksConclusion) {
        return new AcceptableBuildingBlockConclusionCheck((XmlCertificate)this.result, buildingBlocksConclusion, this.getWarnLevelConstraint());
    }
}

