/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.trust.consistency;

import eu.europa.esig.dss.validation.process.qualification.trust.ServiceQualification;
import eu.europa.esig.dss.validation.process.qualification.trust.consistency.TrustedServiceCondition;
import eu.europa.esig.dss.validation.reports.wrapper.TrustedServiceWrapper;
import java.util.List;

class TrustedServiceUsageConsistency
implements TrustedServiceCondition {
    TrustedServiceUsageConsistency() {
    }

    @Override
    public boolean isConsistent(TrustedServiceWrapper trustedService) {
        List<String> capturedQualifiers = trustedService.getCapturedQualifiers();
        boolean qcForEsig = ServiceQualification.isQcForEsig(capturedQualifiers);
        boolean qcForEseal = ServiceQualification.isQcForEseal(capturedQualifiers);
        boolean qcForWSA = ServiceQualification.isQcForWSA(capturedQualifiers);
        boolean noneOfThem = !qcForEsig && !qcForEseal && !qcForWSA;
        boolean onlyOneOfThem = qcForEsig ^ qcForEseal ^ qcForWSA;
        return noneOfThem || onlyOneOfThem;
    }
}

