/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfbs.checks;

import eu.europa.esig.dss.jaxb.detailedreport.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.jaxb.detailedreport.XmlCV;
import eu.europa.esig.dss.jaxb.detailedreport.XmlConclusion;
import eu.europa.esig.dss.jaxb.detailedreport.XmlFC;
import eu.europa.esig.dss.jaxb.detailedreport.XmlISC;
import eu.europa.esig.dss.jaxb.detailedreport.XmlName;
import eu.europa.esig.dss.jaxb.detailedreport.XmlSAV;
import eu.europa.esig.dss.jaxb.detailedreport.XmlVCI;
import eu.europa.esig.dss.jaxb.detailedreport.XmlValidationProcessBasicSignatures;
import eu.europa.esig.dss.jaxb.detailedreport.XmlXCV;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.policy.rules.Indication;
import eu.europa.esig.dss.validation.policy.rules.SubIndication;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.MessageTag;
import eu.europa.esig.dss.validation.reports.wrapper.CertificateWrapper;
import eu.europa.esig.dss.validation.reports.wrapper.DiagnosticData;
import eu.europa.esig.dss.validation.reports.wrapper.SignatureWrapper;
import eu.europa.esig.dss.validation.reports.wrapper.TimestampWrapper;
import eu.europa.esig.dss.x509.TimestampType;
import eu.europa.esig.jaxb.policy.LevelConstraint;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class SignatureBasicBuildingBlocksCheck
extends ChainItem<XmlValidationProcessBasicSignatures> {
    private final DiagnosticData diagnosticData;
    private final XmlBasicBuildingBlocks signatureBBB;
    private final Map<String, XmlBasicBuildingBlocks> bbbs;
    private Indication indication;
    private SubIndication subIndication;
    private List<XmlName> errors = new ArrayList<XmlName>();

    public SignatureBasicBuildingBlocksCheck(XmlValidationProcessBasicSignatures result, DiagnosticData diagnosticData, XmlBasicBuildingBlocks signatureBBB, Map<String, XmlBasicBuildingBlocks> bbbs, LevelConstraint constraint) {
        super(result, constraint, signatureBBB.getId());
        this.diagnosticData = diagnosticData;
        this.signatureBBB = signatureBBB;
        this.bbbs = bbbs;
    }

    @Override
    protected boolean process() {
        XmlConclusion vciConclusion;
        XmlConclusion fcConclusion;
        XmlFC fc = this.signatureBBB.getFC();
        if (fc != null && !Indication.PASSED.equals((Object)(fcConclusion = fc.getConclusion()).getIndication())) {
            this.indication = fcConclusion.getIndication();
            this.subIndication = fcConclusion.getSubIndication();
            this.errors.addAll(fcConclusion.getErrors());
            return false;
        }
        XmlISC isc = this.signatureBBB.getISC();
        XmlConclusion iscConclusion = isc.getConclusion();
        if (Indication.INDETERMINATE.equals((Object)iscConclusion.getIndication()) && SubIndication.NO_SIGNING_CERTIFICATE_FOUND.equals((Object)iscConclusion.getSubIndication())) {
            this.indication = iscConclusion.getIndication();
            this.subIndication = iscConclusion.getSubIndication();
            this.errors.addAll(iscConclusion.getErrors());
            return false;
        }
        XmlVCI vci = this.signatureBBB.getVCI();
        if (vci != null && Indication.INDETERMINATE.equals((Object)(vciConclusion = vci.getConclusion()).getIndication())) {
            this.indication = vciConclusion.getIndication();
            this.subIndication = vciConclusion.getSubIndication();
            this.errors.addAll(vciConclusion.getErrors());
            return false;
        }
        XmlCV cv = this.signatureBBB.getCV();
        XmlConclusion cvConclusion = cv.getConclusion();
        if (!Indication.PASSED.equals((Object)cvConclusion.getIndication())) {
            this.indication = cvConclusion.getIndication();
            this.subIndication = cvConclusion.getSubIndication();
            this.errors.addAll(cvConclusion.getErrors());
            return false;
        }
        XmlXCV xcv = this.signatureBBB.getXCV();
        XmlConclusion xcvConclusion = xcv.getConclusion();
        if (Indication.INDETERMINATE.equals((Object)xcvConclusion.getIndication()) && SubIndication.REVOKED_NO_POE.equals((Object)xcvConclusion.getSubIndication())) {
            SignatureWrapper currentSignature = this.diagnosticData.getSignatureById(this.signatureBBB.getId());
            List<TimestampWrapper> contentTimestamps = currentSignature.getTimestampListByType(TimestampType.CONTENT_TIMESTAMP);
            if (Utils.isCollectionNotEmpty(contentTimestamps)) {
                boolean failed = false;
                Date revocationDate = this.getRevocationDateForSigningCertificate(currentSignature);
                for (TimestampWrapper timestamp : contentTimestamps) {
                    Date tspProductionTime;
                    if (!this.isValidTimestamp(timestamp) || !(tspProductionTime = timestamp.getProductionTime()).after(revocationDate)) continue;
                    failed = true;
                    break;
                }
                if (failed) {
                    this.indication = Indication.FAILED;
                    this.subIndication = SubIndication.REVOKED;
                    this.errors.addAll(xcvConclusion.getErrors());
                    return false;
                }
            }
            this.indication = Indication.INDETERMINATE;
            this.subIndication = SubIndication.REVOKED_NO_POE;
            this.errors.addAll(xcvConclusion.getErrors());
            return false;
        }
        if (Indication.INDETERMINATE.equals((Object)xcvConclusion.getIndication()) && SubIndication.OUT_OF_BOUNDS_NO_POE.equals((Object)xcvConclusion.getSubIndication())) {
            SignatureWrapper currentSignature = this.diagnosticData.getSignatureById(this.signatureBBB.getId());
            List<TimestampWrapper> contentTimestamps = currentSignature.getTimestampListByType(TimestampType.CONTENT_TIMESTAMP);
            if (Utils.isCollectionNotEmpty(contentTimestamps)) {
                boolean failed = false;
                Date expirationDate = this.getExpirationDateForSigningCertificate(currentSignature);
                for (TimestampWrapper timestamp : contentTimestamps) {
                    Date tspProductionTime;
                    if (!this.isValidTimestamp(timestamp) || !(tspProductionTime = timestamp.getProductionTime()).after(expirationDate)) continue;
                    failed = true;
                    break;
                }
                if (failed) {
                    this.indication = Indication.INDETERMINATE;
                    this.subIndication = SubIndication.EXPIRED;
                    this.errors.addAll(xcvConclusion.getErrors());
                    return false;
                }
            }
            this.indication = Indication.INDETERMINATE;
            this.subIndication = SubIndication.OUT_OF_BOUNDS_NO_POE;
            this.errors.addAll(xcvConclusion.getErrors());
            return false;
        }
        if (!Indication.PASSED.equals((Object)xcvConclusion.getIndication())) {
            this.indication = xcvConclusion.getIndication();
            this.subIndication = xcvConclusion.getSubIndication();
            this.errors.addAll(xcvConclusion.getErrors());
            return false;
        }
        XmlSAV sav = this.signatureBBB.getSAV();
        XmlConclusion savConclusion = sav.getConclusion();
        if (Indication.INDETERMINATE.equals((Object)savConclusion.getIndication()) && SubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE.equals((Object)savConclusion.getSubIndication())) {
            SignatureWrapper currentSignature = this.diagnosticData.getSignatureById(this.signatureBBB.getId());
            List<TimestampWrapper> contentTimestamps = currentSignature.getTimestampListByType(TimestampType.CONTENT_TIMESTAMP);
            if (Utils.isCollectionNotEmpty(contentTimestamps)) {
                boolean failed = false;
                for (TimestampWrapper timestamp : contentTimestamps) {
                    if (!this.isValidTimestamp(timestamp)) continue;
                    failed = true;
                    break;
                }
                if (failed) {
                    this.indication = Indication.FAILED;
                    this.subIndication = SubIndication.CRYPTO_CONSTRAINTS_FAILURE;
                    return false;
                }
            }
            this.indication = Indication.INDETERMINATE;
            this.subIndication = SubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE;
            this.errors.addAll(savConclusion.getErrors());
            return false;
        }
        if (!Indication.PASSED.equals((Object)savConclusion.getIndication())) {
            this.indication = savConclusion.getIndication();
            this.subIndication = savConclusion.getSubIndication();
            this.errors.addAll(savConclusion.getErrors());
            return false;
        }
        return true;
    }

    private boolean isValidTimestamp(TimestampWrapper timestamp) {
        XmlBasicBuildingBlocks timestampBasicBuildingBlocks = this.bbbs.get(timestamp.getId());
        return timestampBasicBuildingBlocks != null && timestampBasicBuildingBlocks.getConclusion() != null && Indication.PASSED.equals((Object)timestampBasicBuildingBlocks.getConclusion().getIndication());
    }

    private Date getRevocationDateForSigningCertificate(SignatureWrapper currentSignature) {
        CertificateWrapper signingCertificate = this.diagnosticData.getUsedCertificateById(currentSignature.getSigningCertificateId());
        if (signingCertificate != null && signingCertificate.getRevocationData() != null) {
            return signingCertificate.getLatestRevocationData().getRevocationDate();
        }
        return null;
    }

    private Date getExpirationDateForSigningCertificate(SignatureWrapper currentSignature) {
        CertificateWrapper signingCertificate = this.diagnosticData.getUsedCertificateById(currentSignature.getSigningCertificateId());
        if (signingCertificate != null) {
            return signingCertificate.getNotAfter();
        }
        return null;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.ADEST_ROBVPIIC;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.ADEST_ROBVPIIC_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return this.indication;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return this.subIndication;
    }

    @Override
    protected List<XmlName> getPreviousErrors() {
        return this.errors;
    }
}

