/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp.checks.vts;

import eu.europa.esig.dss.jaxb.detailedreport.XmlConstraintsConclusion;
import eu.europa.esig.dss.jaxb.detailedreport.XmlRFC;
import eu.europa.esig.dss.jaxb.detailedreport.XmlVTS;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.TimestampedObjectType;
import eu.europa.esig.dss.validation.policy.Context;
import eu.europa.esig.dss.validation.policy.SubContext;
import eu.europa.esig.dss.validation.policy.ValidationPolicy;
import eu.europa.esig.dss.validation.policy.rules.Indication;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CryptographicCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.rfc.RevocationFreshnessChecker;
import eu.europa.esig.dss.validation.process.vpfswatsp.POEExtraction;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.vts.checks.POEExistsAtOrBeforeControlTimeCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.vts.checks.SatisfyingRevocationDataExistsCheck;
import eu.europa.esig.dss.validation.reports.wrapper.CertificateWrapper;
import eu.europa.esig.dss.validation.reports.wrapper.DiagnosticData;
import eu.europa.esig.dss.validation.reports.wrapper.RevocationWrapper;
import eu.europa.esig.dss.validation.reports.wrapper.TokenProxy;
import eu.europa.esig.jaxb.policy.CryptographicConstraint;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class ValidationTimeSliding
extends Chain<XmlVTS> {
    private final DiagnosticData diagnosticData;
    private final TokenProxy token;
    private final Date currentTime;
    private final Context context;
    private final POEExtraction poe;
    private final ValidationPolicy policy;
    private Date controlTime;

    public ValidationTimeSliding(DiagnosticData diagnosticData, TokenProxy token, Date currentTime, Context context, POEExtraction poe, ValidationPolicy policy) {
        super(new XmlVTS());
        this.diagnosticData = diagnosticData;
        this.token = token;
        this.currentTime = currentTime;
        this.context = context;
        this.poe = poe;
        this.policy = policy;
    }

    @Override
    protected void initChain() {
        this.controlTime = this.currentTime;
        List<String> certificateChainIds = this.token.getCertificateChainIds();
        if (Utils.isCollectionNotEmpty(certificateChainIds)) {
            Collections.reverse(certificateChainIds);
            ChainItem<XmlVTS> item = null;
            for (String certificateId : certificateChainIds) {
                CertificateWrapper certificate = this.diagnosticData.getUsedCertificateById(certificateId);
                if (certificate.isTrusted()) continue;
                RevocationWrapper latestCompliantRevocation = null;
                Set<RevocationWrapper> revocations = certificate.getRevocationData();
                for (RevocationWrapper revocation : revocations) {
                    if (latestCompliantRevocation != null && !revocation.getProductionDate().after(latestCompliantRevocation.getProductionDate()) || !this.isConsistant(certificate, revocation) || !this.isIssuanceBeforeControlTime(revocation)) continue;
                    latestCompliantRevocation = revocation;
                }
                if (item == null) {
                    this.firstItem = this.satisfyingRevocationDataExists(latestCompliantRevocation);
                    item = this.firstItem;
                } else {
                    item = item.setNextItem(this.satisfyingRevocationDataExists(latestCompliantRevocation));
                }
                item = item.setNextItem(this.poeExistsAtOrBeforeControlTime(certificate, TimestampedObjectType.CERTIFICATE, this.controlTime));
                item = item.setNextItem(this.poeExistsAtOrBeforeControlTime(latestCompliantRevocation, TimestampedObjectType.REVOCATION, this.controlTime));
                if (latestCompliantRevocation != null) {
                    if (certificate.isRevoked()) {
                        this.controlTime = latestCompliantRevocation.getRevocationDate();
                    } else if (!this.isFresh(latestCompliantRevocation, this.controlTime)) {
                        this.controlTime = latestCompliantRevocation.getProductionDate();
                    }
                }
                item = item.setNextItem(this.cryptographicCheck(certificate, this.controlTime));
                item = item.setNextItem(this.cryptographicCheck(latestCompliantRevocation, this.controlTime));
            }
        }
    }

    @Override
    protected void addAdditionalInfo() {
        ((XmlVTS)this.result).setControlTime(this.controlTime);
    }

    private boolean isFresh(RevocationWrapper revocationData, Date controlTime) {
        RevocationFreshnessChecker rfc = new RevocationFreshnessChecker(revocationData, controlTime, this.context, SubContext.SIGNING_CERT, this.policy);
        XmlRFC execute = (XmlRFC)rfc.execute();
        return execute != null && execute.getConclusion() != null && Indication.PASSED.equals((Object)execute.getConclusion().getIndication());
    }

    private ChainItem<XmlVTS> satisfyingRevocationDataExists(RevocationWrapper revocationData) {
        return new SatisfyingRevocationDataExistsCheck((XmlVTS)this.result, revocationData, this.getFailLevelConstraint());
    }

    private ChainItem<XmlVTS> poeExistsAtOrBeforeControlTime(TokenProxy token, TimestampedObjectType referenceCategory, Date controlTime) {
        return new POEExistsAtOrBeforeControlTimeCheck((XmlVTS)this.result, token, referenceCategory, controlTime, this.poe, this.getFailLevelConstraint());
    }

    private ChainItem<XmlVTS> cryptographicCheck(TokenProxy token, Date validationTime) {
        CryptographicConstraint constraint = this.policy.getCertificateCryptographicConstraint(this.context, SubContext.SIGNING_CERT);
        return new CryptographicCheck<XmlConstraintsConclusion>(this.result, token, validationTime, constraint);
    }

    private boolean isConsistant(CertificateWrapper certificate, RevocationWrapper revocationData) {
        Date expiredCertsRevocationInfo;
        String revocationSigningCertificateId;
        CertificateWrapper revocCert;
        Date archiveCutOff;
        Date thisUpdate;
        Date certNotBefore = certificate.getNotBefore();
        Date certNotAfter = certificate.getNotAfter();
        Date notAfterRevoc = thisUpdate = revocationData.getThisUpdate();
        Date expiredCertsOnCRL = revocationData.getExpiredCertsOnCRL();
        if (expiredCertsOnCRL != null) {
            notAfterRevoc = expiredCertsOnCRL;
        }
        if ((archiveCutOff = revocationData.getArchiveCutOff()) != null) {
            notAfterRevoc = archiveCutOff;
        }
        if (expiredCertsOnCRL != null && archiveCutOff != null && (revocCert = this.diagnosticData.getUsedCertificateById(revocationSigningCertificateId = revocationData.getSigningCertificateId())) != null && (expiredCertsRevocationInfo = revocCert.getCertificateTSPServiceExpiredCertsRevocationInfo()) != null) {
            notAfterRevoc = expiredCertsRevocationInfo;
        }
        boolean certHashOK = revocationData.isCertHashExtensionPresent() && revocationData.isCertHashExtensionMatch();
        return thisUpdate != null && certNotBefore.before(thisUpdate) && (certNotAfter.compareTo(notAfterRevoc) >= 0 || certHashOK);
    }

    private boolean isIssuanceBeforeControlTime(RevocationWrapper revocationData) {
        Date issuanceDate = revocationData.getProductionDate();
        return issuanceDate.before(this.controlTime);
    }
}

