/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.reports;

import eu.europa.esig.dss.validation.reports.DetailedReport;
import eu.europa.esig.dss.validation.reports.wrapper.DiagnosticData;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReports {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractReports.class);
    private boolean validateXml = false;
    protected eu.europa.esig.dss.jaxb.diagnostic.DiagnosticData diagnosticData;
    protected DiagnosticData diagnosticDataWrapper;
    protected eu.europa.esig.dss.jaxb.detailedreport.DetailedReport detailedReport;
    protected DetailedReport detailedReportWrapper;
    private String xmlDiagnosticData;
    private String xmlDetailedReport;

    protected AbstractReports(eu.europa.esig.dss.jaxb.diagnostic.DiagnosticData diagnosticDataJaxb, eu.europa.esig.dss.jaxb.detailedreport.DetailedReport detailedReport) {
        this.diagnosticData = diagnosticDataJaxb;
        this.diagnosticDataWrapper = new DiagnosticData(diagnosticDataJaxb);
        this.detailedReport = detailedReport;
        this.detailedReportWrapper = new DetailedReport(detailedReport);
    }

    public void setValidateXml(boolean validateXml) {
        this.validateXml = validateXml;
    }

    public DiagnosticData getDiagnosticData() {
        return this.diagnosticDataWrapper;
    }

    public DetailedReport getDetailedReport() {
        return this.detailedReportWrapper;
    }

    public eu.europa.esig.dss.jaxb.diagnostic.DiagnosticData getDiagnosticDataJaxb() {
        return this.diagnosticData;
    }

    public eu.europa.esig.dss.jaxb.detailedreport.DetailedReport getDetailedReportJaxb() {
        return this.detailedReport;
    }

    public void print() {
        System.out.println("----------------Diagnostic data-----------------");
        System.out.println(this.getXmlDiagnosticData());
        System.out.println("----------------Validation report---------------");
        System.out.println(this.getXmlDetailedReport());
        System.out.println("----------------Simple report-------------------");
        System.out.println(this.getXmlSimpleReport());
        System.out.println("------------------------------------------------");
    }

    public abstract String getXmlSimpleReport();

    public String getXmlDiagnosticData() {
        if (this.xmlDiagnosticData == null) {
            this.xmlDiagnosticData = this.getJAXBObjectAsString(this.diagnosticData, eu.europa.esig.dss.jaxb.diagnostic.DiagnosticData.class.getPackage().getName(), "/xsd/DiagnosticData.xsd");
        }
        return this.xmlDiagnosticData;
    }

    public String getXmlDetailedReport() {
        if (this.xmlDetailedReport == null) {
            this.xmlDetailedReport = this.getJAXBObjectAsString(this.detailedReport, eu.europa.esig.dss.jaxb.detailedreport.DetailedReport.class.getPackage().getName(), "/xsd/DetailedReport.xsd");
        }
        return this.xmlDetailedReport;
    }

    protected String getJAXBObjectAsString(Object obj, String contextPath, String xsdFile) {
        try {
            JAXBContext context = JAXBContext.newInstance((String)contextPath);
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            if (this.validateXml) {
                SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                InputStream schemaStream = AbstractReports.class.getResourceAsStream(xsdFile);
                Schema schema = sf.newSchema(new StreamSource(schemaStream));
                marshaller.setSchema(schema);
            }
            StringWriter writer = new StringWriter();
            marshaller.marshal(obj, (Writer)writer);
            return writer.toString();
        }
        catch (Exception e) {
            if (this.validateXml) {
                throw new RuntimeException(e);
            }
            LOG.error("Unable to generate string value for context " + contextPath + " : " + e.getMessage(), e);
            return null;
        }
    }
}

