/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.reports;

import eu.europa.esig.dss.jaxb.simplecertificatereport.XmlChainItem;
import eu.europa.esig.dss.jaxb.simplecertificatereport.XmlRevocation;
import eu.europa.esig.dss.jaxb.simplecertificatereport.XmlTrustAnchor;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateQualification;
import eu.europa.esig.dss.validation.policy.rules.Indication;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SimpleCertificateReport {
    private final eu.europa.esig.dss.jaxb.simplecertificatereport.SimpleCertificateReport simpleReport;

    public SimpleCertificateReport(eu.europa.esig.dss.jaxb.simplecertificatereport.SimpleCertificateReport simpleReport) {
        this.simpleReport = simpleReport;
    }

    public Date getValidationTime() {
        return this.simpleReport.getValidationTime();
    }

    public List<String> getCertificateIds() {
        ArrayList<String> ids = new ArrayList<String>();
        List<XmlChainItem> chain = this.simpleReport.getChain();
        for (XmlChainItem xmlChainItem : chain) {
            ids.add(xmlChainItem.getId());
        }
        return ids;
    }

    public Date getCertificateNotBefore(String certificateId) {
        XmlChainItem cert = this.getCertificate(certificateId);
        if (cert != null) {
            return cert.getNotBefore();
        }
        return null;
    }

    public Date getCertificateNotAfter(String certificateId) {
        XmlChainItem cert = this.getCertificate(certificateId);
        if (cert != null) {
            return cert.getNotAfter();
        }
        return null;
    }

    public List<String> getCertificateAiaUrls(String certificateId) {
        XmlChainItem cert = this.getCertificate(certificateId);
        if (cert != null) {
            return cert.getAiaUrls();
        }
        return Collections.emptyList();
    }

    public List<String> getCertificateCpsUrls(String certificateId) {
        XmlChainItem cert = this.getCertificate(certificateId);
        if (cert != null) {
            return cert.getCpsUrls();
        }
        return Collections.emptyList();
    }

    public List<String> getCertificateCrlUrls(String certificateId) {
        XmlChainItem cert = this.getCertificate(certificateId);
        if (cert != null) {
            return cert.getCrlUrls();
        }
        return Collections.emptyList();
    }

    public List<String> getCertificateOcspUrls(String certificateId) {
        XmlChainItem cert = this.getCertificate(certificateId);
        if (cert != null) {
            return cert.getOcspUrls();
        }
        return Collections.emptyList();
    }

    public List<String> getCertificatePdsUrls(String certificateId) {
        XmlChainItem cert = this.getCertificate(certificateId);
        if (cert != null) {
            return cert.getPdsUrls();
        }
        return Collections.emptyList();
    }

    public String getCertificateCommonName(String certificateId) {
        XmlChainItem cert = this.getCertificate(certificateId);
        if (cert != null) {
            return cert.getSubject().getCommonName();
        }
        return null;
    }

    public String getCertificateEmail(String certificateId) {
        XmlChainItem cert = this.getCertificate(certificateId);
        if (cert != null) {
            return cert.getSubject().getEmail();
        }
        return null;
    }

    public String getCertificateGivenName(String certificateId) {
        XmlChainItem cert = this.getCertificate(certificateId);
        if (cert != null) {
            return cert.getSubject().getGivenName();
        }
        return null;
    }

    public String getCertificateLocality(String certificateId) {
        XmlChainItem cert = this.getCertificate(certificateId);
        if (cert != null) {
            return cert.getSubject().getLocality();
        }
        return null;
    }

    public String getCertificateState(String certificateId) {
        XmlChainItem cert = this.getCertificate(certificateId);
        if (cert != null) {
            return cert.getSubject().getState();
        }
        return null;
    }

    public String getCertificateCountry(String certificateId) {
        XmlChainItem cert = this.getCertificate(certificateId);
        if (cert != null) {
            return cert.getSubject().getCountry();
        }
        return null;
    }

    public String getCertificateOrganizationName(String certificateId) {
        XmlChainItem cert = this.getCertificate(certificateId);
        if (cert != null) {
            return cert.getSubject().getOrganizationName();
        }
        return null;
    }

    public String getCertificateOrganizationUnit(String certificateId) {
        XmlChainItem cert = this.getCertificate(certificateId);
        if (cert != null) {
            return cert.getSubject().getOrganizationUnit();
        }
        return null;
    }

    public String getCertificatePseudonym(String certificateId) {
        XmlChainItem cert = this.getCertificate(certificateId);
        if (cert != null) {
            return cert.getSubject().getPseudonym();
        }
        return null;
    }

    public String getCertificateSurname(String certificateId) {
        XmlChainItem cert = this.getCertificate(certificateId);
        if (cert != null) {
            return cert.getSubject().getSurname();
        }
        return null;
    }

    public Indication getCertificateIndication(String certificateId) {
        XmlChainItem cert = this.getCertificate(certificateId);
        if (cert != null) {
            return cert.getIndication();
        }
        return null;
    }

    public Date getCertificateRevocationDate(String certificateId) {
        XmlRevocation revocation;
        XmlChainItem cert = this.getCertificate(certificateId);
        if (cert != null && (revocation = cert.getRevocation()) != null) {
            return revocation.getRevocationDate();
        }
        return null;
    }

    public String getCertificateRevocationReason(String certificateId) {
        XmlRevocation revocation;
        XmlChainItem cert = this.getCertificate(certificateId);
        if (cert != null && (revocation = cert.getRevocation()) != null) {
            return revocation.getRevocationReason();
        }
        return null;
    }

    public CertificateQualification getQualificationAtCertificateIssuance() {
        XmlChainItem cert = this.getFirstCertificate();
        return cert.getQualificationAtIssuance();
    }

    public Set<String> getTrustAnchorVATNumbers() {
        HashSet<String> result = new HashSet<String>();
        XmlChainItem cert = this.getTrustAnchorCertificate();
        if (cert != null) {
            List<XmlTrustAnchor> trustAnchors = cert.getTrustAnchors();
            for (XmlTrustAnchor xmlTrustAnchor : trustAnchors) {
                result.add(xmlTrustAnchor.getTrustServiceProviderRegistrationId());
            }
        }
        return result;
    }

    private XmlChainItem getTrustAnchorCertificate() {
        List<XmlChainItem> chain = this.simpleReport.getChain();
        for (XmlChainItem xmlChainItem : chain) {
            if (!Utils.isCollectionNotEmpty(xmlChainItem.getTrustAnchors())) continue;
            return xmlChainItem;
        }
        return null;
    }

    public CertificateQualification getQualificationAtValidationTime() {
        XmlChainItem cert = this.getFirstCertificate();
        return cert.getQualificationAtValidation();
    }

    private XmlChainItem getFirstCertificate() {
        return this.simpleReport.getChain().get(0);
    }

    private XmlChainItem getCertificate(String certificateId) {
        List<XmlChainItem> chain = this.simpleReport.getChain();
        for (XmlChainItem xmlChainItem : chain) {
            if (!Utils.areStringsEqual(certificateId, xmlChainItem.getId())) continue;
            return xmlChainItem;
        }
        return null;
    }

    public eu.europa.esig.dss.jaxb.simplecertificatereport.SimpleCertificateReport getJaxbModel() {
        return this.simpleReport;
    }
}

