/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.reports.wrapper;

import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.EncryptionAlgorithm;
import eu.europa.esig.dss.MaskGenerationFunction;
import eu.europa.esig.dss.jaxb.diagnostic.XmlBasicSignature;
import eu.europa.esig.dss.jaxb.diagnostic.XmlChainItem;
import eu.europa.esig.dss.jaxb.diagnostic.XmlDigestMatcher;
import eu.europa.esig.dss.jaxb.diagnostic.XmlSigningCertificate;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.reports.wrapper.TokenProxy;
import eu.europa.esig.dss.x509.CertificateSourceType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractTokenProxy
implements TokenProxy {
    protected abstract XmlBasicSignature getCurrentBasicSignature();

    protected abstract List<XmlChainItem> getCurrentCertificateChain();

    protected abstract XmlSigningCertificate getCurrentSigningCertificate();

    @Override
    public List<XmlDigestMatcher> getDigestMatchers() {
        return Collections.emptyList();
    }

    @Override
    public List<XmlChainItem> getCertificateChain() {
        if (this.getCurrentCertificateChain() != null) {
            return this.getCurrentCertificateChain();
        }
        return new ArrayList<XmlChainItem>();
    }

    @Override
    public List<String> getCertificateChainIds() {
        ArrayList<String> result = new ArrayList<String>();
        List<XmlChainItem> certificateChain = this.getCertificateChain();
        if (Utils.isCollectionNotEmpty(certificateChain)) {
            for (XmlChainItem xmlChainCertificate : certificateChain) {
                result.add(xmlChainCertificate.getId());
            }
        }
        return result;
    }

    @Override
    public boolean isSignatureIntact() {
        XmlBasicSignature basicSignature = this.getCurrentBasicSignature();
        return basicSignature != null && Utils.isTrue(basicSignature.isSignatureIntact());
    }

    @Override
    public boolean isSignatureValid() {
        XmlBasicSignature basicSignature = this.getCurrentBasicSignature();
        return basicSignature != null && Utils.isTrue(basicSignature.isSignatureValid());
    }

    @Override
    public String getDigestAlgoUsedToSignThisToken() {
        XmlBasicSignature basicSignature = this.getCurrentBasicSignature();
        if (basicSignature != null) {
            return basicSignature.getDigestAlgoUsedToSignThisToken();
        }
        return "";
    }

    @Override
    public DigestAlgorithm getDigestAlgorithm() {
        String signatureDigestAlgorithmName = this.getDigestAlgoUsedToSignThisToken();
        return DigestAlgorithm.forName(signatureDigestAlgorithmName, null);
    }

    @Override
    public String getEncryptionAlgoUsedToSignThisToken() {
        XmlBasicSignature basicSignature = this.getCurrentBasicSignature();
        if (basicSignature != null) {
            return basicSignature.getEncryptionAlgoUsedToSignThisToken();
        }
        return "";
    }

    @Override
    public String getMaskGenerationFunctionUsedToSignThisToken() {
        XmlBasicSignature basicSignature = this.getCurrentBasicSignature();
        if (basicSignature != null) {
            return basicSignature.getMaskGenerationFunctionUsedToSignThisToken();
        }
        return "";
    }

    @Override
    public MaskGenerationFunction getMaskGenerationFunction() {
        String mgf = this.getMaskGenerationFunctionUsedToSignThisToken();
        return MaskGenerationFunction.valueOf(mgf);
    }

    @Override
    public EncryptionAlgorithm getEncryptionAlgorithm() {
        String encryptionAlgoUsedToSignThisToken = this.getEncryptionAlgoUsedToSignThisToken();
        return EncryptionAlgorithm.forName(encryptionAlgoUsedToSignThisToken, null);
    }

    @Override
    public String getKeyLengthUsedToSignThisToken() {
        XmlBasicSignature basicSignature = this.getCurrentBasicSignature();
        if (basicSignature != null) {
            return basicSignature.getKeyLengthUsedToSignThisToken();
        }
        return "";
    }

    @Override
    public boolean isIssuerSerialMatch() {
        XmlSigningCertificate currentSigningCertificate = this.getCurrentSigningCertificate();
        return currentSigningCertificate != null && Utils.isTrue(currentSigningCertificate.isIssuerSerialMatch());
    }

    @Override
    public boolean isAttributePresent() {
        XmlSigningCertificate currentSigningCertificate = this.getCurrentSigningCertificate();
        return currentSigningCertificate != null && Utils.isTrue(currentSigningCertificate.isAttributePresent());
    }

    @Override
    public boolean isDigestValueMatch() {
        XmlSigningCertificate currentSigningCertificate = this.getCurrentSigningCertificate();
        return currentSigningCertificate != null && Utils.isTrue(currentSigningCertificate.isDigestValueMatch());
    }

    @Override
    public boolean isDigestValuePresent() {
        XmlSigningCertificate currentSigningCertificate = this.getCurrentSigningCertificate();
        return currentSigningCertificate != null && Utils.isTrue(currentSigningCertificate.isDigestValuePresent());
    }

    @Override
    public String getSigningCertificateId() {
        XmlSigningCertificate currentSigningCertificate = this.getCurrentSigningCertificate();
        if (currentSigningCertificate != null) {
            return currentSigningCertificate.getId();
        }
        return "";
    }

    @Override
    public String getLastChainCertificateId() {
        XmlChainItem item = this.getLastChainCertificate();
        return item == null ? "" : item.getId();
    }

    @Override
    public String getFirstChainCertificateId() {
        XmlChainItem item = this.getFirstChainCertificate();
        return item == null ? "" : item.getId();
    }

    @Override
    public String getLastChainCertificateSource() {
        XmlChainItem item = this.getLastChainCertificate();
        return item == null ? "" : item.getSource();
    }

    public XmlChainItem getLastChainCertificate() {
        List<XmlChainItem> certificateChain = this.getCurrentCertificateChain();
        if (Utils.isCollectionNotEmpty(certificateChain)) {
            XmlChainItem lastItem = certificateChain.get(certificateChain.size() - 1);
            return lastItem;
        }
        return null;
    }

    @Override
    public boolean isTrustedChain() {
        String lastCertificateSource = this.getLastChainCertificateSource();
        return CertificateSourceType.TRUSTED_STORE.name().equals(lastCertificateSource) || CertificateSourceType.TRUSTED_LIST.name().equals(lastCertificateSource);
    }

    public XmlChainItem getFirstChainCertificate() {
        List<XmlChainItem> certificateChain = this.getCurrentCertificateChain();
        if (Utils.isCollectionNotEmpty(certificateChain)) {
            return certificateChain.get(0);
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractTokenProxy other = (AbstractTokenProxy)obj;
        return !(this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId()));
    }
}

