/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.reports.wrapper;

import eu.europa.esig.dss.ExtendedKeyUsageOids;
import eu.europa.esig.dss.jaxb.diagnostic.XmlBasicSignature;
import eu.europa.esig.dss.jaxb.diagnostic.XmlCertificate;
import eu.europa.esig.dss.jaxb.diagnostic.XmlCertificatePolicy;
import eu.europa.esig.dss.jaxb.diagnostic.XmlChainItem;
import eu.europa.esig.dss.jaxb.diagnostic.XmlDigestAlgoAndValue;
import eu.europa.esig.dss.jaxb.diagnostic.XmlDistinguishedName;
import eu.europa.esig.dss.jaxb.diagnostic.XmlOID;
import eu.europa.esig.dss.jaxb.diagnostic.XmlRevocation;
import eu.europa.esig.dss.jaxb.diagnostic.XmlSigningCertificate;
import eu.europa.esig.dss.jaxb.diagnostic.XmlTrustedService;
import eu.europa.esig.dss.jaxb.diagnostic.XmlTrustedServiceProvider;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.reports.wrapper.AbstractTokenProxy;
import eu.europa.esig.dss.validation.reports.wrapper.RevocationWrapper;
import eu.europa.esig.dss.validation.reports.wrapper.TrustedServiceWrapper;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CertificateWrapper
extends AbstractTokenProxy {
    private final XmlCertificate certificate;

    public CertificateWrapper(XmlCertificate certificate) {
        this.certificate = certificate;
    }

    @Override
    public String getId() {
        return this.certificate.getId();
    }

    @Override
    protected XmlBasicSignature getCurrentBasicSignature() {
        return this.certificate.getBasicSignature();
    }

    @Override
    protected List<XmlChainItem> getCurrentCertificateChain() {
        return this.certificate.getCertificateChain();
    }

    @Override
    protected XmlSigningCertificate getCurrentSigningCertificate() {
        return this.certificate.getSigningCertificate();
    }

    public boolean isTrusted() {
        return this.certificate.isTrusted();
    }

    public boolean isSelfSigned() {
        return this.certificate.isSelfSigned();
    }

    public List<String> getKeyUsages() {
        List<String> keyUsageBits = this.certificate.getKeyUsageBits();
        if (Utils.isCollectionNotEmpty(keyUsageBits)) {
            return keyUsageBits;
        }
        return new ArrayList<String>();
    }

    public boolean isRevocationDataAvailable() {
        return Utils.isCollectionNotEmpty(this.certificate.getRevocations());
    }

    public Set<RevocationWrapper> getRevocationData() {
        if (this.isRevocationDataAvailable()) {
            List<XmlRevocation> revocation = this.certificate.getRevocations();
            HashSet<RevocationWrapper> result = new HashSet<RevocationWrapper>();
            for (XmlRevocation xmlRevocationType : revocation) {
                result.add(new RevocationWrapper(xmlRevocationType));
            }
            return result;
        }
        return Collections.emptySet();
    }

    public RevocationWrapper getLatestRevocationData() {
        RevocationWrapper latest = null;
        for (RevocationWrapper revoc : this.getRevocationData()) {
            if (latest != null && (latest.getProductionDate() == null || revoc == null || revoc.getProductionDate() == null || !revoc.getProductionDate().after(latest.getProductionDate()))) continue;
            latest = revoc;
        }
        return latest;
    }

    public boolean isIdPkixOcspNoCheck() {
        return Utils.isTrue(this.certificate.isIdPkixOcspNoCheck());
    }

    public boolean isIdKpOCSPSigning() {
        List<XmlOID> extendedKeyUsages = this.certificate.getExtendedKeyUsages();
        if (Utils.isCollectionNotEmpty(extendedKeyUsages)) {
            for (XmlOID xmlOID : extendedKeyUsages) {
                if (!Utils.areStringsEqual(ExtendedKeyUsageOids.OCSP_SIGNING.getOid(), xmlOID.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    public Date getNotBefore() {
        return this.certificate.getNotBefore();
    }

    public Date getNotAfter() {
        return this.certificate.getNotAfter();
    }

    public Date getCertificateTSPServiceExpiredCertsRevocationInfo() {
        List<XmlTrustedServiceProvider> trustedServiceProviders = this.certificate.getTrustedServiceProviders();
        if (Utils.isCollectionNotEmpty(trustedServiceProviders)) {
            for (XmlTrustedServiceProvider trustedServiceProvider : trustedServiceProviders) {
                List<XmlTrustedService> trustedServices = trustedServiceProvider.getTrustedServices();
                for (XmlTrustedService xmlTrustedService : trustedServices) {
                    if (xmlTrustedService.getExpiredCertsRevocationInfo() == null) continue;
                    return xmlTrustedService.getExpiredCertsRevocationInfo();
                }
            }
        }
        return null;
    }

    public boolean isRevoked() {
        RevocationWrapper latestRevocationData = this.getLatestRevocationData();
        return latestRevocationData != null && !latestRevocationData.isStatus() && latestRevocationData.getRevocationDate() != null;
    }

    public boolean isValidCertificate() {
        boolean signatureValid = this.certificate.getBasicSignature() != null && this.certificate.getBasicSignature().isSignatureValid();
        RevocationWrapper latestRevocationData = this.getLatestRevocationData();
        boolean revocationValid = latestRevocationData != null && latestRevocationData.isStatus();
        boolean trusted = this.certificate.isTrusted();
        boolean validity = signatureValid && (trusted || revocationValid);
        return validity;
    }

    public String getSerialNumber() {
        BigInteger serialNumber = this.certificate.getSerialNumber();
        return serialNumber == null ? "" : serialNumber.toString();
    }

    public String getCommonName() {
        return this.certificate.getCommonName();
    }

    public String getCountryName() {
        return this.certificate.getCountryName();
    }

    public String getGivenName() {
        return this.certificate.getGivenName();
    }

    public String getOrganizationName() {
        return this.certificate.getOrganizationName();
    }

    public String getOrganizationalUnit() {
        return this.certificate.getOrganizationalUnit();
    }

    public String getEmail() {
        return this.certificate.getEmail();
    }

    public String getLocality() {
        return this.certificate.getLocality();
    }

    public String getState() {
        return this.certificate.getState();
    }

    public String getSurname() {
        return this.certificate.getSurname();
    }

    public String getPseudo() {
        return this.certificate.getPseudonym();
    }

    public List<XmlDigestAlgoAndValue> getDigestAlgoAndValues() {
        return this.certificate.getDigestAlgoAndValues();
    }

    public boolean hasTrustedServices() {
        List<XmlTrustedServiceProvider> tsps = this.certificate.getTrustedServiceProviders();
        return Utils.isCollectionNotEmpty(tsps);
    }

    public List<XmlTrustedServiceProvider> getTrustServiceProviders() {
        return this.certificate.getTrustedServiceProviders();
    }

    public List<TrustedServiceWrapper> getTrustedServices() {
        ArrayList<TrustedServiceWrapper> result = new ArrayList<TrustedServiceWrapper>();
        List<XmlTrustedServiceProvider> tsps = this.certificate.getTrustedServiceProviders();
        if (Utils.isCollectionNotEmpty(tsps)) {
            for (XmlTrustedServiceProvider tsp : tsps) {
                List<XmlTrustedService> trustedServices = tsp.getTrustedServices();
                if (!Utils.isCollectionNotEmpty(trustedServices)) continue;
                for (XmlTrustedService trustedService : trustedServices) {
                    TrustedServiceWrapper wrapper = new TrustedServiceWrapper();
                    wrapper.setTspName(tsp.getTSPName());
                    wrapper.setServiceName(trustedService.getServiceName());
                    wrapper.setCountryCode(tsp.getCountryCode());
                    wrapper.setStatus(trustedService.getStatus());
                    wrapper.setType(trustedService.getServiceType());
                    wrapper.setStartDate(trustedService.getStartDate());
                    wrapper.setEndDate(trustedService.getEndDate());
                    wrapper.setCapturedQualifiers(new ArrayList<String>(trustedService.getCapturedQualifiers()));
                    wrapper.setAdditionalServiceInfos(new ArrayList<String>(trustedService.getAdditionalServiceInfoUris()));
                    result.add(wrapper);
                }
            }
        }
        return result;
    }

    public String getCertificateDN() {
        return this.getFormat(this.certificate.getSubjectDistinguishedName(), "RFC2253");
    }

    public String getCertificateIssuerDN() {
        return this.getFormat(this.certificate.getIssuerDistinguishedName(), "RFC2253");
    }

    private String getFormat(List<XmlDistinguishedName> distinguishedNames, String format) {
        if (Utils.isCollectionNotEmpty(distinguishedNames)) {
            for (XmlDistinguishedName distinguishedName : distinguishedNames) {
                if (!Utils.areStringsEqual(distinguishedName.getFormat(), format)) continue;
                return distinguishedName.getValue();
            }
        }
        return "";
    }

    public List<String> getAuthorityInformationAccessUrls() {
        return this.certificate.getAuthorityInformationAccessUrls();
    }

    public List<String> getCRLDistributionPoints() {
        return this.certificate.getCRLDistributionPoints();
    }

    public List<String> getOCSPAccessUrls() {
        return this.certificate.getOCSPAccessUrls();
    }

    public List<String> getCpsUrls() {
        ArrayList<String> result = new ArrayList<String>();
        List<XmlCertificatePolicy> certificatePolicyIds = this.certificate.getCertificatePolicies();
        if (Utils.isCollectionNotEmpty(certificatePolicyIds)) {
            for (XmlCertificatePolicy xmlCertificatePolicy : certificatePolicyIds) {
                if (!Utils.isStringNotBlank(xmlCertificatePolicy.getCpsUrl())) continue;
                result.add(xmlCertificatePolicy.getCpsUrl());
            }
        }
        return result;
    }

    public List<String> getPolicyIds() {
        List<XmlCertificatePolicy> certificatePolicyIds = this.certificate.getCertificatePolicies();
        return this.getOidValues(certificatePolicyIds);
    }

    public List<String> getQCStatementIds() {
        List<XmlOID> certificateQCStatementIds = this.certificate.getQCStatementIds();
        return this.getOidValues(certificateQCStatementIds);
    }

    public List<String> getQCTypes() {
        List<XmlOID> certificateQCTypeIds = this.certificate.getQCTypes();
        return this.getOidValues(certificateQCTypeIds);
    }

    private List<String> getOidValues(List<? extends XmlOID> xmlOids) {
        ArrayList<String> result = new ArrayList<String>();
        if (Utils.isCollectionNotEmpty(xmlOids)) {
            for (XmlOID xmlOID : xmlOids) {
                result.add(xmlOID.getValue());
            }
        }
        return result;
    }

    public Set<String> getTrustedListCountryCodes() {
        HashSet<String> countryCodes = new HashSet<String>();
        List<XmlTrustedServiceProvider> trustedServiceProviders = this.certificate.getTrustedServiceProviders();
        for (XmlTrustedServiceProvider tsp : trustedServiceProviders) {
            countryCodes.add(tsp.getCountryCode());
        }
        return countryCodes;
    }

    public byte[] getBinaries() {
        return this.certificate.getBase64Encoded();
    }

    public List<XmlOID> getExtendedKeyUsages() {
        return this.certificate.getExtendedKeyUsages();
    }
}

