/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.reports.wrapper;

import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.EncryptionAlgorithm;
import eu.europa.esig.dss.MaskGenerationFunction;
import eu.europa.esig.dss.jaxb.diagnostic.XmlCertificate;
import eu.europa.esig.dss.jaxb.diagnostic.XmlContainerInfo;
import eu.europa.esig.dss.jaxb.diagnostic.XmlSignature;
import eu.europa.esig.dss.jaxb.diagnostic.XmlTimestamp;
import eu.europa.esig.dss.jaxb.diagnostic.XmlTrustedList;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.reports.wrapper.CertificateWrapper;
import eu.europa.esig.dss.validation.reports.wrapper.RevocationWrapper;
import eu.europa.esig.dss.validation.reports.wrapper.SignatureWrapper;
import eu.europa.esig.dss.validation.reports.wrapper.TimestampWrapper;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DiagnosticData {
    private final eu.europa.esig.dss.jaxb.diagnostic.DiagnosticData wrapped;
    private List<SignatureWrapper> foundSignatures;
    private List<CertificateWrapper> usedCertificates;

    public DiagnosticData(eu.europa.esig.dss.jaxb.diagnostic.DiagnosticData wrapped) {
        this.wrapped = wrapped;
    }

    public String getDocumentName() {
        return this.wrapped.getDocumentName();
    }

    public List<String> getSignatureIdList() {
        ArrayList<String> signatureIds = new ArrayList<String>();
        List<XmlSignature> signatures = this.wrapped.getSignatures();
        if (Utils.isCollectionNotEmpty(signatures)) {
            for (XmlSignature xmlSignature : signatures) {
                signatureIds.add(xmlSignature.getId());
            }
        }
        return signatureIds;
    }

    public String getFirstSignatureId() {
        SignatureWrapper firstSignature = this.getFirstSignatureNullSafe();
        return firstSignature.getId();
    }

    public Date getFirstSignatureDate() {
        SignatureWrapper firstSignature = this.getFirstSignatureNullSafe();
        return firstSignature.getDateTime();
    }

    public Date getSignatureDate(String signatureId) {
        SignatureWrapper signature = this.getSignatureByIdNullSafe(signatureId);
        return signature.getDateTime();
    }

    public String getFirstSignatureFormat() {
        SignatureWrapper signature = this.getFirstSignatureNullSafe();
        return signature.getSignatureFormat();
    }

    public String getSignatureFormat(String signatureId) {
        SignatureWrapper signature = this.getSignatureByIdNullSafe(signatureId);
        return signature.getSignatureFormat();
    }

    public DigestAlgorithm getFirstSignatureDigestAlgorithm() {
        SignatureWrapper signature = this.getFirstSignatureNullSafe();
        return signature.getDigestAlgorithm();
    }

    public DigestAlgorithm getSignatureDigestAlgorithm(String signatureId) {
        SignatureWrapper signature = this.getSignatureByIdNullSafe(signatureId);
        return signature.getDigestAlgorithm();
    }

    public EncryptionAlgorithm getFirstSignatureEncryptionAlgorithm() {
        SignatureWrapper signature = this.getFirstSignatureNullSafe();
        return signature.getEncryptionAlgorithm();
    }

    public EncryptionAlgorithm getSignatureEncryptionAlgorithm(String signatureId) {
        SignatureWrapper signature = this.getSignatureByIdNullSafe(signatureId);
        return signature.getEncryptionAlgorithm();
    }

    public MaskGenerationFunction getSignatureMaskGenerationFunction(String signatureId) {
        SignatureWrapper signature = this.getSignatureByIdNullSafe(signatureId);
        return signature.getMaskGenerationFunction();
    }

    public String getFirstSigningCertificateId() {
        SignatureWrapper signature = this.getFirstSignatureNullSafe();
        return signature.getSigningCertificateId();
    }

    public String getSigningCertificateId(String signatureId) {
        SignatureWrapper signature = this.getSignatureByIdNullSafe(signatureId);
        return signature.getSigningCertificateId();
    }

    public boolean isSigningCertificateIdentified(String signatureId) {
        SignatureWrapper signature = this.getSignatureByIdNullSafe(signatureId);
        return signature.isSigningCertificateIdentified();
    }

    public List<String> getSignatureCertificateChain(String signatureId) {
        SignatureWrapper signature = this.getSignatureByIdNullSafe(signatureId);
        return signature.getCertificateChainIds();
    }

    public String getFirstPolicyId() {
        SignatureWrapper signature = this.getFirstSignatureNullSafe();
        return signature.getPolicyId();
    }

    public String getPolicyId(String signatureId) {
        SignatureWrapper signature = this.getSignatureByIdNullSafe(signatureId);
        return signature.getPolicyId();
    }

    public List<String> getTimestampIdList(String signatureId) {
        SignatureWrapper signature = this.getSignatureByIdNullSafe(signatureId);
        return signature.getTimestampIdsList();
    }

    public List<TimestampWrapper> getTimestampList(String signatureId) {
        SignatureWrapper signature = this.getSignatureByIdNullSafe(signatureId);
        return signature.getTimestampList();
    }

    public boolean isBLevelTechnicallyValid(String signatureId) {
        SignatureWrapper signature = this.getSignatureByIdNullSafe(signatureId);
        return signature.isBLevelTechnicallyValid();
    }

    public boolean isThereTLevel(String signatureId) {
        SignatureWrapper signatureWrapper = this.getSignatureByIdNullSafe(signatureId);
        return signatureWrapper.isThereTLevel();
    }

    public boolean isTLevelTechnicallyValid(String signatureId) {
        SignatureWrapper signatureWrapper = this.getSignatureByIdNullSafe(signatureId);
        return signatureWrapper.isTLevelTechnicallyValid();
    }

    public boolean isThereXLevel(String signatureId) {
        SignatureWrapper signatureWrapper = this.getSignatureByIdNullSafe(signatureId);
        return signatureWrapper.isThereXLevel();
    }

    public boolean isXLevelTechnicallyValid(String signatureId) {
        SignatureWrapper signatureWrapper = this.getSignatureByIdNullSafe(signatureId);
        return signatureWrapper.isXLevelTechnicallyValid();
    }

    public boolean isThereALevel(String signatureId) {
        SignatureWrapper signatureWrapper = this.getSignatureByIdNullSafe(signatureId);
        return signatureWrapper.isThereALevel();
    }

    public boolean isALevelTechnicallyValid(String signatureId) {
        SignatureWrapper signatureWrapper = this.getSignatureByIdNullSafe(signatureId);
        return signatureWrapper.isALevelTechnicallyValid();
    }

    public String getTimestampSigningCertificateId(String timestampId) {
        TimestampWrapper timestamp = this.getTimestampByIdNullSafe(timestampId);
        return timestamp.getSigningCertificateId();
    }

    public String getTimestampType(String timestampId) {
        TimestampWrapper timestamp = this.getTimestampByIdNullSafe(timestampId);
        return timestamp.getType();
    }

    public boolean isValidCertificate(String dssCertificateId) {
        CertificateWrapper certificate = this.getUsedCertificateByIdNullSafe(dssCertificateId);
        return certificate.isValidCertificate();
    }

    public String getCertificateDN(String dssCertificateId) {
        CertificateWrapper certificate = this.getUsedCertificateByIdNullSafe(dssCertificateId);
        return certificate.getCertificateDN();
    }

    public String getCertificateIssuerDN(String dssCertificateId) {
        CertificateWrapper certificate = this.getUsedCertificateByIdNullSafe(dssCertificateId);
        return certificate.getCertificateIssuerDN();
    }

    public String getCertificateSerialNumber(String dssCertificateId) {
        CertificateWrapper certificate = this.getUsedCertificateByIdNullSafe(dssCertificateId);
        return certificate.getSerialNumber();
    }

    public String getCertificateRevocationSource(String dssCertificateId) {
        CertificateWrapper certificate = this.getUsedCertificateByIdNullSafe(dssCertificateId);
        if (certificate.isRevocationDataAvailable()) {
            return certificate.getLatestRevocationData().getSource();
        }
        return "";
    }

    public boolean getCertificateRevocationStatus(String dssCertificateId) {
        CertificateWrapper certificate = this.getUsedCertificateByIdNullSafe(dssCertificateId);
        if (certificate.isRevocationDataAvailable()) {
            return certificate.getLatestRevocationData().isStatus();
        }
        return false;
    }

    public String getCertificateRevocationReason(String dssCertificateId) {
        CertificateWrapper certificate = this.getUsedCertificateByIdNullSafe(dssCertificateId);
        if (certificate.isRevocationDataAvailable()) {
            return certificate.getLatestRevocationData().getReason();
        }
        return "";
    }

    public String getErrorMessage(String signatureId) {
        SignatureWrapper signature = this.getSignatureByIdNullSafe(signatureId);
        return signature.getErrorMessage();
    }

    private SignatureWrapper getFirstSignatureNullSafe() {
        List<SignatureWrapper> signatures = this.getSignatures();
        if (Utils.isCollectionNotEmpty(signatures)) {
            return signatures.get(0);
        }
        return new SignatureWrapper(new XmlSignature());
    }

    public SignatureWrapper getSignatureById(String id) {
        List<SignatureWrapper> signatures = this.getSignatures();
        if (Utils.isCollectionNotEmpty(signatures)) {
            for (SignatureWrapper xmlSignature : signatures) {
                if (!Utils.areStringsEqual(id, xmlSignature.getId())) continue;
                return xmlSignature;
            }
        }
        return null;
    }

    private SignatureWrapper getSignatureByIdNullSafe(String id) {
        List<SignatureWrapper> signatures = this.getSignatures();
        if (Utils.isCollectionNotEmpty(signatures)) {
            for (SignatureWrapper xmlSignature : signatures) {
                if (!Utils.areStringsEqual(id, xmlSignature.getId())) continue;
                return xmlSignature;
            }
        }
        return new SignatureWrapper(new XmlSignature());
    }

    private TimestampWrapper getTimestampByIdNullSafe(String id) {
        TimestampWrapper timestamp = this.getTimestampById(id);
        if (timestamp != null) {
            return timestamp;
        }
        return new TimestampWrapper(new XmlTimestamp());
    }

    public TimestampWrapper getTimestampById(String id) {
        List<SignatureWrapper> signatures = this.getSignatures();
        for (SignatureWrapper signatureWrapper : signatures) {
            List<TimestampWrapper> timestampList = signatureWrapper.getTimestampList();
            for (TimestampWrapper timestampWrapper : timestampList) {
                if (!Utils.areStringsEqual(id, timestampWrapper.getId())) continue;
                return timestampWrapper;
            }
        }
        return null;
    }

    public CertificateWrapper getUsedCertificateByIdNullSafe(String id) {
        CertificateWrapper cert = this.getUsedCertificateById(id);
        if (cert != null) {
            return cert;
        }
        return new CertificateWrapper(new XmlCertificate());
    }

    public CertificateWrapper getUsedCertificateById(String id) {
        List<CertificateWrapper> certificates = this.getUsedCertificates();
        if (Utils.isCollectionNotEmpty(certificates)) {
            for (CertificateWrapper certificate : certificates) {
                if (!Utils.areStringsEqual(id, certificate.getId())) continue;
                return certificate;
            }
        }
        return null;
    }

    public RevocationWrapper getRevocationDataById(String id) {
        Set<RevocationWrapper> revocationData = this.getAllRevocationData();
        for (RevocationWrapper rd : revocationData) {
            if (!Utils.areStringsEqual(rd.getId(), id)) continue;
            return rd;
        }
        return null;
    }

    public List<SignatureWrapper> getSignatures() {
        if (this.foundSignatures == null) {
            this.foundSignatures = new ArrayList<SignatureWrapper>();
            List<XmlSignature> xmlSignatures = this.wrapped.getSignatures();
            if (Utils.isCollectionNotEmpty(xmlSignatures)) {
                for (XmlSignature xmlSignature : xmlSignatures) {
                    this.foundSignatures.add(new SignatureWrapper(xmlSignature));
                }
            }
        }
        return this.foundSignatures;
    }

    public List<CertificateWrapper> getUsedCertificates() {
        if (this.usedCertificates == null) {
            this.usedCertificates = new ArrayList<CertificateWrapper>();
            List<XmlCertificate> xmlCertificates = this.wrapped.getUsedCertificates();
            if (Utils.isCollectionNotEmpty(xmlCertificates)) {
                for (XmlCertificate certificate : xmlCertificates) {
                    this.usedCertificates.add(new CertificateWrapper(certificate));
                }
            }
        }
        return this.usedCertificates;
    }

    public Set<SignatureWrapper> getAllSignatures() {
        HashSet<SignatureWrapper> signatures = new HashSet<SignatureWrapper>();
        List<SignatureWrapper> mixedSignatures = this.getSignatures();
        for (SignatureWrapper signatureWrapper : mixedSignatures) {
            if (!Utils.isStringEmpty(signatureWrapper.getParentId())) continue;
            signatures.add(signatureWrapper);
        }
        return signatures;
    }

    public Set<SignatureWrapper> getAllCounterSignatures() {
        HashSet<SignatureWrapper> signatures = new HashSet<SignatureWrapper>();
        List<SignatureWrapper> mixedSignatures = this.getSignatures();
        for (SignatureWrapper signatureWrapper : mixedSignatures) {
            if (!Utils.isStringNotEmpty(signatureWrapper.getParentId())) continue;
            signatures.add(signatureWrapper);
        }
        return signatures;
    }

    public Set<RevocationWrapper> getAllRevocationData() {
        HashSet<RevocationWrapper> revocationData = new HashSet<RevocationWrapper>();
        List<CertificateWrapper> certificates = this.getUsedCertificates();
        if (Utils.isCollectionNotEmpty(certificates)) {
            for (CertificateWrapper certificate : certificates) {
                Set<RevocationWrapper> revocations = certificate.getRevocationData();
                if (revocations == null) continue;
                revocationData.addAll(revocations);
            }
        }
        return revocationData;
    }

    public Set<TimestampWrapper> getAllTimestamps() {
        HashSet<TimestampWrapper> allTimestamps = new HashSet<TimestampWrapper>();
        List<SignatureWrapper> signatures = this.getSignatures();
        if (Utils.isCollectionNotEmpty(signatures)) {
            for (SignatureWrapper signatureWrapper : signatures) {
                allTimestamps.addAll(signatureWrapper.getTimestampList());
            }
        }
        return allTimestamps;
    }

    public eu.europa.esig.dss.jaxb.diagnostic.DiagnosticData getJaxbModel() {
        return this.wrapped;
    }

    public boolean isContainerInfoPresent() {
        return this.wrapped.getContainerInfo() != null;
    }

    public String getContainerType() {
        XmlContainerInfo containerInfo = this.wrapped.getContainerInfo();
        if (containerInfo != null) {
            return containerInfo.getContainerType();
        }
        return null;
    }

    public String getZipComment() {
        XmlContainerInfo containerInfo = this.wrapped.getContainerInfo();
        if (containerInfo != null) {
            return containerInfo.getZipComment();
        }
        return null;
    }

    public boolean isMimetypeFilePresent() {
        XmlContainerInfo containerInfo = this.wrapped.getContainerInfo();
        if (containerInfo != null) {
            return containerInfo.isMimeTypeFilePresent();
        }
        return false;
    }

    public String getMimetypeFileContent() {
        XmlContainerInfo containerInfo = this.wrapped.getContainerInfo();
        if (containerInfo != null) {
            return containerInfo.getMimeTypeContent();
        }
        return null;
    }

    public XmlContainerInfo getContainerInfo() {
        return this.wrapped.getContainerInfo();
    }

    public List<XmlTrustedList> getTrustedLists() {
        return this.wrapped.getTrustedLists();
    }

    public XmlTrustedList getListOfTrustedLists() {
        return this.wrapped.getListOfTrustedLists();
    }

    public String getLOTLCountryCode() {
        XmlTrustedList listOfTrustedLists = this.wrapped.getListOfTrustedLists();
        if (listOfTrustedLists != null) {
            return listOfTrustedLists.getCountryCode();
        }
        return null;
    }
}

