/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.x509;

import eu.europa.esig.dss.DSSASN1Utils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.x509.CertificateSourceType;
import eu.europa.esig.dss.x509.CertificateToken;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CertificatePoolEntity
implements Serializable {
    private static final long serialVersionUID = -8670353777128605464L;
    private static final Logger LOG = LoggerFactory.getLogger(CertificatePoolEntity.class);
    private final String id;
    private final List<CertificateToken> equivalentCertificates = Collections.synchronizedList(new ArrayList());
    private final Set<CertificateSourceType> sources = Collections.synchronizedSet(new HashSet());

    CertificatePoolEntity(CertificateToken initialCert, CertificateSourceType source) {
        this.id = initialCert.getEntityKey();
        this.equivalentCertificates.add(initialCert);
        this.sources.add(source);
    }

    void addEquivalentCertificate(CertificateToken token) {
        if (!this.equivalentCertificates.contains(token)) {
            LOG.trace("Certificate with same public key detected : {}", (Object)token.getAbbreviation());
            byte[] newSKI = DSSASN1Utils.computeSkiFromCert(token);
            CertificateToken equivalent = this.equivalentCertificates.iterator().next();
            byte[] skiEquivalent = DSSASN1Utils.computeSkiFromCert(equivalent);
            if (!Arrays.equals(newSKI, skiEquivalent) && LOG.isWarnEnabled()) {
                LOG.warn("{} \nCERT : {} \nSKI : {} \nPubKey : {}", token, Utils.toBase64(token.getEncoded()), Utils.toBase64(newSKI), Utils.toBase64(token.getPublicKey().getEncoded()));
                LOG.warn("is not equivalent to");
                LOG.warn("{} \nCERT : {} \nSKI : {} \nPubKey : {}", equivalent, Utils.toBase64(equivalent.getEncoded()), Utils.toBase64(skiEquivalent), Utils.toBase64(token.getPublicKey().getEncoded()));
            } else {
                this.equivalentCertificates.add(token);
            }
        }
    }

    void addSource(CertificateSourceType source) {
        this.sources.add(source);
    }

    List<CertificateToken> getEquivalentCertificates() {
        return Collections.unmodifiableList(this.equivalentCertificates);
    }

    Set<CertificateSourceType> getSources() {
        return Collections.unmodifiableSet(this.sources);
    }

    boolean isTrusted() {
        return this.sources.contains((Object)CertificateSourceType.TRUSTED_LIST) || this.sources.contains((Object)CertificateSourceType.TRUSTED_STORE);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CertificatePoolEntity other = (CertificatePoolEntity)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

