/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.x509;

import eu.europa.esig.dss.Digest;
import eu.europa.esig.dss.x509.RevocationOrigin;
import eu.europa.esig.dss.x509.Token;
import eu.europa.esig.dss.x509.crl.CRLReasonEnum;
import java.util.Date;

public abstract class RevocationToken
extends Token {
    private String relatedCertificateID;
    protected RevocationOrigin origin = RevocationOrigin.EXTERNAL;
    protected String sourceURL;
    protected boolean available;
    protected Boolean status;
    protected Date productionDate;
    protected Date thisUpdate;
    protected Date nextUpdate;
    protected Date revocationDate;
    protected Date expiredCertsOnCRL;
    protected Date archiveCutOff;
    protected Digest certHash;
    protected CRLReasonEnum reason;

    public String getRelatedCertificateID() {
        return this.relatedCertificateID;
    }

    public void setRelatedCertificateID(String relatedCertificateID) {
        this.relatedCertificateID = relatedCertificateID;
    }

    public String getSourceURL() {
        return this.sourceURL;
    }

    public void setSourceURL(String sourceURL) {
        this.sourceURL = sourceURL;
    }

    public RevocationOrigin getOrigin() {
        return this.origin;
    }

    public void setOrigin(RevocationOrigin origin) {
        this.origin = origin;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    public Boolean getStatus() {
        return this.status;
    }

    public Date getProductionDate() {
        return this.productionDate;
    }

    @Override
    public Date getCreationDate() {
        return this.productionDate;
    }

    public Date getThisUpdate() {
        return this.thisUpdate;
    }

    public Date getNextUpdate() {
        return this.nextUpdate;
    }

    public Date getRevocationDate() {
        return this.revocationDate;
    }

    public Date getExpiredCertsOnCRL() {
        return this.expiredCertsOnCRL;
    }

    public Date getArchiveCutOff() {
        return this.archiveCutOff;
    }

    public Digest getCertHash() {
        return this.certHash;
    }

    public CRLReasonEnum getReason() {
        return this.reason;
    }

    public abstract boolean isValid();

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.productionDate == null ? 0 : this.productionDate.hashCode());
        result = 31 * result + (this.relatedCertificateID == null ? 0 : this.relatedCertificateID.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RevocationToken other = (RevocationToken)obj;
        if (this.productionDate == null ? other.productionDate != null : !this.productionDate.equals(other.productionDate)) {
            return false;
        }
        return !(this.relatedCertificateID == null ? other.relatedCertificateID != null : !this.relatedCertificateID.equals(other.relatedCertificateID));
    }
}

