/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.x509;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.SignatureAlgorithm;
import eu.europa.esig.dss.TokenIdentifier;
import eu.europa.esig.dss.x509.CertificateToken;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.Map;
import javax.security.auth.x500.X500Principal;

public abstract class Token
implements Serializable {
    private String dssId;
    private TokenIdentifier tokenIdentifier;
    protected PublicKey publicKeyOfTheSigner;
    protected boolean signatureValid = false;
    protected String signatureInvalidityReason = "";
    protected SignatureAlgorithm signatureAlgorithm;
    private Map<DigestAlgorithm, byte[]> digests = Collections.synchronizedMap(new EnumMap(DigestAlgorithm.class));

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Token)) {
            return false;
        }
        Token o2 = (Token)obj;
        return this.getDSSId().equals(o2.getDSSId());
    }

    public int hashCode() {
        return this.getDSSId().hashCode();
    }

    public boolean isSelfSigned() {
        return false;
    }

    public TokenIdentifier getDSSId() {
        if (this.tokenIdentifier == null) {
            this.tokenIdentifier = new TokenIdentifier(this);
        }
        return this.tokenIdentifier;
    }

    public String getDSSIdAsString() {
        if (this.dssId == null) {
            this.dssId = this.getDSSId().asXmlId();
        }
        return this.dssId;
    }

    public boolean isSignedBy(CertificateToken token) {
        if (this.publicKeyOfTheSigner != null) {
            return this.publicKeyOfTheSigner.equals(token.getPublicKey());
        }
        if (this.checkIsSignedBy(token)) {
            this.publicKeyOfTheSigner = token.getPublicKey();
            return true;
        }
        return false;
    }

    protected abstract boolean checkIsSignedBy(CertificateToken var1);

    public abstract X500Principal getIssuerX500Principal();

    public abstract Date getCreationDate();

    public String getAbbreviation() {
        return "?";
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public boolean isSignatureValid() {
        return this.signatureValid;
    }

    public PublicKey getPublicKeyOfTheSigner() {
        return this.publicKeyOfTheSigner;
    }

    public abstract String toString(String var1);

    public String toString() {
        return this.toString("");
    }

    public abstract byte[] getEncoded();

    public byte[] getDigest(DigestAlgorithm digestAlgorithm) {
        byte[] digestValue = this.digests.get((Object)digestAlgorithm);
        if (digestValue == null) {
            digestValue = this.getDigest(digestAlgorithm, this.getEncoded());
            this.digests.put(digestAlgorithm, digestValue);
        }
        return digestValue;
    }

    protected byte[] getDigest(DigestAlgorithm digestAlgorithm, byte[] toBeDigested) {
        try {
            MessageDigest md = MessageDigest.getInstance(digestAlgorithm.getJavaName());
            return md.digest(toBeDigested);
        }
        catch (Exception e) {
            throw new DSSException("Unable to compute digest with algo " + (Object)((Object)digestAlgorithm), e);
        }
    }
}

