/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades;

import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.SantuarioInitializer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.xml.security.c14n.Canonicalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class DSSXMLUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DSSXMLUtils.class);
    public static final String ID_ATTRIBUTE_NAME = "id";
    private static final Set<String> transforms;
    private static final Set<String> canonicalizers;
    private static Schema XADES_SCHEMA;

    private static void registerDefaultTransforms() {
        DSSXMLUtils.registerTransform("http://www.w3.org/2000/09/xmldsig#base64");
        DSSXMLUtils.registerTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        DSSXMLUtils.registerTransform("http://www.w3.org/TR/1999/REC-xpath-19991116");
        DSSXMLUtils.registerTransform("http://www.w3.org/2002/06/xmldsig-filter2");
        DSSXMLUtils.registerTransform("http://www.w3.org/TR/2001/WD-xptr-20010108");
        DSSXMLUtils.registerTransform("http://www.w3.org/TR/1999/REC-xslt-19991116");
    }

    private static void registerDefaultCanonicalizers() {
        DSSXMLUtils.registerCanonicalizer("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        DSSXMLUtils.registerCanonicalizer("http://www.w3.org/2001/10/xml-exc-c14n#");
        DSSXMLUtils.registerCanonicalizer("http://www.w3.org/2006/12/xml-c14n11");
        DSSXMLUtils.registerCanonicalizer("http://santuario.apache.org/c14n/physical");
        DSSXMLUtils.registerCanonicalizer("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        DSSXMLUtils.registerCanonicalizer("http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
        DSSXMLUtils.registerCanonicalizer("http://www.w3.org/2006/12/xml-c14n11#WithComments");
    }

    private DSSXMLUtils() {
    }

    public static boolean registerTransform(String transformURI) {
        boolean added = transforms.add(transformURI);
        return added;
    }

    public static boolean registerCanonicalizer(String c14nAlgorithmURI) {
        boolean added = canonicalizers.add(c14nAlgorithmURI);
        return added;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] serializeNode(Node xmlNode) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            String xmlEncoding;
            Transformer transformer = DomUtils.getSecureTransformer();
            Document document = null;
            document = 9 == xmlNode.getNodeType() ? (Document)xmlNode : xmlNode.getOwnerDocument();
            if (document != null && Utils.isStringNotBlank(xmlEncoding = document.getXmlEncoding())) {
                transformer.setOutputProperty("encoding", xmlEncoding);
            }
            StreamResult result = new StreamResult(bos);
            DOMSource source = new DOMSource(xmlNode);
            transformer.transform(source, result);
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new DSSException(e);
        }
    }

    public static boolean canCanonicalize(String canonicalizationMethod) {
        return canonicalizers.contains(canonicalizationMethod);
    }

    public static byte[] canonicalize(String canonicalizationMethod, byte[] toCanonicalizeBytes) throws DSSException {
        try {
            Canonicalizer c14n = Canonicalizer.getInstance(canonicalizationMethod);
            return c14n.canonicalize(toCanonicalizeBytes);
        }
        catch (Exception e) {
            throw new DSSException("Cannot canonicalize the binaries", e);
        }
    }

    public static byte[] canonicalizeSubtree(String canonicalizationMethod, Node node) {
        try {
            Canonicalizer c14n = Canonicalizer.getInstance(canonicalizationMethod);
            return c14n.canonicalizeSubtree(node);
        }
        catch (Exception e) {
            throw new DSSException("Cannot canonicalize the subtree", e);
        }
    }

    public static byte[] canonicalizeOrSerializeSubtree(String canonicalizationMethod, Node node) {
        if (canonicalizationMethod == null) {
            return DSSXMLUtils.serializeNode(node);
        }
        return DSSXMLUtils.canonicalizeSubtree(canonicalizationMethod, node);
    }

    public static void recursiveIdBrowse(Element element) {
        for (int ii = 0; ii < element.getChildNodes().getLength(); ++ii) {
            Node node = element.getChildNodes().item(ii);
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            DSSXMLUtils.setIDIdentifier(childElement);
            DSSXMLUtils.recursiveIdBrowse(childElement);
        }
    }

    public static String getIDIdentifier(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        for (int jj = 0; jj < attributes.getLength(); ++jj) {
            String id;
            Node item = attributes.item(jj);
            String localName = item.getLocalName();
            if (localName == null || !ID_ATTRIBUTE_NAME.equals(id = localName.toLowerCase())) continue;
            return item.getTextContent();
        }
        return null;
    }

    public static void setIDIdentifier(Element childElement) {
        NamedNodeMap attributes = childElement.getAttributes();
        for (int jj = 0; jj < attributes.getLength(); ++jj) {
            String id;
            Node item = attributes.item(jj);
            String localName = item.getLocalName();
            String nodeName = item.getNodeName();
            if (localName == null || !ID_ATTRIBUTE_NAME.equals(id = localName.toLowerCase())) continue;
            childElement.setIdAttribute(nodeName, true);
            break;
        }
    }

    private static Schema getXAdESValidationSchema() {
        if (XADES_SCHEMA == null) {
            try (InputStream xsd1 = DSSXMLUtils.class.getResourceAsStream("/XAdES01903v132-201601.xsd");
                 InputStream xsd2 = DSSXMLUtils.class.getResourceAsStream("/XAdES01903v141-201601.xsd");){
                SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                XADES_SCHEMA = sf.newSchema(new Source[]{new StreamSource(xsd1), new StreamSource(xsd2)});
            }
            catch (Exception e) {
                throw new DSSException("Unable to load the XSD files", e);
            }
        }
        return XADES_SCHEMA;
    }

    public static void validateAgainstXSD(DSSDocument document) throws SAXException {
        try (InputStream is = document.openStream();){
            Validator validator = DSSXMLUtils.getXAdESValidationSchema().newValidator();
            validator.validate(new StreamSource(is));
        }
        catch (IOException e) {
            throw new DSSException("Unable to read document", e);
        }
    }

    public static String validateAgainstXSD(StreamSource streamSource) {
        try {
            Validator validator = DSSXMLUtils.getXAdESValidationSchema().newValidator();
            validator.validate(streamSource);
            return "";
        }
        catch (Exception e) {
            LOG.warn("Error during the XML schema validation!", e);
            return e.getMessage();
        }
    }

    public static boolean isOid(String policyId) {
        return policyId != null && policyId.matches("^(?i)urn:oid:.*$");
    }

    static {
        XADES_SCHEMA = null;
        SantuarioInitializer.init();
        transforms = new HashSet<String>();
        DSSXMLUtils.registerDefaultTransforms();
        canonicalizers = new HashSet<String>();
        DSSXMLUtils.registerDefaultCanonicalizers();
    }
}

