/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades;

import eu.europa.esig.dss.xades.EnforcedResolverFragment;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.algorithms.SignatureAlgorithm;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.keyresolver.KeyResolver;
import org.apache.xml.security.transforms.Transform;
import org.apache.xml.security.utils.ElementProxy;
import org.apache.xml.security.utils.I18n;
import org.apache.xml.security.utils.resolver.ResourceResolver;
import org.apache.xml.security.utils.resolver.implementations.ResolverXPointer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SantuarioInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(SantuarioInitializer.class);
    private static boolean alreadyInitialized = false;

    public static final synchronized boolean isInitialized() {
        return alreadyInitialized;
    }

    public static synchronized void init() {
        if (alreadyInitialized) {
            return;
        }
        SantuarioInitializer.dynamicInit();
        alreadyInitialized = true;
    }

    private static void dynamicInit() {
        I18n.init("en", "US");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Registering default algorithms");
        }
        try {
            ElementProxy.registerDefaultPrefixes();
        }
        catch (XMLSecurityException ex) {
            LOG.error(ex.getMessage(), ex);
        }
        Transform.registerDefaultAlgorithms();
        SignatureAlgorithm.registerDefaultAlgorithms();
        JCEMapper.registerDefaultAlgorithms();
        Canonicalizer.registerDefaultAlgorithms();
        SantuarioInitializer.registerDefaultResolvers();
        KeyResolver.registerDefaultResolvers();
    }

    public static void registerDefaultResolvers() {
        ResourceResolver.register(EnforcedResolverFragment.class, false);
        ResourceResolver.register(ResolverXPointer.class, false);
    }
}

