/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.EncryptionAlgorithm;
import java.io.ByteArrayOutputStream;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;

public final class DSSSignatureUtils {
    private DSSSignatureUtils() {
    }

    public static byte[] convertToXmlDSig(EncryptionAlgorithm algorithm, byte[] signatureValue) {
        if (EncryptionAlgorithm.ECDSA == algorithm && DSSSignatureUtils.isAsn1Encoded(signatureValue)) {
            return DSSSignatureUtils.convertASN1toXMLDSIG(signatureValue);
        }
        if (EncryptionAlgorithm.DSA == algorithm) {
            return DSSSignatureUtils.convertASN1toXMLDSIG(signatureValue);
        }
        return signatureValue;
    }

    /*
     * Exception decompiling
     */
    private static byte[] convertASN1toXMLDSIG(byte[] binaries) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void leftPad(ByteArrayOutputStream stream, int size, byte[] array) {
        int diff = size - array.length;
        if (diff > 0) {
            for (int i = 0; i < diff; ++i) {
                stream.write(0);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isAsn1Encoded(byte[] signatureValue) {
        try (ASN1InputStream is = new ASN1InputStream(signatureValue);){
            ASN1Sequence seq = (ASN1Sequence)is.readObject();
            boolean bl = seq != null && seq.size() == 2;
            return bl;
        }
        catch (Exception e) {
            return false;
        }
    }
}

