/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.XAdESNamespaces;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.SignatureCryptographicVerification;
import eu.europa.esig.dss.xades.signature.XAdESBuilder;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class ExtensionBuilder
extends XAdESBuilder {
    protected XAdESSignature xadesSignature;
    protected Element currentSignatureDom;
    protected Element qualifyingPropertiesDom;
    protected Element unsignedPropertiesDom;
    protected Element unsignedSignaturePropertiesDom;
    protected Element signedPropertiesDom;
    protected Element signedDataObjectPropertiesDom;

    protected ExtensionBuilder(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
    }

    protected void ensureUnsignedProperties() {
        NodeList qualifyingPropertiesNodeList = DomUtils.getNodeList(this.currentSignatureDom, this.xPathQueryHolder.XPATH_QUALIFYING_PROPERTIES);
        if (qualifyingPropertiesNodeList.getLength() != 1) {
            throw new DSSException("The signature does not contain QualifyingProperties element (or contains more than one)! Extension is not possible.");
        }
        this.qualifyingPropertiesDom = (Element)qualifyingPropertiesNodeList.item(0);
        NodeList unsignedPropertiesNodeList = DomUtils.getNodeList(this.currentSignatureDom, this.xPathQueryHolder.XPATH_UNSIGNED_PROPERTIES);
        int length = unsignedPropertiesNodeList.getLength();
        if (length == 1) {
            this.unsignedPropertiesDom = (Element)qualifyingPropertiesNodeList.item(0);
        } else if (length == 0) {
            this.unsignedPropertiesDom = DomUtils.addElement(this.documentDom, this.qualifyingPropertiesDom, XAdESNamespaces.XAdES, "xades:UnsignedProperties");
        } else {
            throw new DSSException("The signature contains more then one UnsignedProperties element! Extension is not possible.");
        }
    }

    protected void ensureUnsignedSignatureProperties() {
        NodeList unsignedSignaturePropertiesNodeList = DomUtils.getNodeList(this.currentSignatureDom, this.xPathQueryHolder.XPATH_UNSIGNED_SIGNATURE_PROPERTIES);
        int length = unsignedSignaturePropertiesNodeList.getLength();
        if (length == 1) {
            this.unsignedSignaturePropertiesDom = (Element)unsignedSignaturePropertiesNodeList.item(0);
        } else if (length == 0) {
            this.unsignedSignaturePropertiesDom = DomUtils.addElement(this.documentDom, this.unsignedPropertiesDom, XAdESNamespaces.XAdES, "xades:UnsignedSignatureProperties");
        } else {
            throw new DSSException("The signature contains more then one UnsignedSignatureProperties element! Extension is not possible.");
        }
    }

    protected void ensureSignedDataObjectProperties() {
        NodeList signedDataObjectPropertiesNodeList = DomUtils.getNodeList(this.currentSignatureDom, this.xPathQueryHolder.XPATH_SIGNED_DATA_OBJECT_PROPERTIES);
        int length = signedDataObjectPropertiesNodeList.getLength();
        if (length == 1) {
            this.signedDataObjectPropertiesDom = (Element)signedDataObjectPropertiesNodeList.item(0);
        } else if (length > 1) {
            throw new DSSException("The signature contains more than one SignedDataObjectProperties element! Extension is not possible.");
        }
    }

    protected void assertSignatureValid(XAdESSignature xadesSignature) {
        SignatureCryptographicVerification signatureCryptographicVerification = xadesSignature.getSignatureCryptographicVerification();
        if (!signatureCryptographicVerification.isSignatureIntact()) {
            String errorMessage = signatureCryptographicVerification.getErrorMessage();
            throw new DSSException("Cryptographic signature verification has failed" + (errorMessage.isEmpty() ? "." : " / " + errorMessage));
        }
    }
}

