/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.DomUtils;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class ManifestBuilder {
    private final String manifestId;
    private final DigestAlgorithm digestAlgorithm;
    private final List<DSSDocument> documents;

    public ManifestBuilder(DigestAlgorithm digestAlgorithm, List<DSSDocument> documents) {
        this("manifest", digestAlgorithm, documents);
    }

    public ManifestBuilder(String manifestId, DigestAlgorithm digestAlgorithm, List<DSSDocument> documents) {
        this.manifestId = manifestId;
        this.digestAlgorithm = digestAlgorithm;
        this.documents = documents;
    }

    public DSSDocument build() {
        Document documentDom = DomUtils.buildDOM();
        Element manifestDom = documentDom.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Manifest");
        manifestDom.setAttribute("Id", this.manifestId);
        documentDom.appendChild(manifestDom);
        for (DSSDocument document : this.documents) {
            Element referenceDom = DomUtils.addElement(documentDom, manifestDom, "http://www.w3.org/2000/09/xmldsig#", "ds:Reference");
            referenceDom.setAttribute("URI", document.getName());
            Element digestMethodDom = DomUtils.addElement(documentDom, referenceDom, "http://www.w3.org/2000/09/xmldsig#", "ds:DigestMethod");
            digestMethodDom.setAttribute("Algorithm", this.digestAlgorithm.getXmlId());
            Element digestValueDom = DomUtils.addElement(documentDom, referenceDom, "http://www.w3.org/2000/09/xmldsig#", "ds:DigestValue");
            Text textNode = documentDom.createTextNode(document.getDigest(this.digestAlgorithm));
            digestValueDom.appendChild(textNode);
        }
        return DomUtils.createDssDocumentFromDomDocument(documentDom, this.manifestId);
    }
}

