/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DSSASN1Utils;
import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.InMemoryDocument;
import eu.europa.esig.dss.MimeType;
import eu.europa.esig.dss.SignatureLevel;
import eu.europa.esig.dss.SignaturePackaging;
import eu.europa.esig.dss.TimestampParameters;
import eu.europa.esig.dss.XAdESNamespaces;
import eu.europa.esig.dss.signature.SignatureExtension;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.ValidationContext;
import eu.europa.esig.dss.x509.CertificateSource;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.TimestampType;
import eu.europa.esig.dss.x509.tsp.TSPSource;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.ProfileParameters;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.signature.ExtensionBuilder;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import java.util.Set;
import java.util.UUID;
import org.bouncycastle.tsp.TimeStampToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XAdESLevelBaselineT
extends ExtensionBuilder
implements SignatureExtension<XAdESSignatureParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESLevelBaselineT.class);
    protected TSPSource tspSource;

    public XAdESLevelBaselineT(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
    }

    private void incorporateC14nMethod(Element parentDom, String signedInfoC14nMethod) {
        Element canonicalizationMethodDom = this.documentDom.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:CanonicalizationMethod");
        canonicalizationMethodDom.setAttribute("Algorithm", signedInfoC14nMethod);
        parentDom.appendChild(canonicalizationMethodDom);
    }

    public InMemoryDocument extendSignatures(DSSDocument dssDocument, XAdESSignatureParameters params) throws DSSException {
        if (dssDocument == null) {
            throw new NullPointerException();
        }
        if (this.tspSource == null) {
            throw new NullPointerException();
        }
        this.params = params;
        ProfileParameters context = params.getContext();
        if (LOG.isInfoEnabled()) {
            LOG.info("====> Extending: " + (dssDocument.getName() == null ? "IN MEMORY DOCUMENT" : dssDocument.getName()));
        }
        this.documentDom = DomUtils.buildDOM(dssDocument);
        NodeList signatureNodeList = this.documentDom.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (signatureNodeList.getLength() == 0) {
            throw new DSSException("There is no signature to extend!");
        }
        String signatureId = null;
        SignaturePackaging signaturePackaging = params.getSignaturePackaging();
        ProfileParameters.Operation operationKind = context.getOperationKind();
        if (ProfileParameters.Operation.SIGNING.equals((Object)operationKind) && SignaturePackaging.ENVELOPED.equals((Object)signaturePackaging)) {
            signatureId = params.getDeterministicId();
        }
        for (int ii = 0; ii < signatureNodeList.getLength(); ++ii) {
            this.currentSignatureDom = (Element)signatureNodeList.item(ii);
            String currentSignatureId = this.currentSignatureDom.getAttribute("Id");
            if (signatureId != null && !signatureId.equals(currentSignatureId)) continue;
            this.xadesSignature = new XAdESSignature(this.currentSignatureDom);
            this.xadesSignature.setDetachedContents(params.getDetachedContents());
            this.extendSignatureTag();
        }
        byte[] documentBytes = DSSXMLUtils.serializeNode(this.documentDom);
        InMemoryDocument inMemoryDocument = new InMemoryDocument(documentBytes);
        inMemoryDocument.setMimeType(MimeType.XML);
        return inMemoryDocument;
    }

    protected void extendSignatureTag() throws DSSException {
        this.assertExtendSignatureToTPossible();
        this.ensureUnsignedProperties();
        this.ensureUnsignedSignatureProperties();
        this.ensureSignedDataObjectProperties();
        this.assertSignatureValid(this.xadesSignature);
        if (!this.xadesSignature.hasTProfile() || SignatureLevel.XAdES_BASELINE_T.equals((Object)this.params.getSignatureLevel())) {
            TimestampParameters signatureTimestampParameters = this.params.getSignatureTimestampParameters();
            String canonicalizationMethod = signatureTimestampParameters.getCanonicalizationMethod();
            byte[] canonicalisedValue = this.xadesSignature.getSignatureTimestampData(null, canonicalizationMethod);
            DigestAlgorithm timestampDigestAlgorithm = signatureTimestampParameters.getDigestAlgorithm();
            byte[] digestValue = DSSUtils.digest(timestampDigestAlgorithm, canonicalisedValue);
            this.createXAdESTimeStampType(TimestampType.SIGNATURE_TIMESTAMP, canonicalizationMethod, digestValue);
        }
    }

    private void assertExtendSignatureToTPossible() {
        SignatureLevel signatureLevel = this.params.getSignatureLevel();
        if (SignatureLevel.XAdES_BASELINE_T.equals((Object)signatureLevel) && (this.xadesSignature.hasLTProfile() || this.xadesSignature.hasLTAProfile())) {
            String exceptionMessage = "Cannot extend signature. The signedData is already extended with [%s].";
            throw new DSSException(String.format("Cannot extend signature. The signedData is already extended with [%s].", "XAdES LT"));
        }
    }

    public void setTspSource(TSPSource tspSource) {
        this.tspSource = tspSource;
    }

    protected void incorporateCertificateValues(Element parentDom, ValidationContext validationContext) {
        Set<CertificateToken> toIncludeCertificates = this.xadesSignature.getCertificatesForInclusion(validationContext);
        if (!toIncludeCertificates.isEmpty()) {
            Element certificateValuesDom = DomUtils.addElement(this.documentDom, parentDom, XAdESNamespaces.XAdES, "xades:CertificateValues");
            CertificateSource trustedCertSource = this.certificateVerifier.getTrustedCertSource();
            boolean trustAnchorBPPolicy = this.params.bLevel().isTrustAnchorBPPolicy();
            boolean trustAnchorIncluded = false;
            for (CertificateToken certificateToken : toIncludeCertificates) {
                if (trustAnchorBPPolicy && trustedCertSource != null && !trustedCertSource.get(certificateToken.getSubjectX500Principal()).isEmpty()) {
                    trustAnchorIncluded = true;
                }
                byte[] bytes = certificateToken.getEncoded();
                String base64EncodeCertificate = Utils.toBase64(bytes);
                DomUtils.addTextElement(this.documentDom, certificateValuesDom, XAdESNamespaces.XAdES, "xades:EncapsulatedX509Certificate", base64EncodeCertificate);
            }
            if (trustAnchorBPPolicy && !trustAnchorIncluded) {
                LOG.warn("The trust anchor is missing but its inclusion is required by the signature policy!");
            }
        }
    }

    protected void createXAdESTimeStampType(TimestampType timestampType, String timestampC14nMethod, byte[] digestValue) throws DSSException {
        Element timeStampDom = null;
        TimestampParameters signatureTimestampParameters = this.params.getSignatureTimestampParameters();
        DigestAlgorithm timestampDigestAlgorithm = signatureTimestampParameters.getDigestAlgorithm();
        switch (timestampType) {
            case SIGNATURE_TIMESTAMP: {
                timeStampDom = DomUtils.addElement(this.documentDom, this.unsignedSignaturePropertiesDom, XAdESNamespaces.XAdES, "xades:SignatureTimeStamp");
                break;
            }
            case VALIDATION_DATA_TIMESTAMP: {
                if (this.params.isEn319132() && !this.isOldGeneration(this.params.getSignatureLevel())) {
                    timeStampDom = DomUtils.addElement(this.documentDom, this.unsignedSignaturePropertiesDom, XAdESNamespaces.XAdES, "xades:SigAndRefsTimeStampV2");
                    break;
                }
                timeStampDom = DomUtils.addElement(this.documentDom, this.unsignedSignaturePropertiesDom, XAdESNamespaces.XAdES, "xades:SigAndRefsTimeStamp");
                break;
            }
            case ARCHIVE_TIMESTAMP: {
                timeStampDom = DomUtils.addElement(this.documentDom, this.unsignedSignaturePropertiesDom, "http://uri.etsi.org/01903/v1.4.1#", "xades141:ArchiveTimeStamp");
                timestampDigestAlgorithm = this.params.getArchiveTimestampParameters().getDigestAlgorithm();
                break;
            }
            default: {
                throw new DSSException("Unsupported timestamp type : " + (Object)((Object)timestampType));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Timestamp generation: {} / {} / {}", timestampDigestAlgorithm.getName(), timestampC14nMethod, Utils.toBase64(digestValue));
        }
        TimeStampToken timeStampToken = this.tspSource.getTimeStampResponse(timestampDigestAlgorithm, digestValue);
        String base64EncodedTimeStampToken = Utils.toBase64(DSSASN1Utils.getEncoded(timeStampToken));
        String timestampId = UUID.randomUUID().toString();
        timeStampDom.setAttribute("Id", "TS-" + timestampId);
        this.incorporateC14nMethod(timeStampDom, timestampC14nMethod);
        Element encapsulatedTimeStampDom = DomUtils.addElement(this.documentDom, timeStampDom, XAdESNamespaces.XAdES, "xades:EncapsulatedTimeStamp");
        encapsulatedTimeStampDom.setAttribute("Id", "ETS-" + timestampId);
        DomUtils.setTextNode(this.documentDom, encapsulatedTimeStampDom, base64EncodedTimeStampToken);
    }

    private boolean isOldGeneration(SignatureLevel signatureLevel) {
        return SignatureLevel.XAdES_X.equals((Object)signatureLevel) || SignatureLevel.XAdES_XL.equals((Object)signatureLevel) || SignatureLevel.XAdES_A.equals((Object)signatureLevel);
    }
}

