/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.EncryptionAlgorithm;
import eu.europa.esig.dss.InMemoryDocument;
import eu.europa.esig.dss.MaskGenerationFunction;
import eu.europa.esig.dss.MimeType;
import eu.europa.esig.dss.Policy;
import eu.europa.esig.dss.SignatureAlgorithm;
import eu.europa.esig.dss.SignerLocation;
import eu.europa.esig.dss.XAdESNamespaces;
import eu.europa.esig.dss.signature.BaselineBCertificateSelector;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.TimestampInclude;
import eu.europa.esig.dss.validation.TimestampToken;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.TimestampType;
import eu.europa.esig.dss.xades.DSSReference;
import eu.europa.esig.dss.xades.DSSTransform;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.SignatureBuilder;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.signature.DSSSignatureUtils;
import eu.europa.esig.dss.xades.signature.DSSTransformXPath;
import eu.europa.esig.dss.xades.signature.DetachedSignatureBuilder;
import eu.europa.esig.dss.xades.signature.EnvelopedSignatureBuilder;
import eu.europa.esig.dss.xades.signature.EnvelopingSignatureBuilder;
import eu.europa.esig.dss.xades.signature.InternallyDetachedSignatureBuilder;
import eu.europa.esig.dss.xades.signature.XAdESBuilder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.datatype.XMLGregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class XAdESSignatureBuilder
extends XAdESBuilder
implements SignatureBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESSignatureBuilder.class);
    protected boolean built = false;
    protected DSSDocument detachedDocument;
    protected String signedInfoCanonicalizationMethod;
    protected String signedPropertiesCanonicalizationMethod;
    protected String deterministicId;
    protected Element signatureDom;
    protected Element signedInfoDom;
    protected Element signatureValueDom;
    protected Element qualifyingPropertiesDom;
    protected Element signedPropertiesDom;
    protected Element signedSignaturePropertiesDom;
    protected Element signedDataObjectPropertiesDom;
    protected Element unsignedSignaturePropertiesDom;

    public static XAdESSignatureBuilder getSignatureBuilder(XAdESSignatureParameters params, DSSDocument document, CertificateVerifier certificateVerifier) {
        switch (params.getSignaturePackaging()) {
            case ENVELOPED: {
                return new EnvelopedSignatureBuilder(params, document, certificateVerifier);
            }
            case ENVELOPING: {
                return new EnvelopingSignatureBuilder(params, document, certificateVerifier);
            }
            case DETACHED: {
                return new DetachedSignatureBuilder(params, document, certificateVerifier);
            }
            case INTERNALLY_DETACHED: {
                return new InternallyDetachedSignatureBuilder(params, document, certificateVerifier);
            }
        }
        throw new DSSException("Unsupported packaging " + (Object)((Object)params.getSignaturePackaging()));
    }

    public XAdESSignatureBuilder(XAdESSignatureParameters params, DSSDocument detachedDocument, CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
        this.params = params;
        this.detachedDocument = detachedDocument;
    }

    protected void setCanonicalizationMethods(XAdESSignatureParameters params, String canonicalizationMethod) {
        String signedInfoCanonicalizationMethod_ = params.getSignedInfoCanonicalizationMethod();
        this.signedInfoCanonicalizationMethod = Utils.isStringNotBlank(signedInfoCanonicalizationMethod_) ? signedInfoCanonicalizationMethod_ : canonicalizationMethod;
        String signedPropertiesCanonicalizationMethod_ = params.getSignedPropertiesCanonicalizationMethod();
        this.signedPropertiesCanonicalizationMethod = Utils.isStringNotBlank(signedPropertiesCanonicalizationMethod_) ? signedPropertiesCanonicalizationMethod_ : canonicalizationMethod;
    }

    public byte[] build() throws DSSException {
        this.documentDom = this.buildRootDocumentDom();
        this.deterministicId = this.params.getDeterministicId();
        List<DSSReference> references = this.params.getReferences();
        if (Utils.isCollectionEmpty(references)) {
            List<DSSReference> defaultReferences = this.createDefaultReferences();
            this.params.setReferences(defaultReferences);
        }
        this.incorporateFiles();
        this.incorporateSignatureDom();
        this.incorporateSignedInfo();
        this.incorporateSignatureValue();
        this.incorporateKeyInfo();
        this.incorporateObject();
        this.incorporateReferences();
        this.incorporateReferenceSignedProperties();
        byte[] canonicalizedSignedInfo = DSSXMLUtils.canonicalizeSubtree(this.signedInfoCanonicalizationMethod, this.signedInfoDom);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Canonicalized SignedInfo         --> {}", (Object)new String(canonicalizedSignedInfo));
            byte[] digest = DSSUtils.digest(DigestAlgorithm.SHA256, canonicalizedSignedInfo);
            LOG.trace("Canonicalized SignedInfo SHA256  --> {}", (Object)Utils.toBase64(digest));
        }
        this.built = true;
        return canonicalizedSignedInfo;
    }

    protected void incorporateFiles() {
    }

    protected Document buildRootDocumentDom() {
        return DomUtils.buildDOM();
    }

    public void incorporateSignatureDom() {
        this.signatureDom = this.documentDom.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Signature");
        this.signatureDom.setAttribute("xmlns:ds", "http://www.w3.org/2000/09/xmldsig#");
        this.signatureDom.setAttribute("Id", this.deterministicId);
        Node parentNodeOfSignature = this.getParentNodeOfSignature();
        parentNodeOfSignature.appendChild(this.signatureDom);
    }

    protected Node getParentNodeOfSignature() {
        return this.documentDom;
    }

    public void incorporateSignedInfo() {
        if (this.params.getSignedData() != null) {
            LOG.debug("Using explict SignedInfo from parameter");
            this.signedInfoDom = DomUtils.buildDOM(this.params.getSignedData()).getDocumentElement();
            this.signedInfoDom = (Element)this.documentDom.importNode(this.signedInfoDom, true);
            this.signatureDom.appendChild(this.signedInfoDom);
            return;
        }
        this.signedInfoDom = DomUtils.addElement(this.documentDom, this.signatureDom, "http://www.w3.org/2000/09/xmldsig#", "ds:SignedInfo");
        this.incorporateCanonicalizationMethod(this.signedInfoDom, this.signedInfoCanonicalizationMethod);
        Element signatureMethod = DomUtils.addElement(this.documentDom, this.signedInfoDom, "http://www.w3.org/2000/09/xmldsig#", "ds:SignatureMethod");
        EncryptionAlgorithm encryptionAlgorithm = this.params.getEncryptionAlgorithm();
        DigestAlgorithm digestAlgorithm = this.params.getDigestAlgorithm();
        MaskGenerationFunction mgf = this.params.getMaskGenerationFunction();
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.getAlgorithm(encryptionAlgorithm, digestAlgorithm, mgf);
        String signatureAlgorithmXMLId = signatureAlgorithm.getXMLId();
        if (Utils.isStringBlank(signatureAlgorithmXMLId)) {
            throw new DSSException("Unsupported signature algorithm " + (Object)((Object)signatureAlgorithm));
        }
        signatureMethod.setAttribute("Algorithm", signatureAlgorithmXMLId);
    }

    private void incorporateCanonicalizationMethod(Element parentDom, String signedInfoCanonicalizationMethod) {
        Element canonicalizationMethodDom = DomUtils.addElement(this.documentDom, parentDom, "http://www.w3.org/2000/09/xmldsig#", "ds:CanonicalizationMethod");
        canonicalizationMethodDom.setAttribute("Algorithm", signedInfoCanonicalizationMethod);
    }

    private void incorporateReferences() {
        if (this.params.getSignedData() != null) {
            return;
        }
        List<DSSReference> references = this.params.getReferences();
        for (DSSReference reference : references) {
            this.incorporateReference(reference);
        }
    }

    protected void incorporateKeyInfo() throws DSSException {
        if (this.params.getSigningCertificate() == null && this.params.isGenerateTBSWithoutCertificate()) {
            LOG.debug("Signing certificate not available and must be added to signature DOM later");
            return;
        }
        Element keyInfoDom = DomUtils.addElement(this.documentDom, this.signatureDom, "http://www.w3.org/2000/09/xmldsig#", "ds:KeyInfo");
        BaselineBCertificateSelector certSelector = new BaselineBCertificateSelector(this.certificateVerifier, this.params);
        List<CertificateToken> certificates = certSelector.getCertificates();
        if (this.params.isAddX509SubjectName()) {
            for (CertificateToken token : certificates) {
                Element x509DataDom = DomUtils.addElement(this.documentDom, keyInfoDom, "http://www.w3.org/2000/09/xmldsig#", "ds:X509Data");
                this.addSubjectAndCertificate(x509DataDom, token);
            }
        } else {
            Element x509DataDom = DomUtils.addElement(this.documentDom, keyInfoDom, "http://www.w3.org/2000/09/xmldsig#", "ds:X509Data");
            for (CertificateToken token : certificates) {
                this.addCertificate(x509DataDom, token);
            }
        }
    }

    private void addSubjectAndCertificate(Element x509DataDom, CertificateToken token) {
        DomUtils.addTextElement(this.documentDom, x509DataDom, "http://www.w3.org/2000/09/xmldsig#", "ds:X509SubjectName", token.getSubjectX500Principal().getName("RFC2253"));
        this.addCertificate(x509DataDom, token);
    }

    private void addCertificate(Element x509DataDom, CertificateToken token) {
        DomUtils.addTextElement(this.documentDom, x509DataDom, "http://www.w3.org/2000/09/xmldsig#", "ds:X509Certificate", Utils.toBase64(token.getEncoded()));
    }

    protected void incorporateObject() {
        if (this.params.getSignedAdESObject() != null) {
            LOG.debug("Incorporating signed XAdES Object from parameter");
            Node signedObjectDom = DomUtils.buildDOM(this.params.getSignedAdESObject()).getDocumentElement();
            signedObjectDom = this.documentDom.importNode(signedObjectDom, true);
            this.signatureDom.appendChild(signedObjectDom);
            return;
        }
        Element objectDom = DomUtils.addElement(this.documentDom, this.signatureDom, "http://www.w3.org/2000/09/xmldsig#", "ds:Object");
        this.qualifyingPropertiesDom = DomUtils.addElement(this.documentDom, objectDom, XAdESNamespaces.XAdES, "xades:QualifyingProperties");
        this.qualifyingPropertiesDom.setAttribute("xmlns:xades", XAdESNamespaces.XAdES);
        this.qualifyingPropertiesDom.setAttribute("Target", "#" + this.deterministicId);
        this.incorporateSignedProperties();
    }

    protected void incorporateReferenceSignedProperties() {
        if (this.params.getSignedData() != null) {
            return;
        }
        Element reference = DomUtils.addElement(this.documentDom, this.signedInfoDom, "http://www.w3.org/2000/09/xmldsig#", "ds:Reference");
        reference.setAttribute("Type", this.xPathQueryHolder.XADES_SIGNED_PROPERTIES);
        reference.setAttribute("URI", "#xades-" + this.deterministicId);
        Element transforms = DomUtils.addElement(this.documentDom, reference, "http://www.w3.org/2000/09/xmldsig#", "ds:Transforms");
        Element transform = DomUtils.addElement(this.documentDom, transforms, "http://www.w3.org/2000/09/xmldsig#", "ds:Transform");
        transform.setAttribute("Algorithm", this.signedPropertiesCanonicalizationMethod);
        DigestAlgorithm digestAlgorithm = this.params.getReferenceDigestAlgorithm() != null ? this.params.getReferenceDigestAlgorithm() : this.params.getDigestAlgorithm();
        this.incorporateDigestMethod(reference, digestAlgorithm);
        byte[] canonicalizedBytes = DSSXMLUtils.canonicalizeSubtree(this.signedPropertiesCanonicalizationMethod, this.signedPropertiesDom);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Canonicalization method  --> {}", (Object)this.signedPropertiesCanonicalizationMethod);
            LOG.trace("Canonicalised REF_2      --> {}", (Object)new String(canonicalizedBytes));
        }
        Element digestValueDom = this.documentDom.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:DigestValue");
        String base64EncodedDigestBytes = Utils.toBase64(DSSUtils.digest(digestAlgorithm, canonicalizedBytes));
        Text textNode = this.documentDom.createTextNode(base64EncodedDigestBytes);
        digestValueDom.appendChild(textNode);
        reference.appendChild(digestValueDom);
    }

    private void incorporateReference(DSSReference dssReference) {
        List<DSSTransform> dssTransforms;
        String referenceType;
        String uri;
        Element referenceDom = DomUtils.addElement(this.documentDom, this.signedInfoDom, "http://www.w3.org/2000/09/xmldsig#", "ds:Reference");
        if (dssReference.getId() != null) {
            referenceDom.setAttribute("Id", dssReference.getId());
        }
        if ((uri = dssReference.getUri()) != null) {
            referenceDom.setAttribute("URI", uri);
        }
        if ((referenceType = dssReference.getType()) != null) {
            referenceDom.setAttribute("Type", referenceType);
        }
        if ((dssTransforms = dssReference.getTransforms()) != null) {
            Element transformsDom = DomUtils.addElement(this.documentDom, referenceDom, "http://www.w3.org/2000/09/xmldsig#", "ds:Transforms");
            for (DSSTransform dssTransform : dssTransforms) {
                Element transformDom = DomUtils.addElement(this.documentDom, transformsDom, "http://www.w3.org/2000/09/xmldsig#", "ds:Transform");
                XAdESSignatureBuilder.createTransform(this.documentDom, dssTransform, transformDom);
            }
        }
        DigestAlgorithm digestAlgorithm = dssReference.getDigestMethodAlgorithm();
        this.incorporateDigestMethod(referenceDom, digestAlgorithm);
        DSSDocument canonicalizedDocument = this.transformReference(dssReference);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Reference canonicalization method  -->" + this.signedInfoCanonicalizationMethod);
        }
        this.incorporateDigestValue(referenceDom, dssReference, digestAlgorithm, canonicalizedDocument);
    }

    static void createTransform(Document document, DSSTransform dssTransform, Element transformDom) {
        transformDom.setAttribute("Algorithm", dssTransform.getAlgorithm());
        String elementName = dssTransform.getElementName();
        String textContent = dssTransform.getTextContent();
        if (Utils.isStringNotBlank(elementName)) {
            String namespace = dssTransform.getNamespace();
            DomUtils.addTextElement(document, transformDom, namespace, elementName, textContent);
        } else if (Utils.isStringNotBlank(textContent)) {
            Document transformContentDoc = DomUtils.buildDOM(textContent);
            Element contextDocumentElement = transformContentDoc.getDocumentElement();
            document.adoptNode(contextDocumentElement);
            transformDom.appendChild(contextDocumentElement);
        }
    }

    private List<DSSReference> createDefaultReferences() {
        ArrayList<DSSReference> references = new ArrayList<DSSReference>();
        references.add(this.createReference(this.detachedDocument, 1));
        return references;
    }

    List<DSSReference> createReferencesForDocuments(List<DSSDocument> documents) {
        ArrayList<DSSReference> references = new ArrayList<DSSReference>();
        int referenceIndex = 1;
        for (DSSDocument dssDocument : documents) {
            references.add(this.createReference(dssDocument, referenceIndex));
            ++referenceIndex;
        }
        return references;
    }

    protected abstract DSSReference createReference(DSSDocument var1, int var2);

    protected abstract DSSDocument transformReference(DSSReference var1);

    protected void incorporateSignatureValue() {
        this.signatureValueDom = DomUtils.addElement(this.documentDom, this.signatureDom, "http://www.w3.org/2000/09/xmldsig#", "ds:SignatureValue");
        this.signatureValueDom.setAttribute("Id", "value-" + this.deterministicId);
    }

    protected void incorporateSignedProperties() {
        this.signedPropertiesDom = DomUtils.addElement(this.documentDom, this.qualifyingPropertiesDom, XAdESNamespaces.XAdES, "xades:SignedProperties");
        this.signedPropertiesDom.setAttribute("Id", "xades-" + this.deterministicId);
        this.incorporateSignedSignatureProperties();
        this.incorporateSignedDataObjectProperties();
    }

    protected void incorporateSignedSignatureProperties() {
        this.signedSignaturePropertiesDom = DomUtils.addElement(this.documentDom, this.signedPropertiesDom, XAdESNamespaces.XAdES, "xades:SignedSignatureProperties");
        this.incorporateSigningTime();
        this.incorporateSigningCertificate();
        this.incorporatePolicy();
        this.incorporateSignatureProductionPlace();
        this.incorporateSignerRole();
    }

    private void incorporatePolicy() {
        Policy signaturePolicy = this.params.bLevel().getSignaturePolicy();
        if (signaturePolicy != null) {
            Element signaturePolicyIdentifierDom = DomUtils.addElement(this.documentDom, this.signedSignaturePropertiesDom, XAdESNamespaces.XAdES, "xades:SignaturePolicyIdentifier");
            String signaturePolicyId = signaturePolicy.getId();
            if (Utils.isStringEmpty(signaturePolicyId)) {
                DomUtils.addElement(this.documentDom, signaturePolicyIdentifierDom, XAdESNamespaces.XAdES, "xades:SignaturePolicyImplied");
            } else {
                String spuri;
                String description;
                Element signaturePolicyIdDom = DomUtils.addElement(this.documentDom, signaturePolicyIdentifierDom, XAdESNamespaces.XAdES, "xades:SignaturePolicyId");
                Element sigPolicyIdDom = DomUtils.addElement(this.documentDom, signaturePolicyIdDom, XAdESNamespaces.XAdES, "xades:SigPolicyId");
                Element identifierDom = DomUtils.addTextElement(this.documentDom, sigPolicyIdDom, XAdESNamespaces.XAdES, "xades:Identifier", signaturePolicyId);
                String qualifier = signaturePolicy.getQualifier();
                if (Utils.isStringNotBlank(qualifier)) {
                    identifierDom.setAttribute("Qualifier", qualifier);
                }
                if (Utils.isStringNotEmpty(description = signaturePolicy.getDescription())) {
                    DomUtils.addTextElement(this.documentDom, sigPolicyIdDom, XAdESNamespaces.XAdES, "xades:Description", description);
                }
                if (signaturePolicy.getDigestAlgorithm() != null && signaturePolicy.getDigestValue() != null) {
                    Element sigPolicyHashDom = DomUtils.addElement(this.documentDom, signaturePolicyIdDom, XAdESNamespaces.XAdES, "xades:SigPolicyHash");
                    DigestAlgorithm digestAlgorithm = signaturePolicy.getDigestAlgorithm();
                    this.incorporateDigestMethod(sigPolicyHashDom, digestAlgorithm);
                    byte[] hashValue = signaturePolicy.getDigestValue();
                    String bas64EncodedHashValue = Utils.toBase64(hashValue);
                    DomUtils.addTextElement(this.documentDom, sigPolicyHashDom, "http://www.w3.org/2000/09/xmldsig#", "ds:DigestValue", bas64EncodedHashValue);
                }
                if (Utils.isStringNotEmpty(spuri = signaturePolicy.getSpuri())) {
                    Element sigPolicyQualifiers = DomUtils.addElement(this.documentDom, signaturePolicyIdDom, XAdESNamespaces.XAdES, "xades:SigPolicyQualifiers");
                    Element sigPolicyQualifier = DomUtils.addElement(this.documentDom, sigPolicyQualifiers, XAdESNamespaces.XAdES, "xades:SigPolicyQualifier");
                    DomUtils.addTextElement(this.documentDom, sigPolicyQualifier, XAdESNamespaces.XAdES, "xades:SPURI", spuri);
                }
            }
        }
    }

    private void incorporateSigningTime() {
        Date signingDate = this.params.bLevel().getSigningDate();
        XMLGregorianCalendar xmlGregorianCalendar = DomUtils.createXMLGregorianCalendar(signingDate);
        String xmlSigningTime = xmlGregorianCalendar.toXMLFormat();
        Element signingTimeDom = this.documentDom.createElementNS(XAdESNamespaces.XAdES, "xades:SigningTime");
        this.signedSignaturePropertiesDom.appendChild(signingTimeDom);
        Text textNode = this.documentDom.createTextNode(xmlSigningTime);
        signingTimeDom.appendChild(textNode);
    }

    private void incorporateSigningCertificate() {
        if (this.params.getSigningCertificate() == null && this.params.isGenerateTBSWithoutCertificate()) {
            return;
        }
        HashSet<CertificateToken> certificates = new HashSet<CertificateToken>();
        certificates.add(this.params.getSigningCertificate());
        if (this.params.isEn319132()) {
            this.incorporateSigningCertificateV2(certificates);
        } else {
            this.incorporateSigningCertificateV1(certificates);
        }
    }

    private void incorporateSigningCertificateV1(Set<CertificateToken> certificates) {
        Element signingCertificateDom = DomUtils.addElement(this.documentDom, this.signedSignaturePropertiesDom, XAdESNamespaces.XAdES, XAdESNamespaces.getXADES_SIGNING_CERTIFICATE());
        for (CertificateToken certificate : certificates) {
            Element certDom = this.incorporateCert(signingCertificateDom, certificate);
            this.incorporateIssuerV1(certDom, certificate);
        }
    }

    private void incorporateSigningCertificateV2(Set<CertificateToken> certificates) {
        Element signingCertificateDom = DomUtils.addElement(this.documentDom, this.signedSignaturePropertiesDom, XAdESNamespaces.XAdES, XAdESNamespaces.getXADES_SIGNING_CERTIFICATE_V2());
        for (CertificateToken certificate : certificates) {
            Element certDom = this.incorporateCert(signingCertificateDom, certificate);
            this.incorporateIssuerV2(certDom, certificate);
        }
    }

    private void incorporateSignedDataObjectProperties() {
        this.signedDataObjectPropertiesDom = DomUtils.addElement(this.documentDom, this.signedPropertiesDom, XAdESNamespaces.XAdES, "xades:SignedDataObjectProperties");
        List<DSSReference> references = this.params.getReferences();
        for (DSSReference reference : references) {
            String dataObjectFormatObjectReference = "#" + reference.getId();
            Element dataObjectFormatDom = DomUtils.addElement(this.documentDom, this.signedDataObjectPropertiesDom, XAdESNamespaces.XAdES, "xades:DataObjectFormat");
            dataObjectFormatDom.setAttribute("ObjectReference", dataObjectFormatObjectReference);
            Element mimeTypeDom = DomUtils.addElement(this.documentDom, dataObjectFormatDom, XAdESNamespaces.XAdES, "xades:MimeType");
            MimeType dataObjectFormatMimeType = this.getReferenceMimeType(reference);
            DomUtils.setTextNode(this.documentDom, mimeTypeDom, dataObjectFormatMimeType.getMimeTypeString());
        }
        this.incorporateCommitmentTypeIndications();
        this.incorporateContentTimestamps();
    }

    private MimeType getReferenceMimeType(DSSReference reference) {
        MimeType dataObjectFormatMimeType = MimeType.BINARY;
        DSSDocument content = reference.getContents();
        if (content != null && content.getMimeType() != null) {
            dataObjectFormatMimeType = content.getMimeType();
        }
        return dataObjectFormatMimeType;
    }

    private void incorporateContentTimestamps() {
        List<TimestampToken> contentTimestamps = this.params.getContentTimestamps();
        if (contentTimestamps == null) {
            return;
        }
        for (TimestampToken contentTimestamp : contentTimestamps) {
            String timestampId = "TS-" + contentTimestamp.getDSSIdAsString();
            TimestampType timeStampType = contentTimestamp.getTimeStampType();
            if (TimestampType.ALL_DATA_OBJECTS_TIMESTAMP.equals((Object)timeStampType)) {
                Element allDataObjectsTimestampDom = DomUtils.addElement(this.documentDom, this.signedDataObjectPropertiesDom, XAdESNamespaces.XAdES, "xades:AllDataObjectsTimeStamp");
                allDataObjectsTimestampDom.setAttribute("Id", timestampId);
                this.addTimestamp(allDataObjectsTimestampDom, contentTimestamp);
                continue;
            }
            if (TimestampType.INDIVIDUAL_DATA_OBJECTS_TIMESTAMP.equals((Object)timeStampType)) {
                Element individualDataObjectsTimestampDom = DomUtils.addElement(this.documentDom, this.signedDataObjectPropertiesDom, XAdESNamespaces.XAdES, "xades:IndividualDataObjectsTimeStamp");
                individualDataObjectsTimestampDom.setAttribute("Id", timestampId);
                this.addTimestamp(individualDataObjectsTimestampDom, contentTimestamp);
                continue;
            }
            throw new DSSException("Only types ALL_DATA_OBJECTS_TIMESTAMP and INDIVIDUAL_DATA_OBJECTS_TIMESTAMP are allowed");
        }
    }

    private void incorporateSignerRole() {
        List<String> claimedSignerRoles = this.params.bLevel().getClaimedSignerRoles();
        if (claimedSignerRoles != null) {
            Element signerRoleDom = this.params.isEn319132() ? DomUtils.addElement(this.documentDom, this.signedSignaturePropertiesDom, XAdESNamespaces.XAdES, "xades:SignerRoleV2") : DomUtils.addElement(this.documentDom, this.signedSignaturePropertiesDom, XAdESNamespaces.XAdES, "xades:SignerRole");
            if (Utils.isCollectionNotEmpty(claimedSignerRoles)) {
                Element claimedRolesDom = DomUtils.addElement(this.documentDom, signerRoleDom, XAdESNamespaces.XAdES, "xades:ClaimedRoles");
                this.addRoles(claimedSignerRoles, claimedRolesDom, "xades:ClaimedRole");
            }
        }
    }

    private void addRoles(List<String> signerRoles, Element rolesDom, String roleType) {
        for (String signerRole : signerRoles) {
            Element roleDom = DomUtils.addElement(this.documentDom, rolesDom, XAdESNamespaces.XAdES, roleType);
            DomUtils.setTextNode(this.documentDom, roleDom, signerRole);
        }
    }

    private void incorporateSignatureProductionPlace() {
        SignerLocation signatureProductionPlace = this.params.bLevel().getSignerLocation();
        if (signatureProductionPlace != null) {
            String country;
            String postalCode;
            String stateOrProvince;
            String streetAddress;
            Element signatureProductionPlaceDom = this.params.isEn319132() ? DomUtils.addElement(this.documentDom, this.signedSignaturePropertiesDom, XAdESNamespaces.XAdES, "xades:SignatureProductionPlaceV2") : DomUtils.addElement(this.documentDom, this.signedSignaturePropertiesDom, XAdESNamespaces.XAdES, "xades:SignatureProductionPlace");
            String city = signatureProductionPlace.getLocality();
            if (city != null) {
                DomUtils.addTextElement(this.documentDom, signatureProductionPlaceDom, XAdESNamespaces.XAdES, "xades:City", city);
            }
            if (this.params.isEn319132() && (streetAddress = signatureProductionPlace.getStreet()) != null) {
                DomUtils.addTextElement(this.documentDom, signatureProductionPlaceDom, XAdESNamespaces.XAdES, "xades:StreetAddress", streetAddress);
            }
            if ((stateOrProvince = signatureProductionPlace.getStateOrProvince()) != null) {
                DomUtils.addTextElement(this.documentDom, signatureProductionPlaceDom, XAdESNamespaces.XAdES, "xades:StateOrProvince", stateOrProvince);
            }
            if ((postalCode = signatureProductionPlace.getPostalCode()) != null) {
                DomUtils.addTextElement(this.documentDom, signatureProductionPlaceDom, XAdESNamespaces.XAdES, "xades:PostalCode", postalCode);
            }
            if ((country = signatureProductionPlace.getCountry()) != null) {
                DomUtils.addTextElement(this.documentDom, signatureProductionPlaceDom, XAdESNamespaces.XAdES, "xades:CountryName", country);
            }
        }
    }

    private void incorporateCommitmentTypeIndications() {
        List<String> commitmentTypeIndications = this.params.bLevel().getCommitmentTypeIndications();
        if (Utils.isCollectionNotEmpty(commitmentTypeIndications)) {
            for (String commitmentTypeIndication : commitmentTypeIndications) {
                Element commitmentTypeIndicationDom = DomUtils.addElement(this.documentDom, this.signedDataObjectPropertiesDom, XAdESNamespaces.XAdES, "xades:CommitmentTypeIndication");
                Element commitmentTypeIdDom = DomUtils.addElement(this.documentDom, commitmentTypeIndicationDom, XAdESNamespaces.XAdES, "xades:CommitmentTypeId");
                DomUtils.addTextElement(this.documentDom, commitmentTypeIdDom, XAdESNamespaces.XAdES, "xades:Identifier", commitmentTypeIndication);
                DomUtils.addElement(this.documentDom, commitmentTypeIndicationDom, XAdESNamespaces.XAdES, "xades:AllSignedDataObjects");
            }
        }
    }

    @Override
    public DSSDocument signDocument(byte[] signatureValue) throws DSSException {
        if (!this.built) {
            this.build();
        }
        EncryptionAlgorithm encryptionAlgorithm = this.params.getEncryptionAlgorithm();
        byte[] signatureValueBytes = DSSSignatureUtils.convertToXmlDSig(encryptionAlgorithm, signatureValue);
        String signatureValueBase64Encoded = Utils.toBase64(signatureValueBytes);
        Text signatureValueNode = this.documentDom.createTextNode(signatureValueBase64Encoded);
        this.signatureValueDom.appendChild(signatureValueNode);
        byte[] documentBytes = DSSXMLUtils.serializeNode(this.documentDom);
        InMemoryDocument inMemoryDocument = new InMemoryDocument(documentBytes);
        inMemoryDocument.setMimeType(MimeType.XML);
        return inMemoryDocument;
    }

    protected void addTimestamp(Element timestampElement, TimestampToken token) {
        String canonicalizationMethod;
        List<TimestampInclude> includes = token.getTimestampIncludes();
        if (includes != null) {
            for (TimestampInclude include : includes) {
                Element timestampIncludeElement = this.documentDom.createElementNS(XAdESNamespaces.XAdES, "xades:Include");
                String uri = include.getURI();
                if (!uri.startsWith("#")) {
                    uri = "#" + uri;
                }
                timestampIncludeElement.setAttribute("URI", uri);
                timestampIncludeElement.setAttribute("referencedData", "true");
                timestampElement.appendChild(timestampIncludeElement);
            }
        }
        if (Utils.isStringNotEmpty(canonicalizationMethod = token.getCanonicalizationMethod())) {
            Element canonicalizationMethodElement = this.documentDom.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:CanonicalizationMethod");
            canonicalizationMethodElement.setAttribute("Algorithm", canonicalizationMethod);
            timestampElement.appendChild(canonicalizationMethodElement);
        }
        Element encapsulatedTimestampElement = this.documentDom.createElementNS(XAdESNamespaces.XAdES, "xades:EncapsulatedTimeStamp");
        encapsulatedTimestampElement.setTextContent(Utils.toBase64(token.getEncoded()));
        timestampElement.appendChild(encapsulatedTimestampElement);
    }

    protected byte[] applyTransformations(DSSDocument dssDocument, List<DSSTransform> transforms, Node nodeToTransform) {
        byte[] transformedReferenceBytes = null;
        for (DSSTransform transform : transforms) {
            String transformAlgorithm = transform.getAlgorithm();
            if ("http://www.w3.org/TR/1999/REC-xpath-19991116".equals(transformAlgorithm)) {
                DSSTransformXPath transformXPath = new DSSTransformXPath(transform);
                byte[] transformedBytes = nodeToTransform == null ? transformXPath.transform(dssDocument) : transformXPath.transform(nodeToTransform);
                dssDocument = new InMemoryDocument(transformedBytes);
                nodeToTransform = DomUtils.buildDOM(dssDocument);
                continue;
            }
            if (DSSXMLUtils.canCanonicalize(transformAlgorithm)) {
                if (nodeToTransform == null) {
                    nodeToTransform = DomUtils.buildDOM(dssDocument);
                }
                transformedReferenceBytes = DSSXMLUtils.canonicalizeSubtree(transformAlgorithm, nodeToTransform);
                break;
            }
            if ("http://www.w3.org/2000/09/xmldsig#enveloped-signature".equals(transformAlgorithm)) continue;
            throw new DSSException("The transformation is not implemented yet, please transform the reference before signing!");
        }
        return transformedReferenceBytes;
    }
}

