/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.Digest;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.DigestMatcherType;
import eu.europa.esig.dss.validation.ReferenceValidation;
import eu.europa.esig.dss.xades.XPathQueryHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ManifestValidator {
    private static final Logger LOG = LoggerFactory.getLogger(ManifestValidator.class);
    private final Node manifestNode;
    private final List<DSSDocument> detachedContents;
    private final XPathQueryHolder xPathQueryHolder;

    ManifestValidator(Node manifestNode, List<DSSDocument> detachedContents, XPathQueryHolder xPathQueryHolder) {
        this.manifestNode = manifestNode;
        this.detachedContents = detachedContents;
        this.xPathQueryHolder = xPathQueryHolder;
    }

    List<ReferenceValidation> validate() {
        LOG.info("Validation of the manifest references ...");
        ArrayList<ReferenceValidation> result = new ArrayList<ReferenceValidation>();
        NodeList nodeList = DomUtils.getNodeList(this.manifestNode, "./ds:Reference");
        if (nodeList != null && nodeList.getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                ReferenceValidation refValidation = new ReferenceValidation();
                refValidation.setType(DigestMatcherType.MANIFEST_ENTRY);
                Element refNode = (Element)nodeList.item(i);
                String filename = refNode.getAttribute("URI");
                refValidation.setName(filename);
                Digest digest = this.getDigest(refNode);
                refValidation.setDigest(digest);
                DSSDocument doc = this.findByFilename(filename);
                if (doc != null) {
                    refValidation.setFound(true);
                    refValidation.setIntact(this.isIntact(digest, doc));
                } else {
                    refValidation.setFound(false);
                }
                result.add(refValidation);
            }
        }
        return result;
    }

    private Digest getDigest(Element refNode) {
        try {
            NodeList nodeList = DomUtils.getNodeList(refNode, this.xPathQueryHolder.XPATH__DS_TRANSFORM);
            if (nodeList != null && nodeList.getLength() > 0) {
                throw new DSSException("Transformations are not supported");
            }
            String digestAlgoUri = DomUtils.getValue(refNode, this.xPathQueryHolder.XPATH__DIGEST_METHOD_ALGORITHM);
            DigestAlgorithm digestAlgorithm = DigestAlgorithm.forXML(digestAlgoUri);
            String digestValueB64 = DomUtils.getValue(refNode, this.xPathQueryHolder.XPATH__DIGEST_VALUE);
            return new Digest(digestAlgorithm, Utils.fromBase64(digestValueB64));
        }
        catch (Exception e) {
            LOG.warn("Unable to extract the digest combination : {}", (Object)e.getMessage());
            return null;
        }
    }

    private DSSDocument findByFilename(String filename) {
        for (DSSDocument dssDocument : this.detachedContents) {
            if (!Utils.areStringsEqual(filename, dssDocument.getName())) continue;
            return dssDocument;
        }
        return null;
    }

    private boolean isIntact(Digest digest, DSSDocument doc) {
        if (digest == null) {
            return false;
        }
        try {
            String documentDigestB64 = doc.getDigest(digest.getAlgorithm());
            return Arrays.equals(digest.getValue(), Utils.fromBase64(documentDigestB64));
        }
        catch (Exception e) {
            LOG.warn("Unable to verify integrity for document '{}' : {}", (Object)doc.getName(), (Object)e.getMessage());
            return false;
        }
    }
}

