/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.x509.crl.OfflineCRLSource;
import eu.europa.esig.dss.xades.XPathQueryHolder;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XAdESCRLSource
extends OfflineCRLSource {
    public XAdESCRLSource(Element signatureElement, XPathQueryHolder xPathQueryHolder) {
        Objects.requireNonNull(signatureElement, "Signature element cannot be null");
        Objects.requireNonNull(xPathQueryHolder, "XPathQueryHolder cannot be null");
        HashSet<String> base64Crls = new HashSet<String>();
        this.collect(base64Crls, signatureElement, xPathQueryHolder.XPATH_CRL_VALUES_ENCAPSULATED_CRL);
        this.collect(base64Crls, signatureElement, xPathQueryHolder.XPATH_TSVD_ENCAPSULATED_CRL_VALUES);
        for (String base64Crl : base64Crls) {
            this.addCRLBinary(Utils.fromBase64(base64Crl));
        }
    }

    private void collect(Set<String> base64Crls, Element signatureElement, String xPathQuery) {
        NodeList nodeList = DomUtils.getNodeList(signatureElement, xPathQuery);
        for (int ii = 0; ii < nodeList.getLength(); ++ii) {
            Element crlValueEl = (Element)nodeList.item(ii);
            base64Crls.add(crlValueEl.getTextContent());
        }
    }
}

