/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.DSSRevocationUtils;
import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.x509.ocsp.OfflineOCSPSource;
import eu.europa.esig.dss.xades.XPathQueryHolder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XAdESOCSPSource
extends OfflineOCSPSource {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESOCSPSource.class);
    private final Element signatureElement;
    private final XPathQueryHolder xPathQueryHolder;
    private List<BasicOCSPResp> containedOCSPResponses;

    public XAdESOCSPSource(Element signatureElement, XPathQueryHolder xPathQueryHolder) {
        Objects.requireNonNull(signatureElement, "Signature element cannot be null");
        Objects.requireNonNull(xPathQueryHolder, "XPathQueryHolder cannot be null");
        this.signatureElement = signatureElement;
        this.xPathQueryHolder = xPathQueryHolder;
    }

    @Override
    public List<BasicOCSPResp> getContainedOCSPResponses() {
        if (this.containedOCSPResponses == null) {
            HashSet<String> base64OcspValues = new HashSet<String>();
            this.collect(base64OcspValues, this.xPathQueryHolder.XPATH_OCSP_VALUES_ENCAPSULATED_OCSP);
            this.collect(base64OcspValues, this.xPathQueryHolder.XPATH_TSVD_ENCAPSULATED_OCSP_VALUE);
            this.containedOCSPResponses = this.convert(base64OcspValues);
        }
        return this.containedOCSPResponses;
    }

    private void collect(Set<String> base64OcspValues, String xPathQuery) {
        NodeList nodeList = DomUtils.getNodeList(this.signatureElement, xPathQuery);
        for (int ii = 0; ii < nodeList.getLength(); ++ii) {
            Element ocspValueEl = (Element)nodeList.item(ii);
            base64OcspValues.add(ocspValueEl.getTextContent());
        }
    }

    private List<BasicOCSPResp> convert(Set<String> base64OcspValues) {
        ArrayList<BasicOCSPResp> result = new ArrayList<BasicOCSPResp>();
        for (String base64OcspValue : base64OcspValues) {
            try {
                result.add(DSSRevocationUtils.loadOCSPBase64Encoded(base64OcspValue));
            }
            catch (Exception e) {
                LOG.warn("Cannot retrieve OCSP response from '" + base64OcspValue + "' : " + e.getMessage(), e);
            }
        }
        return result;
    }

    public List<BasicOCSPResp> getEncapsulatedOCSPValues() {
        HashSet<String> base64OCSPValues = new HashSet<String>();
        this.collect(base64OCSPValues, this.xPathQueryHolder.XPATH_OCSP_VALUES_ENCAPSULATED_OCSP);
        return this.convert(base64OCSPValues);
    }

    public List<BasicOCSPResp> getTimestampEncapsulatedOCSPValues() {
        HashSet<String> base64OCSPValues = new HashSet<String>();
        this.collect(base64OCSPValues, this.xPathQueryHolder.XPATH_TSVD_ENCAPSULATED_OCSP_VALUE);
        return this.convert(base64OCSPValues);
    }
}

