/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.Digest;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.EncryptionAlgorithm;
import eu.europa.esig.dss.MaskGenerationFunction;
import eu.europa.esig.dss.MimeType;
import eu.europa.esig.dss.SignatureAlgorithm;
import eu.europa.esig.dss.SignatureForm;
import eu.europa.esig.dss.SignatureLevel;
import eu.europa.esig.dss.TokenIdentifier;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CRLRef;
import eu.europa.esig.dss.validation.CandidatesForSigningCertificate;
import eu.europa.esig.dss.validation.CertificateRef;
import eu.europa.esig.dss.validation.CertificateValidity;
import eu.europa.esig.dss.validation.CertifiedRole;
import eu.europa.esig.dss.validation.CommitmentType;
import eu.europa.esig.dss.validation.DefaultAdvancedSignature;
import eu.europa.esig.dss.validation.DigestMatcherType;
import eu.europa.esig.dss.validation.OCSPRef;
import eu.europa.esig.dss.validation.ReferenceValidation;
import eu.europa.esig.dss.validation.SignatureCryptographicVerification;
import eu.europa.esig.dss.validation.SignaturePolicyProvider;
import eu.europa.esig.dss.validation.SignatureProductionPlace;
import eu.europa.esig.dss.validation.TimestampInclude;
import eu.europa.esig.dss.validation.TimestampReference;
import eu.europa.esig.dss.validation.TimestampToken;
import eu.europa.esig.dss.validation.TimestampedObjectType;
import eu.europa.esig.dss.x509.ArchiveTimestampType;
import eu.europa.esig.dss.x509.CertificatePool;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.SignaturePolicy;
import eu.europa.esig.dss.x509.TimestampType;
import eu.europa.esig.dss.x509.crl.OfflineCRLSource;
import eu.europa.esig.dss.x509.ocsp.OfflineOCSPSource;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.SantuarioInitializer;
import eu.europa.esig.dss.xades.XPathQueryHolder;
import eu.europa.esig.dss.xades.validation.DetachedSignatureResolver;
import eu.europa.esig.dss.xades.validation.ManifestValidator;
import eu.europa.esig.dss.xades.validation.SignatureRSARIPEMD160AT;
import eu.europa.esig.dss.xades.validation.XAdESCRLSource;
import eu.europa.esig.dss.xades.validation.XAdESCertificateSource;
import eu.europa.esig.dss.xades.validation.XAdESOCSPSource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import javax.xml.transform.stream.StreamSource;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.SignedInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.utils.XMLUtils;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.GeneralName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XAdESSignature
extends DefaultAdvancedSignature {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESSignature.class);
    private static SignatureLevel[] signatureLevels = new SignatureLevel[]{SignatureLevel.XML_NOT_ETSI, SignatureLevel.XAdES_BASELINE_B, SignatureLevel.XAdES_BASELINE_T, SignatureLevel.XAdES_C, SignatureLevel.XAdES_X, SignatureLevel.XAdES_BASELINE_LT, SignatureLevel.XAdES_BASELINE_LTA};
    private final List<XPathQueryHolder> xPathQueryHolders;
    protected XPathQueryHolder xPathQueryHolder;
    private final Element signatureElement;
    private String signatureId;
    private XAdESCertificateSource certificatesSource;
    private transient List<Reference> references = new ArrayList<Reference>();
    private List<TimestampReference> signingCertificateTimestampReferences;

    public XAdESSignature(Element signatureElement) {
        this(signatureElement, Arrays.asList(new XPathQueryHolder()), new CertificatePool());
    }

    public XAdESSignature(Element signatureElement, List<XPathQueryHolder> xPathQueryHolders, CertificatePool certPool) {
        super(certPool);
        if (signatureElement == null) {
            throw new NullPointerException("signatureElement");
        }
        this.signatureElement = signatureElement;
        this.xPathQueryHolders = xPathQueryHolders;
        this.initialiseSettings();
    }

    private void initialiseSettings() {
        this.recursiveNamespaceBrowser(this.signatureElement);
        if (this.xPathQueryHolder == null) {
            LOG.warn("There is no suitable XPathQueryHolder to manage the signature. The default one will be used.");
            this.xPathQueryHolder = new XPathQueryHolder();
        }
    }

    public void recursiveNamespaceBrowser(Element element) {
        for (int ii = 0; ii < element.getChildNodes().getLength(); ++ii) {
            Node node = element.getChildNodes().item(ii);
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            String namespaceURI = childElement.getNamespaceURI();
            String localName = childElement.getLocalName();
            if ("Transform".equals(localName) && "http://www.w3.org/2000/09/xmldsig#".equals(namespaceURI)) continue;
            if ("QualifyingProperties".equals(localName)) {
                this.setXPathQueryHolder(namespaceURI);
                return;
            }
            this.recursiveNamespaceBrowser(childElement);
        }
    }

    private void setXPathQueryHolder(String namespaceURI) {
        for (XPathQueryHolder xPathQueryHolder : this.xPathQueryHolders) {
            boolean canUseThisXPathQueryHolder = xPathQueryHolder.canUseThisXPathQueryHolder(namespaceURI);
            if (!canUseThisXPathQueryHolder) continue;
            this.xPathQueryHolder = xPathQueryHolder;
        }
    }

    public XPathQueryHolder getXPathQueryHolder() {
        return this.xPathQueryHolder;
    }

    public Element getSignatureElement() {
        return this.signatureElement;
    }

    @Override
    public SignatureForm getSignatureForm() {
        return SignatureForm.XAdES;
    }

    @Override
    public EncryptionAlgorithm getEncryptionAlgorithm() {
        SignatureAlgorithm signatureAlgorithm = this.getSignatureAlgorithm();
        if (signatureAlgorithm == null) {
            return null;
        }
        return signatureAlgorithm.getEncryptionAlgorithm();
    }

    @Override
    public DigestAlgorithm getDigestAlgorithm() {
        SignatureAlgorithm signatureAlgorithm = this.getSignatureAlgorithm();
        if (signatureAlgorithm == null) {
            return null;
        }
        return signatureAlgorithm.getDigestAlgorithm();
    }

    @Override
    public MaskGenerationFunction getMaskGenerationFunction() {
        SignatureAlgorithm signatureAlgorithm = this.getSignatureAlgorithm();
        if (signatureAlgorithm == null) {
            return null;
        }
        return signatureAlgorithm.getMaskGenerationFunction();
    }

    @Override
    public SignatureAlgorithm getSignatureAlgorithm() {
        String xmlName = DomUtils.getElement(this.signatureElement, this.xPathQueryHolder.XPATH_SIGNATURE_METHOD).getAttribute("Algorithm");
        return SignatureAlgorithm.forXML(xmlName, null);
    }

    @Override
    public XAdESCertificateSource getCertificateSource() {
        if (this.certificatesSource == null) {
            this.certificatesSource = new XAdESCertificateSource(this.signatureElement, this.xPathQueryHolder, this.certPool);
        }
        return this.certificatesSource;
    }

    public void resetCertificateSource() {
        this.certificatesSource = null;
    }

    @Override
    public OfflineCRLSource getCRLSource() {
        if (this.offlineCRLSource == null) {
            this.offlineCRLSource = new XAdESCRLSource(this.signatureElement, this.xPathQueryHolder);
        }
        return this.offlineCRLSource;
    }

    @Override
    public OfflineOCSPSource getOCSPSource() {
        if (this.offlineOCSPSource == null) {
            this.offlineOCSPSource = new XAdESOCSPSource(this.signatureElement, this.xPathQueryHolder);
        }
        return this.offlineOCSPSource;
    }

    public void resetRevocationSources() {
        this.offlineCRLSource = null;
        this.offlineOCSPSource = null;
    }

    public void resetTimestamps() {
        this.signatureTimestamps = null;
        this.contentTimestamps = null;
        this.archiveTimestamps = null;
        this.sigAndRefsTimestamps = null;
        this.refsOnlyTimestamps = null;
    }

    @Override
    public CandidatesForSigningCertificate getCandidatesForSigningCertificate() {
        if (this.candidatesForSigningCertificate != null) {
            return this.candidatesForSigningCertificate;
        }
        this.candidatesForSigningCertificate = new CandidatesForSigningCertificate();
        XAdESCertificateSource certSource = this.getCertificateSource();
        for (CertificateToken certificateToken : certSource.getKeyInfoCertificates()) {
            CertificateValidity certificateValidity = new CertificateValidity(certificateToken);
            this.candidatesForSigningCertificate.add(certificateValidity);
        }
        return this.candidatesForSigningCertificate;
    }

    @Override
    public void checkSigningCertificate() {
        CandidatesForSigningCertificate candidates = this.getCandidatesForSigningCertificate();
        boolean isEn319132 = false;
        NodeList list = DomUtils.getNodeList(this.signatureElement, this.xPathQueryHolder.XPATH_SIGNING_CERTIFICATE_CERT);
        int length = list.getLength();
        if (length == 0) {
            list = DomUtils.getNodeList(this.signatureElement, this.xPathQueryHolder.XPATH_SIGNING_CERTIFICATE_CERT_V2);
            length = list.getLength();
            isEn319132 = true;
        }
        HashMap<Element, Boolean> alreadyProcessedElements = new HashMap<Element, Boolean>();
        List<CertificateValidity> certificateValidityList = candidates.getCertificateValidityList();
        block11: for (CertificateValidity certificateValidity : certificateValidityList) {
            CertificateToken certificateToken = certificateValidity.getCertificateToken();
            for (int ii = 0; ii < length; ++ii) {
                certificateValidity.setAttributePresent(true);
                Element element = (Element)list.item(ii);
                if (alreadyProcessedElements.containsKey(element)) continue;
                Element certDigestElement = DomUtils.getElement(element, this.xPathQueryHolder.XPATH__CERT_DIGEST);
                certificateValidity.setDigestPresent(certDigestElement != null);
                Element digestMethodElement = DomUtils.getElement(certDigestElement, this.xPathQueryHolder.XPATH__DIGEST_METHOD);
                if (digestMethodElement == null) continue;
                String xmlAlgorithmName = digestMethodElement.getAttribute("Algorithm");
                DigestAlgorithm digestAlgorithm = DigestAlgorithm.forXML(xmlAlgorithmName, DigestAlgorithm.SHA1);
                Element digestValueElement = DomUtils.getElement(element, this.xPathQueryHolder.XPATH__CERT_DIGEST_DIGEST_VALUE);
                if (digestValueElement == null) continue;
                byte[] storedBase64DigestValue = Utils.fromBase64(digestValueElement.getTextContent());
                byte[] digest = certificateToken.getDigest(digestAlgorithm);
                boolean digestEqual = Arrays.equals(digest, storedBase64DigestValue);
                certificateValidity.setDigestEqual(digestEqual);
                if (!digestEqual) continue;
                BigInteger serialNumber = null;
                X500Principal issuerName = null;
                if (isEn319132) {
                    Element issuerSerialV2Element = DomUtils.getElement(element, this.xPathQueryHolder.XPATH__X509_ISSUER_V2);
                    if (issuerSerialV2Element != null) {
                        String textContent = issuerSerialV2Element.getTextContent();
                        try (ASN1InputStream is = new ASN1InputStream(Utils.fromBase64(textContent));){
                            ASN1Integer serial;
                            ASN1Sequence seq = (ASN1Sequence)is.readObject();
                            ASN1Sequence obj = (ASN1Sequence)seq.getObjectAt(0);
                            GeneralName name = GeneralName.getInstance(obj.getObjectAt(0));
                            if (name != null) {
                                issuerName = new X500Principal(name.getName().toASN1Primitive().getEncoded());
                            }
                            if ((serial = (ASN1Integer)seq.getObjectAt(1)) != null) {
                                serialNumber = serial.getValue();
                            }
                        }
                        catch (Exception e) {
                            LOG.error("Unable to decode textContent '" + textContent + "' : " + e.getMessage(), e);
                        }
                    }
                } else {
                    Element issuerNameEl = DomUtils.getElement(element, this.xPathQueryHolder.XPATH__X509_ISSUER_NAME);
                    issuerName = DSSUtils.getX500PrincipalOrNull(issuerNameEl.getTextContent());
                    Element serialNumberEl = DomUtils.getElement(element, this.xPathQueryHolder.XPATH__X509_SERIAL_NUMBER);
                    String serialNumberText = serialNumberEl.getTextContent();
                    serialNumber = new BigInteger(serialNumberText.trim());
                }
                X500Principal candidateIssuerName = certificateToken.getIssuerX500Principal();
                boolean issuerNameMatches = DSSUtils.x500PrincipalAreEquals(candidateIssuerName, issuerName);
                certificateValidity.setDistinguishedNameEqual(issuerNameMatches);
                if (!issuerNameMatches) {
                    String c14nCandidateIssuerName = candidateIssuerName.getName("CANONICAL");
                    LOG.info("candidateIssuerName : {}", (Object)c14nCandidateIssuerName);
                    String c14nIssuerName = issuerName == null ? "" : issuerName.getName("CANONICAL");
                    LOG.info("issuerName : {}", (Object)c14nIssuerName);
                }
                BigInteger candidateSerialNumber = certificateToken.getSerialNumber();
                boolean serialNumberMatches = candidateSerialNumber.equals(serialNumber);
                certificateValidity.setSerialNumberEqual(serialNumberMatches);
                alreadyProcessedElements.put(element, true);
                if (candidates.getTheCertificateValidity() != null) continue block11;
                candidates.setTheCertificateValidity(certificateValidity);
                continue block11;
            }
        }
    }

    @Override
    public Date getSigningTime() {
        Element signingTimeEl = DomUtils.getElement(this.signatureElement, this.xPathQueryHolder.XPATH_SIGNING_TIME);
        if (signingTimeEl == null) {
            return null;
        }
        String text = signingTimeEl.getTextContent();
        return DomUtils.getDate(text);
    }

    @Override
    public void checkSignaturePolicy(SignaturePolicyProvider signaturePolicyProvider) {
        Element policyIdentifier = DomUtils.getElement(this.signatureElement, this.xPathQueryHolder.XPATH_SIGNATURE_POLICY_IDENTIFIER);
        if (policyIdentifier != null) {
            Element policyId = DomUtils.getElement(policyIdentifier, this.xPathQueryHolder.XPATH__POLICY_ID);
            if (policyId != null) {
                String policyUrlString = null;
                String policyIdString = policyId.getTextContent();
                if (Utils.isStringNotEmpty(policyIdString)) {
                    policyIdString = policyIdString.replaceAll("\n", "");
                    if (DSSXMLUtils.isOid(policyIdString = policyIdString.trim())) {
                        policyIdString = policyIdString.substring(policyIdString.lastIndexOf(58) + 1);
                    } else {
                        policyUrlString = policyIdString;
                    }
                }
                this.signaturePolicy = new SignaturePolicy(policyIdString);
                Node policyDigestMethod = DomUtils.getNode(policyIdentifier, this.xPathQueryHolder.XPATH__POLICY_DIGEST_METHOD);
                String policyDigestMethodString = policyDigestMethod.getTextContent();
                if (Utils.isStringNotEmpty(policyDigestMethodString)) {
                    DigestAlgorithm digestAlgorithm = DigestAlgorithm.forXML(policyDigestMethodString);
                    this.signaturePolicy.setDigestAlgorithm(digestAlgorithm);
                }
                Element policyDigestValue = DomUtils.getElement(policyIdentifier, this.xPathQueryHolder.XPATH__POLICY_DIGEST_VALUE);
                String digestValue = policyDigestValue.getTextContent().trim();
                this.signaturePolicy.setDigestValue(digestValue);
                Element policyUrl = DomUtils.getElement(policyIdentifier, this.xPathQueryHolder.XPATH__POLICY_SPURI);
                if (policyUrl != null) {
                    policyUrlString = policyUrl.getTextContent().trim();
                }
                this.signaturePolicy.setUrl(policyUrlString);
                this.signaturePolicy.setPolicyContent(signaturePolicyProvider.getSignaturePolicy(policyIdString, policyUrlString));
            } else {
                Element signaturePolicyImplied = DomUtils.getElement(policyIdentifier, this.xPathQueryHolder.XPATH__SIGNATURE_POLICY_IMPLIED);
                if (signaturePolicyImplied != null) {
                    this.signaturePolicy = new SignaturePolicy();
                }
            }
        }
    }

    @Override
    public SignatureProductionPlace getSignatureProductionPlace() {
        NodeList nodeList = DomUtils.getNodeList(this.signatureElement, this.xPathQueryHolder.XPATH_PRODUCTION_PLACE);
        if (!(nodeList.getLength() != 0 && nodeList.item(0) != null || (nodeList = DomUtils.getNodeList(this.signatureElement, this.xPathQueryHolder.XPATH_PRODUCTION_PLACE_V2)).getLength() != 0 && nodeList.item(0) != null)) {
            return null;
        }
        SignatureProductionPlace signatureProductionPlace = new SignatureProductionPlace();
        NodeList list = nodeList.item(0).getChildNodes();
        for (int ii = 0; ii < list.getLength(); ++ii) {
            Node item = list.item(ii);
            String name = item.getLocalName();
            String nodeValue = item.getTextContent();
            if ("City".equals(name)) {
                signatureProductionPlace.setCity(nodeValue);
                continue;
            }
            if ("StateOrProvince".equals(name)) {
                signatureProductionPlace.setStateOrProvince(nodeValue);
                continue;
            }
            if ("PostalCode".equals(name)) {
                signatureProductionPlace.setPostalCode(nodeValue);
                continue;
            }
            if ("CountryName".equals(name)) {
                signatureProductionPlace.setCountryName(nodeValue);
                continue;
            }
            if (!"StreetAddress".equals(name)) continue;
            signatureProductionPlace.setStreetAddress(nodeValue);
        }
        return signatureProductionPlace;
    }

    @Override
    public String[] getClaimedSignerRoles() {
        NodeList nodeList = DomUtils.getNodeList(this.signatureElement, this.xPathQueryHolder.XPATH_CLAIMED_ROLE);
        if (nodeList.getLength() == 0 && (nodeList = DomUtils.getNodeList(this.signatureElement, this.xPathQueryHolder.XPATH_CLAIMED_ROLE_V2)).getLength() == 0) {
            return null;
        }
        String[] roles = new String[nodeList.getLength()];
        for (int ii = 0; ii < nodeList.getLength(); ++ii) {
            roles[ii] = nodeList.item(ii).getTextContent();
        }
        return roles;
    }

    @Override
    public List<CertifiedRole> getCertifiedSignerRoles() {
        NodeList nodeList = DomUtils.getNodeList(this.signatureElement, this.xPathQueryHolder.XPATH_CERTIFIED_ROLE);
        if (nodeList.getLength() == 0 && (nodeList = DomUtils.getNodeList(this.signatureElement, this.xPathQueryHolder.XPATH_CERTIFIED_ROLE_V2)).getLength() == 0) {
            return null;
        }
        ArrayList<CertifiedRole> roles = new ArrayList<CertifiedRole>();
        for (int ii = 0; ii < nodeList.getLength(); ++ii) {
            Element certEl = (Element)nodeList.item(ii);
            String textContent = certEl.getTextContent();
            CertifiedRole role = new CertifiedRole();
            role.setRole(textContent);
            if (roles.contains(role)) continue;
            roles.add(role);
        }
        return roles;
    }

    @Override
    public String getContentType() {
        return MimeType.XML.getMimeTypeString();
    }

    @Override
    public String getContentIdentifier() {
        return null;
    }

    @Override
    public String getContentHints() {
        return null;
    }

    private TimestampToken makeTimestampToken(Element timestampElement, TimestampType timestampType) throws DSSException {
        Element timestampTokenNode = DomUtils.getElement(timestampElement, this.xPathQueryHolder.XPATH__ENCAPSULATED_TIMESTAMP);
        if (timestampTokenNode == null) {
            LOG.warn("The timestamp {} cannot be extracted from the signature!", (Object)timestampType.name());
            return null;
        }
        TimestampToken timestampToken = null;
        try {
            timestampToken = new TimestampToken(Utils.fromBase64(timestampTokenNode.getTextContent()), timestampType, this.certPool);
        }
        catch (Exception e) {
            LOG.warn("Unable to build timestamp object '" + timestampTokenNode.getTextContent() + "' : ", e);
            return null;
        }
        timestampToken.setHashCode(timestampElement.hashCode());
        timestampToken.setCanonicalizationMethod(this.getTimestampCanonicalizationMethod(timestampElement));
        NodeList timestampIncludes = DomUtils.getNodeList(timestampElement, this.xPathQueryHolder.XPATH__INCLUDE);
        if (timestampIncludes != null && timestampIncludes.getLength() > 0) {
            ArrayList<TimestampInclude> includes = new ArrayList<TimestampInclude>();
            for (int jj = 0; jj < timestampIncludes.getLength(); ++jj) {
                Element include = (Element)timestampIncludes.item(jj);
                String uri = this.cleanURI(include.getAttribute("URI"));
                String referencedData = include.getAttribute("referencedData");
                includes.add(new TimestampInclude(uri, Boolean.parseBoolean(referencedData)));
            }
            timestampToken.setTimestampIncludes(includes);
        }
        return timestampToken;
    }

    public Element getSignatureValue() {
        return DomUtils.getElement(this.signatureElement, this.xPathQueryHolder.XPATH_SIGNATURE_VALUE);
    }

    public NodeList getObjects() {
        return DomUtils.getNodeList(this.signatureElement, "./ds:Object");
    }

    public Element getCompleteCertificateRefs() {
        return DomUtils.getElement(this.signatureElement, this.xPathQueryHolder.XPATH_COMPLETE_CERTIFICATE_REFS);
    }

    public Element getCompleteRevocationRefs() {
        return DomUtils.getElement(this.signatureElement, this.xPathQueryHolder.XPATH_COMPLETE_REVOCATION_REFS);
    }

    public NodeList getSigAndRefsTimeStamp() {
        NodeList nodeList = DomUtils.getNodeList(this.signatureElement, this.xPathQueryHolder.XPATH_SIG_AND_REFS_TIMESTAMP);
        if (nodeList == null || nodeList.getLength() == 0) {
            nodeList = DomUtils.getNodeList(this.signatureElement, this.xPathQueryHolder.XPATH_SIG_AND_REFS_TIMESTAMP_V2);
        }
        return nodeList;
    }

    public Element getCertificateValues() {
        return DomUtils.getElement(this.signatureElement, this.xPathQueryHolder.XPATH_CERTIFICATE_VALUES);
    }

    public Element getRevocationValues() {
        return DomUtils.getElement(this.signatureElement, this.xPathQueryHolder.XPATH_REVOCATION_VALUES);
    }

    public boolean hasBProfile() {
        return DomUtils.isNotEmpty(this.signatureElement, this.xPathQueryHolder.XPATH_SIGNED_SIGNATURE_PROPERTIES);
    }

    public boolean hasCProfile() {
        boolean certRefs = DomUtils.isNotEmpty(this.signatureElement, this.xPathQueryHolder.XPATH_COMPLETE_CERTIFICATE_REFS);
        boolean revocationRefs = DomUtils.isNotEmpty(this.signatureElement, this.xPathQueryHolder.XPATH_COMPLETE_REVOCATION_REFS);
        return certRefs || revocationRefs;
    }

    public boolean hasXProfile() {
        return DomUtils.isNotEmpty(this.signatureElement, this.xPathQueryHolder.XPATH_SIG_AND_REFS_TIMESTAMP);
    }

    public void addContentTimestamps(List<TimestampToken> timestampTokens, NodeList nodes, TimestampType timestampType) {
        for (int ii = 0; ii < nodes.getLength(); ++ii) {
            Element element;
            TimestampToken timestampToken;
            Node node = nodes.item(ii);
            if (node.getNodeType() != 1 || (timestampToken = this.makeTimestampToken(element = (Element)node, timestampType)) == null) continue;
            timestampTokens.add(timestampToken);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getContentTimestampData(TimestampToken timestampToken) {
        TimestampType timeStampType = timestampToken.getTimeStampType();
        if (timeStampType != TimestampType.INDIVIDUAL_DATA_OBJECTS_TIMESTAMP && timeStampType != TimestampType.ALL_DATA_OBJECTS_TIMESTAMP) {
            return null;
        }
        if (!this.checkTimestampTokenIncludes(timestampToken)) {
            throw new DSSException("The Included referencedData attribute is either not present or set to false!");
        }
        if (this.references.isEmpty()) {
            throw new DSSException("The method 'checkSignatureIntegrity' must be invoked first!");
        }
        String canonicalizationMethod = timestampToken.getCanonicalizationMethod();
        List<TimestampInclude> includes = timestampToken.getTimestampIncludes();
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            for (Reference reference : this.references) {
                if (!this.isContentTimestampedReference(reference, timeStampType, includes)) continue;
                byte[] referencedBytes = reference.getReferencedBytes();
                if (Utils.isStringNotBlank(canonicalizationMethod) && DomUtils.isDOM(referencedBytes)) {
                    referencedBytes = DSSXMLUtils.canonicalize(canonicalizationMethod, referencedBytes);
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("ReferencedBytes : {}", (Object)new String(referencedBytes));
                }
                outputStream.write(referencedBytes);
            }
            byte[] byteArray = outputStream.toByteArray();
            if (LOG.isTraceEnabled()) {
                LOG.trace("IndividualDataObjectsTimestampData/AllDataObjectsTimestampData bytes: {}", (Object)new String(byteArray));
            }
            byte[] byArray = byteArray;
            return byArray;
        }
        catch (IOException | XMLSecurityException e) {
            throw new DSSException("Unable to extract IndividualDataObjectsTimestampData/AllDataObjectsTimestampData", e);
        }
    }

    private boolean isContentTimestampedReference(Reference reference, TimestampType timeStampType, List<TimestampInclude> includes) {
        if (timeStampType == TimestampType.ALL_DATA_OBJECTS_TIMESTAMP) {
            return !this.isSignedProperties(reference);
        }
        for (TimestampInclude timestampInclude : includes) {
            String id = timestampInclude.getURI();
            if (!reference.getId().equals(id)) continue;
            return true;
        }
        return false;
    }

    private List<TimestampReference> getSignatureTimestampedReferences() {
        ArrayList<TimestampReference> references = new ArrayList<TimestampReference>();
        TimestampReference signatureReference = this.getSignatureTimestampReference();
        references.add(signatureReference);
        List<TimestampReference> signingCertificateTimestampReferences = this.getSigningCertificateTimestampReferences();
        references.addAll(signingCertificateTimestampReferences);
        return references;
    }

    private List<TimestampReference> getSigningCertificateTimestampReferences() {
        if (this.signingCertificateTimestampReferences == null) {
            this.signingCertificateTimestampReferences = new ArrayList<TimestampReference>();
            NodeList list = DomUtils.getNodeList(this.signatureElement, this.xPathQueryHolder.XPATH_CERT_DIGEST);
            for (int jj = 0; jj < list.getLength(); ++jj) {
                Element element = (Element)list.item(jj);
                TimestampReference signingCertReference = this.createCertificateTimestampReference(element);
                this.signingCertificateTimestampReferences.add(signingCertReference);
            }
        }
        return this.signingCertificateTimestampReferences;
    }

    public boolean checkTimestampTokenIncludes(TimestampToken timestampToken) {
        List<TimestampInclude> timestampIncludes = timestampToken.getTimestampIncludes();
        if (Utils.isCollectionNotEmpty(timestampIncludes)) {
            for (TimestampInclude timestampInclude : timestampIncludes) {
                if (timestampInclude.isReferencedData()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public List<TimestampToken> getContentTimestamps() {
        if (this.contentTimestamps == null) {
            this.makeTimestampTokens();
        }
        return this.contentTimestamps;
    }

    @Override
    public List<TimestampToken> getSignatureTimestamps() {
        if (this.signatureTimestamps == null) {
            this.makeTimestampTokens();
        }
        return this.signatureTimestamps;
    }

    @Override
    public List<TimestampToken> getTimestampsX1() {
        if (this.sigAndRefsTimestamps == null) {
            this.makeTimestampTokens();
        }
        return this.sigAndRefsTimestamps;
    }

    @Override
    public List<TimestampToken> getTimestampsX2() {
        if (this.refsOnlyTimestamps == null) {
            this.makeTimestampTokens();
        }
        return this.refsOnlyTimestamps;
    }

    @Override
    public List<TimestampToken> getArchiveTimestamps() {
        if (this.archiveTimestamps == null) {
            this.makeTimestampTokens();
        }
        return this.archiveTimestamps;
    }

    private void makeTimestampTokens() {
        this.contentTimestamps = new ArrayList();
        this.signatureTimestamps = new ArrayList();
        this.refsOnlyTimestamps = new ArrayList();
        this.sigAndRefsTimestamps = new ArrayList();
        this.archiveTimestamps = new ArrayList();
        NodeList allDataObjectsTimestamps = DomUtils.getNodeList(this.signatureElement, this.xPathQueryHolder.XPATH_ALL_DATA_OBJECTS_TIMESTAMP);
        this.addContentTimestamps(this.contentTimestamps, allDataObjectsTimestamps, TimestampType.ALL_DATA_OBJECTS_TIMESTAMP);
        NodeList individualDataObjectsTimestampsNodes = DomUtils.getNodeList(this.signatureElement, this.xPathQueryHolder.XPATH_INDIVIDUAL_DATA_OBJECTS_TIMESTAMP);
        this.addContentTimestamps(this.contentTimestamps, individualDataObjectsTimestampsNodes, TimestampType.INDIVIDUAL_DATA_OBJECTS_TIMESTAMP);
        Element unsignedSignaturePropertiesDom = this.getUnsignedSignaturePropertiesDom();
        if (unsignedSignaturePropertiesDom == null) {
            return;
        }
        ArrayList<String> timestampedTimestamps = new ArrayList<String>();
        NodeList unsignedProperties = unsignedSignaturePropertiesDom.getChildNodes();
        for (int ii = 0; ii < unsignedProperties.getLength(); ++ii) {
            TimestampToken timestampToken;
            Node node = unsignedProperties.item(ii);
            if (node.getNodeType() != 1) continue;
            String localName = node.getLocalName();
            if ("SignatureTimeStamp".equals(localName)) {
                timestampToken = this.makeTimestampToken((Element)node, TimestampType.SIGNATURE_TIMESTAMP);
                if (timestampToken == null) continue;
                timestampToken.setTimestampedReferences(this.getSignatureTimestampedReferences());
                this.signatureTimestamps.add(timestampToken);
            } else if ("RefsOnlyTimeStamp".equals(localName) || "RefsOnlyTimeStampV2".equals(localName)) {
                timestampToken = this.makeTimestampToken((Element)node, TimestampType.VALIDATION_DATA_REFSONLY_TIMESTAMP);
                if (timestampToken == null) continue;
                timestampToken.setTimestampedReferences(this.getTimestampedReferences());
                this.refsOnlyTimestamps.add(timestampToken);
            } else if ("SigAndRefsTimeStamp".equals(localName) || "SigAndRefsTimeStampV2".equals(localName)) {
                timestampToken = this.makeTimestampToken((Element)node, TimestampType.VALIDATION_DATA_TIMESTAMP);
                if (timestampToken == null) continue;
                List<TimestampReference> references = this.getSignatureTimestampedReferences();
                references.addAll(this.getTimestampedReferences());
                timestampToken.setTimestampedReferences(references);
                this.sigAndRefsTimestamps.add(timestampToken);
            } else {
                if (!"ArchiveTimeStamp".equals(localName) || (timestampToken = this.makeTimestampToken((Element)node, TimestampType.ARCHIVE_TIMESTAMP)) == null) continue;
                ArchiveTimestampType archiveTimestampType = this.getArchiveTimestampType(node, localName);
                timestampToken.setArchiveTimestampType(archiveTimestampType);
                List<TimestampReference> references = this.getSignatureTimestampedReferences();
                for (String timestampId : timestampedTimestamps) {
                    references.add(new TimestampReference(timestampId, TimestampedObjectType.TIMESTAMP));
                }
                references.addAll(this.getTimestampedReferences());
                List<CertificateToken> encapsulatedCertificates = this.getCertificateSource().getEncapsulatedCertificates();
                for (CertificateToken certificateToken : encapsulatedCertificates) {
                    TimestampReference certificateTimestampReference = this.createCertificateTimestampReference(certificateToken);
                    if (references.contains(certificateTimestampReference)) continue;
                    references.add(certificateTimestampReference);
                }
                this.addReferencesFromOfflineCRLSource(references);
                this.addReferencesFromOfflineOCSPSource(references);
                timestampToken.setTimestampedReferences(references);
                this.archiveTimestamps.add(timestampToken);
            }
            timestampedTimestamps.add(timestampToken.getDSSIdAsString());
        }
    }

    private ArchiveTimestampType getArchiveTimestampType(Node node, String localName) {
        String namespaceURI;
        if ("ArchiveTimeStamp".equals(localName) && "http://uri.etsi.org/01903/v1.4.1#".equals(namespaceURI = node.getNamespaceURI())) {
            return ArchiveTimestampType.XAdES_141;
        }
        return ArchiveTimestampType.XAdES;
    }

    private TimestampReference getSignatureTimestampReference() {
        TimestampReference signatureReference = new TimestampReference(this.getId());
        return signatureReference;
    }

    private String getTimestampCanonicalizationMethod(Element timestampElement) {
        Element canonicalizationMethodElement = DomUtils.getElement(timestampElement, this.xPathQueryHolder.XPATH__CANONICALIZATION_METHOD);
        if (canonicalizationMethodElement != null) {
            return canonicalizationMethodElement.getAttribute("Algorithm");
        }
        return null;
    }

    public List<CertificateToken> getKeyInfoCertificates() {
        return this.getCertificateSource().getKeyInfoCertificates();
    }

    public List<CertificateToken> getTimestampCertificates() {
        return this.getCertificateSource().getTimestampCertificates();
    }

    @Override
    public void checkSignatureIntegrity() {
        if (this.signatureCryptographicVerification != null) {
            return;
        }
        this.signatureCryptographicVerification = new SignatureCryptographicVerification();
        try {
            XMLSignature santuarioSignature = this.getSantuarioSignature();
            boolean coreValidity = false;
            List<CertificateValidity> certificateValidityList = this.getSigningCertificateValidityList(santuarioSignature, this.signatureCryptographicVerification, this.providedSigningCertificateToken);
            LOG.debug("Determining signing certificate from certificate candidates list");
            ArrayList<String> preliminaryErrorMessages = new ArrayList<String>();
            int certificateNumber = 0;
            for (CertificateValidity certificateValidity : certificateValidityList) {
                String errorMessagePrefix = "Certificate #" + (certificateNumber + 1) + ": ";
                try {
                    PublicKey publicKey = certificateValidity.getPublicKey();
                    coreValidity = santuarioSignature.checkSignatureValue(publicKey);
                    if (coreValidity) {
                        LOG.info("Determining signing certificate from certificate candidates list succeeded");
                        this.candidatesForSigningCertificate.setTheCertificateValidity(certificateValidity);
                        break;
                    }
                    preliminaryErrorMessages.add(errorMessagePrefix + "Signature verification failed");
                }
                catch (XMLSignatureException e) {
                    LOG.debug("Exception while probing candidate certificate as signing certificate: {}", (Object)e.getMessage());
                    preliminaryErrorMessages.add(errorMessagePrefix + e.getMessage());
                }
                ++certificateNumber;
            }
            if (!coreValidity) {
                LOG.warn("Determining signing certificate from certificate candidates list failed: {}", (Object)preliminaryErrorMessages);
                for (String preliminaryErrorMessage : preliminaryErrorMessages) {
                    this.signatureCryptographicVerification.setErrorMessage(preliminaryErrorMessage);
                }
            }
            boolean allReferenceDataFound = true;
            boolean allReferenceDataIntact = true;
            List<ReferenceValidation> refValidations = this.getReferenceValidations();
            for (ReferenceValidation referenceValidation : refValidations) {
                allReferenceDataFound = allReferenceDataFound && referenceValidation.isFound();
                allReferenceDataIntact = allReferenceDataIntact && referenceValidation.isIntact();
            }
            this.signatureCryptographicVerification.setReferenceDataFound(allReferenceDataFound);
            this.signatureCryptographicVerification.setReferenceDataIntact(allReferenceDataIntact);
            this.signatureCryptographicVerification.setSignatureIntact(coreValidity);
        }
        catch (Exception e) {
            LOG.error("checkSignatureIntegrity : {}", (Object)e.getMessage());
            LOG.debug("checkSignatureIntegrity : " + e.getMessage(), e);
            StackTraceElement[] stackTrace = e.getStackTrace();
            String name = XAdESSignature.class.getName();
            int lineNumber = 0;
            for (StackTraceElement element : stackTrace) {
                String className = element.getClassName();
                if (!className.equals(name)) continue;
                lineNumber = element.getLineNumber();
                break;
            }
            this.signatureCryptographicVerification.setErrorMessage(e.getMessage() + "/ XAdESSignature/Line number/" + lineNumber);
        }
    }

    @Override
    public List<ReferenceValidation> getReferenceValidations() {
        if (this.referenceValidations == null) {
            this.referenceValidations = new ArrayList();
            XMLSignature santuarioSignature = this.getSantuarioSignature();
            SignedInfo signedInfo = santuarioSignature.getSignedInfo();
            int numberOfReferences = signedInfo.getLength();
            boolean signedPropertiesFound = false;
            boolean referenceFound = false;
            for (int ii = 0; ii < numberOfReferences; ++ii) {
                ReferenceValidation validation = new ReferenceValidation();
                boolean found = false;
                boolean intact = false;
                try {
                    Reference reference = signedInfo.item(ii);
                    this.references.add(reference);
                    String id = reference.getId();
                    String uri = reference.getURI();
                    if (Utils.isStringNotBlank(id)) {
                        validation.setName(id);
                    } else if (Utils.isStringNotBlank(uri)) {
                        validation.setName(uri);
                    }
                    found = reference.getContentsBeforeTransformation() != null;
                    boolean noDuplicateIdFound = XMLUtils.protectAgainstWrappingAttack(santuarioSignature.getDocument(), DomUtils.getId(uri));
                    if (this.isSignedProperties(reference)) {
                        validation.setType(DigestMatcherType.SIGNED_PROPERTIES);
                        found = found && noDuplicateIdFound && this.findSignedPropertiesById(uri);
                        signedPropertiesFound = signedPropertiesFound || found;
                    } else if (reference.typeIsReferenceToObject()) {
                        validation.setType(DigestMatcherType.OBJECT);
                        found = found && noDuplicateIdFound && this.findObjectById(uri);
                        referenceFound = referenceFound || found;
                    } else if (reference.typeIsReferenceToManifest()) {
                        validation.setType(DigestMatcherType.MANIFEST);
                        Node manifestNode = this.getManifestById(uri);
                        found = found && noDuplicateIdFound && manifestNode != null;
                        boolean bl = referenceFound = referenceFound || found;
                        if (manifestNode != null && Utils.isCollectionNotEmpty(this.detachedContents)) {
                            ManifestValidator mv = new ManifestValidator(manifestNode, this.detachedContents, this.xPathQueryHolder);
                            this.referenceValidations.addAll(mv.validate());
                        }
                    } else {
                        validation.setType(DigestMatcherType.REFERENCE);
                        found = found && noDuplicateIdFound;
                        referenceFound = referenceFound || found;
                    }
                    Digest digest = new Digest();
                    digest.setValue(reference.getDigestValue());
                    digest.setAlgorithm(DigestAlgorithm.forXML(reference.getMessageDigestAlgorithm().getAlgorithmURI()));
                    validation.setDigest(digest);
                    intact = reference.verify();
                }
                catch (XMLSecurityException e) {
                    LOG.warn("Unable to verify reference {} : {}", (Object)ii, (Object)e.getMessage());
                }
                validation.setFound(found);
                validation.setIntact(intact);
                this.referenceValidations.add(validation);
            }
            if (!signedPropertiesFound) {
                this.referenceValidations.add(this.notFound(DigestMatcherType.SIGNED_PROPERTIES));
            }
            if (!referenceFound) {
                this.referenceValidations.add(this.notFound(DigestMatcherType.REFERENCE));
            }
        }
        return this.referenceValidations;
    }

    private boolean isSignedProperties(Reference reference) {
        return this.xPathQueryHolder.XADES_SIGNED_PROPERTIES.equals(reference.getType());
    }

    private boolean findSignedPropertiesById(String uri) {
        return this.getSignedPropertiesById(uri) != null;
    }

    private Node getSignedPropertiesById(String uri) {
        String signedPropertiesById = this.xPathQueryHolder.XPATH_SIGNED_PROPERTIES + DomUtils.getXPathByIdAttribute(uri);
        return DomUtils.getNode(this.signatureElement, signedPropertiesById);
    }

    private boolean findObjectById(String uri) {
        return this.getObjectById(uri) != null;
    }

    public Node getObjectById(String uri) {
        String objectById = "./ds:Object" + DomUtils.getXPathByIdAttribute(uri);
        return DomUtils.getNode(this.signatureElement, objectById);
    }

    public Node getManifestById(String uri) {
        String manifestById = "./ds:Object/ds:Manifest" + DomUtils.getXPathByIdAttribute(uri);
        return DomUtils.getNode(this.signatureElement, manifestById);
    }

    private ReferenceValidation notFound(DigestMatcherType type) {
        ReferenceValidation validation = new ReferenceValidation();
        validation.setType(type);
        validation.setFound(false);
        return validation;
    }

    private XMLSignature getSantuarioSignature() {
        try {
            Document document = this.signatureElement.getOwnerDocument();
            Element rootElement = document.getDocumentElement();
            DSSXMLUtils.setIDIdentifier(rootElement);
            DSSXMLUtils.recursiveIdBrowse(rootElement);
            XMLSignature santuarioSignature = new XMLSignature(this.signatureElement, "");
            if (Utils.isCollectionNotEmpty(this.detachedContents)) {
                santuarioSignature.addResourceResolver(new DetachedSignatureResolver(this.detachedContents, this.getSignatureAlgorithm().getDigestAlgorithm()));
            }
            return santuarioSignature;
        }
        catch (XMLSecurityException e) {
            throw new DSSException("Unable to initialize santuario XMLSignature", e);
        }
    }

    private List<CertificateValidity> getSigningCertificateValidityList(XMLSignature santuarioSignature, SignatureCryptographicVerification scv, CertificateToken providedSigningCertificate) throws KeyResolverException {
        List<CertificateValidity> certificateValidityList;
        if (providedSigningCertificate == null) {
            CandidatesForSigningCertificate candidates = this.getCandidatesForSigningCertificate();
            certificateValidityList = candidates.getCertificateValidityList();
            if (certificateValidityList.isEmpty()) {
                PublicKey publicKey;
                KeyInfo extractedKeyInfo = santuarioSignature.getKeyInfo();
                if (extractedKeyInfo == null || (publicKey = extractedKeyInfo.getPublicKey()) == null) {
                    scv.setErrorMessage("There is no signing certificate within the signature.");
                    return certificateValidityList;
                }
                certificateValidityList = this.getSigningCertificateValidityList(publicKey);
            }
        } else {
            this.candidatesForSigningCertificate = new CandidatesForSigningCertificate();
            CertificateValidity certificateValidity = new CertificateValidity(providedSigningCertificate);
            this.candidatesForSigningCertificate.add(certificateValidity);
            certificateValidityList = this.candidatesForSigningCertificate.getCertificateValidityList();
        }
        return certificateValidityList;
    }

    protected List<CertificateValidity> getSigningCertificateValidityList(PublicKey extractedPublicKey) {
        this.candidatesForSigningCertificate = new CandidatesForSigningCertificate();
        CertificateValidity certificateValidity = new CertificateValidity(extractedPublicKey);
        this.candidatesForSigningCertificate.add(certificateValidity);
        List<CertificateValidity> certificateValidityList = this.candidatesForSigningCertificate.getCertificateValidityList();
        return certificateValidityList;
    }

    @Override
    public List<AdvancedSignature> getCounterSignatures() {
        NodeList counterSignatures = DomUtils.getNodeList(this.signatureElement, this.xPathQueryHolder.XPATH_COUNTER_SIGNATURE);
        if (counterSignatures == null) {
            return null;
        }
        ArrayList<AdvancedSignature> xadesList = new ArrayList<AdvancedSignature>();
        for (int ii = 0; ii < counterSignatures.getLength(); ++ii) {
            Element counterSignatureElement = (Element)counterSignatures.item(ii);
            Element signatureElement = DomUtils.getElement(counterSignatureElement, this.xPathQueryHolder.XPATH__SIGNATURE);
            XAdESSignature xadesCounterSignature = new XAdESSignature(signatureElement, this.xPathQueryHolders, this.certPool);
            if (!this.isCounterSignature(xadesCounterSignature)) continue;
            xadesCounterSignature.setMasterSignature(this);
            xadesList.add(xadesCounterSignature);
        }
        return xadesList;
    }

    private boolean isCounterSignature(XAdESSignature xadesCounterSignature) {
        List<Element> signatureReferences = xadesCounterSignature.getSignatureReferences();
        for (Element reference : signatureReferences) {
            String type = reference.getAttribute("Type");
            if (!this.xPathQueryHolder.XADES_COUNTERSIGNED_SIGNATURE.equals(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<CertificateRef> getCertificateRefs() {
        Element signingCertEl = DomUtils.getElement(this.signatureElement, this.xPathQueryHolder.XPATH_CERT_REFS);
        if (signingCertEl == null) {
            return null;
        }
        ArrayList<CertificateRef> certIds = new ArrayList<CertificateRef>();
        NodeList certIdnodes = DomUtils.getNodeList(signingCertEl, "./xades:Cert");
        for (int i = 0; i < certIdnodes.getLength(); ++i) {
            Element certId = (Element)certIdnodes.item(i);
            Element issuerNameEl = DomUtils.getElement(certId, this.xPathQueryHolder.XPATH__X509_ISSUER_NAME);
            Element issuerSerialEl = DomUtils.getElement(certId, this.xPathQueryHolder.XPATH__X509_SERIAL_NUMBER);
            Element digestAlgorithmEl = DomUtils.getElement(certId, this.xPathQueryHolder.XPATH__CERT_DIGEST_DIGEST_METHOD);
            Element digestValueEl = DomUtils.getElement(certId, this.xPathQueryHolder.XPATH__CERT_DIGEST_DIGEST_VALUE);
            CertificateRef genericCertId = new CertificateRef();
            if (issuerNameEl != null && issuerSerialEl != null) {
                genericCertId.setIssuerName(issuerNameEl.getTextContent());
                genericCertId.setIssuerSerial(issuerSerialEl.getTextContent());
            }
            String xmlName = digestAlgorithmEl.getAttribute("Algorithm");
            genericCertId.setDigestAlgorithm(DigestAlgorithm.forXML(xmlName));
            genericCertId.setDigestValue(Utils.fromBase64(digestValueEl.getTextContent()));
            certIds.add(genericCertId);
        }
        return certIds;
    }

    @Override
    public List<CRLRef> getCRLRefs() {
        ArrayList<CRLRef> crlRefs = new ArrayList<CRLRef>();
        Element crlRefsElement = DomUtils.getElement(this.signatureElement, this.xPathQueryHolder.XPATH_REVOCATION_CRL_REFS);
        if (crlRefsElement != null) {
            NodeList crlRefNodes = DomUtils.getNodeList(crlRefsElement, this.xPathQueryHolder.XPATH__CRL_REF);
            for (int i = 0; i < crlRefNodes.getLength(); ++i) {
                Element crlRefNode = (Element)crlRefNodes.item(i);
                Element digestAlgorithmEl = DomUtils.getElement(crlRefNode, this.xPathQueryHolder.XPATH__DAAV_DIGEST_METHOD);
                Element digestValueEl = DomUtils.getElement(crlRefNode, this.xPathQueryHolder.XPATH__DAAV_DIGEST_VALUE);
                String xmlName = digestAlgorithmEl.getAttribute("Algorithm");
                DigestAlgorithm digestAlgo = DigestAlgorithm.forXML(xmlName);
                crlRefs.add(new CRLRef(digestAlgo, Utils.fromBase64(digestValueEl.getTextContent())));
            }
        }
        return crlRefs;
    }

    @Override
    public List<OCSPRef> getOCSPRefs() {
        ArrayList<OCSPRef> ocspRefs = new ArrayList<OCSPRef>();
        Element ocspRefsElement = DomUtils.getElement(this.signatureElement, this.xPathQueryHolder.XPATH_OCSP_REFS);
        if (ocspRefsElement != null) {
            NodeList ocspRefNodes = DomUtils.getNodeList(ocspRefsElement, this.xPathQueryHolder.XPATH__OCSPREF);
            for (int i = 0; i < ocspRefNodes.getLength(); ++i) {
                Element certId = (Element)ocspRefNodes.item(i);
                Element digestAlgorithmEl = DomUtils.getElement(certId, this.xPathQueryHolder.XPATH__DAAV_DIGEST_METHOD);
                Element digestValueEl = DomUtils.getElement(certId, this.xPathQueryHolder.XPATH__DAAV_DIGEST_VALUE);
                String xmlName = digestAlgorithmEl.getAttribute("Algorithm");
                DigestAlgorithm digestAlgo = DigestAlgorithm.forXML(xmlName);
                String digestValue = digestValueEl.getTextContent();
                byte[] base64EncodedDigestValue = Utils.fromBase64(digestValue);
                ocspRefs.add(new OCSPRef(digestAlgo, base64EncodedDigestValue, false));
            }
        }
        return ocspRefs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getSignatureTimestampData(TimestampToken timestampToken, String canonicalizationMethod) {
        canonicalizationMethod = timestampToken != null ? timestampToken.getCanonicalizationMethod() : canonicalizationMethod;
        try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
            this.writeCanonicalizedValue(this.xPathQueryHolder.XPATH_SIGNATURE_VALUE, canonicalizationMethod, buffer);
            byte[] byteArray = buffer.toByteArray();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Signature timestamp canonicalized string : \n{}", (Object)new String(byteArray));
            }
            byte[] byArray = byteArray;
            return byArray;
        }
        catch (IOException e) {
            throw new DSSException("Error when computing the SignatureTimestamp", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getTimestampX1Data(TimestampToken timestampToken, String canonicalizationMethod) {
        canonicalizationMethod = timestampToken != null ? timestampToken.getCanonicalizationMethod() : canonicalizationMethod;
        try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
            this.writeCanonicalizedValue(this.xPathQueryHolder.XPATH_SIGNATURE_VALUE, canonicalizationMethod, buffer);
            NodeList signatureTimeStampNode = DomUtils.getNodeList(this.signatureElement, this.xPathQueryHolder.XPATH_SIGNATURE_TIMESTAMP);
            if (signatureTimeStampNode != null) {
                for (int ii = 0; ii < signatureTimeStampNode.getLength(); ++ii) {
                    Node item = signatureTimeStampNode.item(ii);
                    byte[] canonicalizedValue = DSSXMLUtils.canonicalizeSubtree(canonicalizationMethod, item);
                    buffer.write(canonicalizedValue);
                }
            }
            this.writeCanonicalizedValue(this.xPathQueryHolder.XPATH_COMPLETE_CERTIFICATE_REFS, canonicalizationMethod, buffer);
            this.writeCanonicalizedValue(this.xPathQueryHolder.XPATH_COMPLETE_REVOCATION_REFS, canonicalizationMethod, buffer);
            byte[] byteArray = buffer.toByteArray();
            if (LOG.isTraceEnabled()) {
                LOG.trace("X1Timestamp (SigAndRefsTimeStamp) canonicalised string : \n{}", (Object)new String(byteArray));
            }
            byte[] byArray = byteArray;
            return byArray;
        }
        catch (IOException e) {
            throw new DSSException("Error when computing the SigAndRefsTimeStamp (X1Timestamp)", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getTimestampX2Data(TimestampToken timestampToken, String canonicalizationMethod) {
        canonicalizationMethod = timestampToken != null ? timestampToken.getCanonicalizationMethod() : canonicalizationMethod;
        try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
            this.writeCanonicalizedValue(this.xPathQueryHolder.XPATH_COMPLETE_CERTIFICATE_REFS, canonicalizationMethod, buffer);
            this.writeCanonicalizedValue(this.xPathQueryHolder.XPATH_COMPLETE_REVOCATION_REFS, canonicalizationMethod, buffer);
            byte[] byteArray = buffer.toByteArray();
            if (LOG.isTraceEnabled()) {
                LOG.trace("TimestampX2Data (RefsOnlyTimeStamp) canonicalised string : \n{}", (Object)new String(byteArray));
            }
            byte[] byArray = byteArray;
            return byArray;
        }
        catch (IOException e) {
            throw new DSSException("Error when computing the RefsOnlyTimeStamp (TimestampX2D)", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getArchiveTimestampData(TimestampToken timestampToken, String canonicalizationMethod) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("--->Get archive timestamp data:" + (timestampToken == null ? "--> CREATION" : "--> VALIDATION"));
        }
        canonicalizationMethod = timestampToken != null ? timestampToken.getCanonicalizationMethod() : canonicalizationMethod;
        try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
            HashSet<String> referenceURIs = new HashSet<String>();
            for (Reference reference : this.references) {
                referenceURIs.add(this.cleanURI(reference.getURI()));
                try {
                    byte[] referencedBytes = reference.getReferencedBytes();
                    if (referencedBytes != null) {
                        buffer.write(referencedBytes);
                        continue;
                    }
                    LOG.warn("No binaries found for URI '{}'", (Object)reference.getURI());
                }
                catch (XMLSecurityException e) {
                    LOG.warn("Unable to retrieve content for URI '{}' : {}", (Object)reference.getURI(), (Object)e.getMessage());
                }
            }
            this.writeCanonicalizedValue(this.xPathQueryHolder.XPATH_SIGNED_INFO, canonicalizationMethod, buffer);
            this.writeCanonicalizedValue(this.xPathQueryHolder.XPATH_SIGNATURE_VALUE, canonicalizationMethod, buffer);
            this.writeCanonicalizedValue(this.xPathQueryHolder.XPATH_KEY_INFO, canonicalizationMethod, buffer);
            Element unsignedSignaturePropertiesDom = this.getUnsignedSignaturePropertiesDom();
            if (unsignedSignaturePropertiesDom == null) {
                throw new NullPointerException(this.xPathQueryHolder.XPATH_UNSIGNED_SIGNATURE_PROPERTIES);
            }
            NodeList unsignedProperties = unsignedSignaturePropertiesDom.getChildNodes();
            for (int ii = 0; ii < unsignedProperties.getLength(); ++ii) {
                byte[] canonicalizedValue;
                Node node = unsignedProperties.item(ii);
                if (node.getNodeType() != 1) continue;
                String localName = node.getLocalName();
                if ("ArchiveTimeStamp".equals(localName)) {
                    if (timestampToken != null && timestampToken.getHashCode() == node.hashCode()) {
                        break;
                    }
                } else if ("TimeStampValidationData".equals(localName)) {
                    // empty if block
                }
                if (timestampToken == null) {
                    byte[] bytesToCanonicalize = DSSXMLUtils.serializeNode(node);
                    canonicalizedValue = DSSXMLUtils.canonicalize(canonicalizationMethod, bytesToCanonicalize);
                } else {
                    canonicalizedValue = DSSXMLUtils.canonicalizeOrSerializeSubtree(canonicalizationMethod, node);
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("{}: Canonicalization: {} : \n", localName, canonicalizationMethod, new String(canonicalizedValue));
                }
                buffer.write(canonicalizedValue);
            }
            boolean xades141 = timestampToken == null || !ArchiveTimestampType.XAdES.equals((Object)timestampToken.getArchiveTimestampType());
            NodeList objects = this.getObjects();
            int ii = 0;
            while (true) {
                block35: {
                    Node node;
                    block36: {
                        boolean contains;
                        String id;
                        int length;
                        NamedNodeMap attributes;
                        block37: {
                            block34: {
                                if (ii >= objects.getLength()) break block34;
                                node = objects.item(ii);
                                Element qualifyingProperties = DomUtils.getElement(node, this.xPathQueryHolder.XPATH__QUALIFYING_PROPERTIES);
                                if (qualifyingProperties != null) break block35;
                                if (xades141) break block36;
                                attributes = node.getAttributes();
                                length = attributes.getLength();
                                id = "";
                                break block37;
                            }
                            byte[] byArray = buffer.toByteArray();
                            return byArray;
                        }
                        for (int jj = 0; jj < length; ++jj) {
                            Node item = attributes.item(jj);
                            String nodeName = item.getNodeName();
                            if (!Utils.areStringsEqualIgnoreCase("ID", nodeName)) continue;
                            id = item.getNodeValue();
                            break;
                        }
                        if (contains = referenceURIs.contains(id)) break block35;
                    }
                    byte[] canonicalizedValue = DSSXMLUtils.canonicalizeOrSerializeSubtree(canonicalizationMethod, node);
                    buffer.write(canonicalizedValue);
                }
                ++ii;
            }
        }
        catch (IOException e) {
            throw new DSSException("Error when computing the archive data", e);
        }
    }

    private String cleanURI(String uri) {
        if (uri.startsWith("#")) {
            return uri.substring(1);
        }
        return uri;
    }

    private void writeCanonicalizedValue(String xPathString, String canonicalizationMethod, ByteArrayOutputStream buffer) throws IOException {
        Element element = DomUtils.getElement(this.signatureElement, xPathString);
        if (element != null) {
            buffer.write(DSSXMLUtils.canonicalizeOrSerializeSubtree(canonicalizationMethod, element));
        }
    }

    @Override
    public String getId() {
        if (this.signatureId == null) {
            String idValue = DSSXMLUtils.getIDIdentifier(this.signatureElement);
            if (idValue != null) {
                this.signatureId = idValue;
            } else {
                CertificateToken certificateToken = this.getSigningCertificateToken();
                TokenIdentifier identifier = certificateToken == null ? null : certificateToken.getDSSId();
                this.signatureId = DSSUtils.getDeterministicId(this.getSigningTime(), identifier);
            }
        }
        return this.signatureId;
    }

    @Override
    public List<TimestampReference> getTimestampedReferences() {
        Element completeRevocationRefsNode;
        ArrayList<TimestampReference> references = new ArrayList<TimestampReference>();
        Element completeCertificateRefsNode = DomUtils.getElement(this.signatureElement, this.xPathQueryHolder.XPATH_COMPLETE_CERTIFICATE_REFS);
        if (completeCertificateRefsNode != null) {
            NodeList nodes = DomUtils.getNodeList(completeCertificateRefsNode, this.xPathQueryHolder.XPATH__COMPLETE_CERTIFICATE_REFS__CERT_DIGEST);
            for (int ii = 0; ii < nodes.getLength(); ++ii) {
                Element certDigestElement = (Element)nodes.item(ii);
                TimestampReference certificateReference = this.createCertificateTimestampReference(certDigestElement);
                references.add(certificateReference);
            }
        }
        if ((completeRevocationRefsNode = DomUtils.getElement(this.signatureElement, this.xPathQueryHolder.XPATH_COMPLETE_REVOCATION_REFS)) != null) {
            NodeList nodes = DomUtils.getNodeList(completeRevocationRefsNode, "./*/*/xades:DigestAlgAndValue");
            for (int ii = 0; ii < nodes.getLength(); ++ii) {
                Element element = (Element)nodes.item(ii);
                TimestampReference revocationReference = this.createRevocationTimestampReference(element);
                references.add(revocationReference);
            }
        }
        return references;
    }

    private TimestampReference createRevocationTimestampReference(Element element) {
        String digestAlgorithmStr = DomUtils.getNode(element, this.xPathQueryHolder.XPATH__DIGEST_METHOD_ALGORITHM).getTextContent();
        DigestAlgorithm digestAlgorithm = DigestAlgorithm.forXML(digestAlgorithmStr);
        String digestValue = DomUtils.getElement(element, this.xPathQueryHolder.XPATH__DIGEST_VALUE).getTextContent();
        TimestampReference revocationReference = new TimestampReference(digestAlgorithm, digestValue);
        return revocationReference;
    }

    public List<String> getUnsignedSignatureProperties() {
        List<String> childrenNames = DomUtils.getChildrenNames(this.signatureElement, this.xPathQueryHolder.XPATH_UNSIGNED_SIGNATURE_PROPERTIES);
        return childrenNames;
    }

    public List<String> getSignedSignatureProperties() {
        List<String> childrenNames = DomUtils.getChildrenNames(this.signatureElement, this.xPathQueryHolder.XPATH_SIGNED_SIGNATURE_PROPERTIES);
        return childrenNames;
    }

    public List<String> getSignedProperties() {
        List<String> childrenNames = DomUtils.getChildrenNames(this.signatureElement, this.xPathQueryHolder.XPATH_SIGNED_PROPERTIES);
        return childrenNames;
    }

    public List<String> getUnsignedProperties() {
        List<String> childrenNames = DomUtils.getChildrenNames(this.signatureElement, this.xPathQueryHolder.XPATH_UNSIGNED_PROPERTIES);
        return childrenNames;
    }

    public List<String> getSignedDataObjectProperties() {
        List<String> childrenNames = DomUtils.getChildrenNames(this.signatureElement, this.xPathQueryHolder.XPATH_SIGNED_DATA_OBJECT_PROPERTIES);
        return childrenNames;
    }

    private TimestampReference createCertificateTimestampReference(Element element) throws DSSException {
        String xmlDigestAlgorithm = DomUtils.getNode(element, this.xPathQueryHolder.XPATH__DIGEST_METHOD_ALGORITHM).getTextContent();
        DigestAlgorithm digestAlgorithm = DigestAlgorithm.forXML(xmlDigestAlgorithm);
        this.usedCertificatesDigestAlgorithms.add(digestAlgorithm);
        Element digestValueElement = DomUtils.getElement(element, this.xPathQueryHolder.XPATH__DIGEST_VALUE);
        String digestValue = digestValueElement == null ? "" : digestValueElement.getTextContent();
        TimestampReference reference = new TimestampReference(digestAlgorithm, digestValue);
        return reference;
    }

    private TimestampReference createCertificateTimestampReference(CertificateToken certificateToken) throws DSSException {
        this.usedCertificatesDigestAlgorithms.add(DigestAlgorithm.SHA1);
        TimestampReference reference = new TimestampReference(DigestAlgorithm.SHA1, Utils.toBase64(certificateToken.getDigest(DigestAlgorithm.SHA1)));
        return reference;
    }

    @Override
    public boolean isDataForSignatureLevelPresent(SignatureLevel signatureLevel) {
        boolean dataForLevelPresent = true;
        switch (signatureLevel) {
            case XML_NOT_ETSI: {
                break;
            }
            case XAdES_BASELINE_LTA: {
                dataForLevelPresent = this.hasLTAProfile();
                dataForLevelPresent = dataForLevelPresent && this.isDataForSignatureLevelPresent(SignatureLevel.XAdES_BASELINE_LT);
                break;
            }
            case XAdES_BASELINE_LT: {
                dataForLevelPresent = this.hasLTProfile();
                dataForLevelPresent = dataForLevelPresent && this.isDataForSignatureLevelPresent(SignatureLevel.XAdES_BASELINE_T);
                break;
            }
            case XAdES_BASELINE_T: {
                dataForLevelPresent = this.hasTProfile();
                dataForLevelPresent = dataForLevelPresent && this.isDataForSignatureLevelPresent(SignatureLevel.XAdES_BASELINE_B);
                break;
            }
            case XAdES_BASELINE_B: {
                dataForLevelPresent = this.hasBProfile();
                break;
            }
            case XAdES_X: {
                dataForLevelPresent = this.hasXProfile();
                dataForLevelPresent = dataForLevelPresent && this.isDataForSignatureLevelPresent(SignatureLevel.XAdES_C);
                break;
            }
            case XAdES_C: {
                dataForLevelPresent = this.hasCProfile();
                dataForLevelPresent = dataForLevelPresent && this.isDataForSignatureLevelPresent(SignatureLevel.XAdES_BASELINE_T);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown level " + (Object)((Object)signatureLevel));
            }
        }
        return dataForLevelPresent;
    }

    @Override
    public SignatureLevel[] getSignatureLevels() {
        return signatureLevels;
    }

    @Override
    public void validateStructure() {
        String string = DomUtils.xmlToString(this.signatureElement);
        StringReader stringReader = new StringReader(string);
        this.structureValidation = DSSXMLUtils.validateAgainstXSD(new StreamSource(stringReader));
    }

    public Element getLastTimestampValidationData() {
        List<TimestampToken> archiveTimestamps = this.getArchiveTimestamps();
        TimestampToken mostRecentTimestamp = null;
        for (TimestampToken archiveTimestamp : archiveTimestamps) {
            Date mostRecentGenerationTime;
            if (mostRecentTimestamp == null) {
                mostRecentTimestamp = archiveTimestamp;
                continue;
            }
            Date generationTime = archiveTimestamp.getGenerationTime();
            if (!generationTime.after(mostRecentGenerationTime = mostRecentTimestamp.getGenerationTime())) continue;
            mostRecentTimestamp = archiveTimestamp;
        }
        if (mostRecentTimestamp != null) {
            int timestampHashCode = mostRecentTimestamp.getHashCode();
            NodeList nodeList = DomUtils.getNodeList(this.signatureElement, this.xPathQueryHolder.XPATH_UNSIGNED_SIGNATURE_PROPERTIES + "/*");
            boolean found = false;
            for (int ii = 0; ii < nodeList.getLength(); ++ii) {
                String nodeName;
                Element unsignedSignatureElement = (Element)nodeList.item(ii);
                int nodeHashCode = unsignedSignatureElement.hashCode();
                if (nodeHashCode == timestampHashCode) {
                    found = true;
                    continue;
                }
                if (!found || !"TimeStampValidationData".equals(nodeName = unsignedSignatureElement.getLocalName())) continue;
                return unsignedSignatureElement;
            }
        }
        return null;
    }

    @Override
    public CommitmentType getCommitmentTypeIndication() {
        CommitmentType result = null;
        NodeList nodeList = DomUtils.getNodeList(this.signatureElement, this.xPathQueryHolder.XPATH_COMMITMENT_IDENTIFICATION);
        if (nodeList != null && nodeList.getLength() > 0) {
            result = new CommitmentType();
            for (int ii = 0; ii < nodeList.getLength(); ++ii) {
                result.addIdentifier(DomUtils.getValue(nodeList.item(ii), this.xPathQueryHolder.XPATH_COMITMENT_IDENTIFIERS));
            }
        }
        return result;
    }

    public List<Element> getSignatureReferences() {
        NodeList list = DomUtils.getNodeList(this.signatureElement, this.xPathQueryHolder.XPATH_REFERENCE);
        ArrayList<Element> references = new ArrayList<Element>(list.getLength());
        for (int ii = 0; ii < list.getLength(); ++ii) {
            Node node = list.item(ii);
            references.add((Element)node);
        }
        return references;
    }

    public List<Reference> getReferences() {
        return this.references;
    }

    public List<Element> getSignatureObjects() {
        NodeList list = DomUtils.getNodeList(this.signatureElement, "./ds:Object");
        ArrayList<Element> references = new ArrayList<Element>(list.getLength());
        for (int ii = 0; ii < list.getLength(); ++ii) {
            Node node = list.item(ii);
            Element element = (Element)node;
            if (DomUtils.getElement(element, this.xPathQueryHolder.XPATH__QUALIFYING_PROPERTIES_SIGNED_PROPERTIES) != null) continue;
            references.add(element);
        }
        return references;
    }

    public void registerXPathQueryHolder(XPathQueryHolder xPathQueryHolder) {
        this.xPathQueryHolders.add(xPathQueryHolder);
    }

    public Element getUnsignedSignaturePropertiesDom() {
        return DomUtils.getElement(this.signatureElement, this.xPathQueryHolder.XPATH_UNSIGNED_SIGNATURE_PROPERTIES);
    }

    public Element getUnsignedPropertiesDom() {
        return DomUtils.getElement(this.signatureElement, this.xPathQueryHolder.XPATH_UNSIGNED_PROPERTIES);
    }

    public Element getQualifyingPropertiesDom() {
        return DomUtils.getElement(this.signatureElement, this.xPathQueryHolder.XPATH_QUALIFYING_PROPERTIES);
    }

    static {
        SantuarioInitializer.init();
        JCEMapper.setProviderId("BC");
        JCEMapper.Algorithm notStandardAlgorithm = new JCEMapper.Algorithm("", SignatureAlgorithm.RSA_RIPEMD160.getJCEId(), "Signature");
        JCEMapper.register("http://www.w3.org/2001/04/xmldsig-more/rsa-ripemd160", notStandardAlgorithm);
        try {
            org.apache.xml.security.algorithms.SignatureAlgorithm.register("http://www.w3.org/2001/04/xmldsig-more/rsa-ripemd160", SignatureRSARIPEMD160AT.class);
        }
        catch (Exception e) {
            LOG.error("ECDSA_RIPEMD160AT algorithm initialisation failed.", e);
        }
    }
}

