/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.InMemoryDocument;
import eu.europa.esig.dss.MimeType;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.SignatureCryptographicVerification;
import eu.europa.esig.dss.validation.SignedDocumentValidator;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.XPathQueryHolder;
import eu.europa.esig.dss.xades.validation.XAdES111XPathQueryHolder;
import eu.europa.esig.dss.xades.validation.XAdES122XPathQueryHolder;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import eu.europa.esig.dss.xades.validation.XAdESSignatureScopeFinder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.XMLSignatureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLDocumentValidator
extends SignedDocumentValidator {
    private static final Logger LOG = LoggerFactory.getLogger(XMLDocumentValidator.class);
    private static final byte[] xmlPreamble = new byte[]{60, 63, 120, 109, 108};
    private static final byte[] xmlUtf8 = new byte[]{-17, -69, -65, 60, 63};
    protected List<XPathQueryHolder> xPathQueryHolders;
    protected Document rootElement;
    private List<AdvancedSignature> signatures;

    private XMLDocumentValidator() {
        super(null);
    }

    public XMLDocumentValidator(DSSDocument dssDocument) {
        super(new XAdESSignatureScopeFinder());
        this.document = dssDocument;
        this.rootElement = DomUtils.buildDOM(dssDocument);
        this.xPathQueryHolders = new ArrayList<XPathQueryHolder>();
        XAdES111XPathQueryHolder xades111xPathQueryHolder = new XAdES111XPathQueryHolder();
        this.xPathQueryHolders.add(xades111xPathQueryHolder);
        XAdES122XPathQueryHolder xades122XPathQueryHolder = new XAdES122XPathQueryHolder();
        this.xPathQueryHolders.add(xades122XPathQueryHolder);
        XPathQueryHolder xPathQueryHolder = new XPathQueryHolder();
        this.xPathQueryHolders.add(xPathQueryHolder);
    }

    @Override
    public boolean isSupported(DSSDocument dssDocument) {
        MimeType documentMimeType = dssDocument.getMimeType();
        if (documentMimeType != null && MimeType.XML.equals(documentMimeType)) {
            return true;
        }
        String dssDocumentName = dssDocument.getName();
        if (dssDocumentName != null && MimeType.XML.equals(MimeType.fromFileName(dssDocumentName))) {
            return true;
        }
        int headerLength = xmlPreamble.length;
        byte[] preamble = new byte[headerLength];
        DSSUtils.readToArray(dssDocument, headerLength, preamble);
        return Arrays.equals(preamble, xmlPreamble) || Arrays.equals(preamble, xmlUtf8);
    }

    @Override
    public List<AdvancedSignature> getSignatures() {
        if (this.signatures != null) {
            return this.signatures;
        }
        this.signatures = new ArrayList<AdvancedSignature>();
        NodeList signatureNodeList = DomUtils.getNodeList(this.rootElement, "//ds:Signature[not(parent::xades:CounterSignature)]");
        for (int ii = 0; ii < signatureNodeList.getLength(); ++ii) {
            Element signatureEl = (Element)signatureNodeList.item(ii);
            XAdESSignature xadesSignature = new XAdESSignature(signatureEl, this.xPathQueryHolders, this.validationCertPool);
            xadesSignature.setSignatureFilename(this.document.getName());
            xadesSignature.setDetachedContents(this.detachedContents);
            xadesSignature.setProvidedSigningCertificateToken(this.providedSigningCertificateToken);
            this.signatures.add(xadesSignature);
        }
        return this.signatures;
    }

    public AdvancedSignature getSignatureById(String signatureId) throws DSSException {
        if (Utils.isStringBlank(signatureId)) {
            throw new NullPointerException("signatureId");
        }
        List<AdvancedSignature> advancedSignatures = this.getSignatures();
        for (AdvancedSignature advancedSignature : advancedSignatures) {
            String advancedSignatureId = advancedSignature.getId();
            if (!signatureId.equals(advancedSignatureId)) continue;
            return advancedSignature;
        }
        throw new DSSException("The signature with the given id was not found!");
    }

    @Override
    public List<DSSDocument> getOriginalDocuments(String signatureId) throws DSSException {
        if (Utils.isStringBlank(signatureId)) {
            throw new NullPointerException("signatureId");
        }
        ArrayList<DSSDocument> result = new ArrayList<DSSDocument>();
        NodeList signatureNodeList = this.rootElement.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        List<AdvancedSignature> signatureList = this.getSignatures();
        for (int ii = 0; ii < signatureNodeList.getLength(); ++ii) {
            Element signatureEl = (Element)signatureNodeList.item(ii);
            String idIdentifier = DSSXMLUtils.getIDIdentifier(signatureEl);
            if (!signatureId.equals(idIdentifier)) continue;
            XAdESSignature signature = (XAdESSignature)signatureList.get(ii);
            signature.checkSignatureIntegrity();
            SignatureCryptographicVerification signatureCryptographicVerification = signature.getSignatureCryptographicVerification();
            if (!signatureCryptographicVerification.isSignatureValid()) break;
            XPathQueryHolder xPathQueryHolder = signature.getXPathQueryHolder();
            List<Reference> references = signature.getReferences();
            if (references.isEmpty()) continue;
            for (Reference reference : references) {
                if (xPathQueryHolder.XADES_SIGNED_PROPERTIES.equals(reference.getType())) continue;
                if (reference.typeIsReferenceToObject()) {
                    List<Element> signatureObjects = signature.getSignatureObjects();
                    for (Element sigObject : signatureObjects) {
                        if (!Utils.endsWithIgnoreCase(reference.getURI(), sigObject.getAttribute("Id"))) continue;
                        Node firstChild = sigObject.getFirstChild();
                        if (firstChild.getNodeType() == 1) {
                            result.add(new InMemoryDocument(DSSXMLUtils.serializeNode(firstChild)));
                            continue;
                        }
                        if (firstChild.getNodeType() != 3) continue;
                        result.add(new InMemoryDocument(Utils.fromBase64(firstChild.getTextContent())));
                    }
                    continue;
                }
                try {
                    result.add(new InMemoryDocument(reference.getReferencedBytes(), reference.getURI()));
                }
                catch (XMLSignatureException e) {
                    LOG.warn("Unable to retrieve reference {}", (Object)reference.getId(), (Object)e);
                }
            }
        }
        return result;
    }

    public List<XPathQueryHolder> getXPathQueryHolder() {
        return this.xPathQueryHolders;
    }

    public void addXPathQueryHolder(XPathQueryHolder xPathQueryHolder) {
        this.xPathQueryHolders.add(xPathQueryHolder);
    }

    public void clearQueryHolders() {
        this.xPathQueryHolders.clear();
    }

    public Document getRootElement() {
        return this.rootElement;
    }
}

